package com.ejianc.business.fill.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.fill.vo.WeekFillDetailVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.apache.commons.lang3.StringUtils;

/**
 * 周进度计划填报详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zjkjprogress_week_fill_detail")
public class WeekFillDetailEntity extends ProgressDetailEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="task_line")
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    @TableField(value="node_level")
    private Integer nodeLevel; // 节点级别
    @TableField(value="plan_start")
    private Date planStart; // 计划开始日期
    @TableField(value="plan_finish")
    private Date planFinish; // 计划完成日期
    @TableField(value="estimate_finish")
    private Date estimateFinish; // 预计完成日期
    @TableField(value="employee_id")
    private Long employeeId; // 负责人主键
    @TableField(value="employee_name")
    private String employeeName; // 负责人名称
    @TableField(value="plan_num")
    private BigDecimal planNum; // 工程量
    @TableField(value="finish_num")
    private BigDecimal finishNum; // 完成工程量
    @TableField(value="unit")
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    @TableField(value="diff_value")
    private BigDecimal diffValue; // 偏差时间
    @TableField(value="diff_type")
    private Long diffType; // 偏差原因类型
    @TableField(value="diff_resson")
    private String diffResson; // 偏差原因
    @TableField(value="resource_name")
    private String resourceName; // 资源名称
    @TableField(value="type")
    private Integer type; // 资源类型(劳动力、材料、机械)
    @TableField(value="type_unit")
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    @TableField(value="need_num")
    private BigDecimal needNum; // 需求量
    @TableField(value="resource_num")
    private BigDecimal resourceNum; // 实际资源量
    @TableField(value="diff_num")
    private BigDecimal diffNum; // 资源偏差
    @TableField(value="current_complete")
    private BigDecimal currentComplete; // 本期完成百分比

    @TableField(exist=false)
    private List<WeekFillDetailEntity> children = new ArrayList<>();// 子任务

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    public Date getPlanStart() {
        return planStart;
    }

    public void setPlanStart(Date planStart) {
        this.planStart = planStart;
    }
    public Date getPlanFinish() {
        return planFinish;
    }

    public void setPlanFinish(Date planFinish) {
        this.planFinish = planFinish;
    }
    public Date getEstimateFinish() {
        return estimateFinish;
    }

    public void setEstimateFinish(Date estimateFinish) {
        this.estimateFinish = estimateFinish;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }
    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }
    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }
    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }
    public Long getDiffType() {
        return diffType;
    }

    public void setDiffType(Long diffType) {
        this.diffType = diffType;
    }
    public String getDiffResson() {
        return diffResson;
    }

    public void setDiffResson(String diffResson) {
        this.diffResson = diffResson;
    }
    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }
    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }
    public BigDecimal getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(BigDecimal resourceNum) {
        this.resourceNum = resourceNum;
    }
    public BigDecimal getDiffNum() {
        return diffNum;
    }

    public void setDiffNum(BigDecimal diffNum) {
        this.diffNum = diffNum;
    }


    public List<WeekFillDetailEntity> getChildren() {
        return children;
    }

    public void setChildren(List<WeekFillDetailEntity> children) {
        this.children = children;
    }

    public BigDecimal getCurrentComplete() {
        return currentComplete;
    }

    public void setCurrentComplete(BigDecimal currentComplete) {
        this.currentComplete = currentComplete;
    }

    /**
     * entity to vo
     */
    public static WeekFillDetailVO convertEntityToVo(WeekFillDetailEntity entity) {
        WeekFillDetailEntity copy = BeanMapper.map(entity, WeekFillDetailEntity.class);
        Long id = copy.getId();
        copy.setId(1L);
        String predecessorLink = copy.getPredecessorLink();
        copy.setPredecessorLink(null);
        String assignments = copy.getAssignments();
        copy.setAssignments(null);
        WeekFillDetailVO vo = BeanMapper.map(copy, WeekFillDetailVO.class);
        vo.setUid(id.toString());
        vo.setProjectUID(copy.getProjectId());
        vo.setParentTaskUID(copy.getParentId() + "");
        if (StringUtils.isNotBlank(assignments)) {
            vo.setAssignments(JSON.parseArray(assignments));
        }
        vo.setNote(copy.getNotes());
        vo.setId(copy.getTid());
        if(StringUtils.isNotBlank(predecessorLink)) {
            vo.setPredecessorLink(JSON.parseArray(predecessorLink));
        }
        return vo;
    }

    /**
     * vo to entity
     */
    public static WeekFillDetailEntity convertVoToEntity(WeekFillDetailVO vo) {
        WeekFillDetailEntity entity = BeanMapper.map(vo, WeekFillDetailEntity.class);
        if(StringUtils.isNotBlank(vo.getUid())) {
            entity.setId(Long.parseLong(vo.getUid()));
        }
        entity.setProjectId(vo.getProjectUID());
        if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
            entity.setParentId(Long.parseLong(vo.getParentTaskUID()));
        }
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            entity.setAssignments(JSON.toJSONString(vo.getAssignments()));
        }
        entity.setNotes(vo.getNote());
        entity.setTid(vo.getId());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            entity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
        }
        return entity;
    }
}
