package com.ejianc.business.fill.controller;

import java.io.Serializable;

import com.ejianc.business.fill.bean.DayFillDetailEntity;
import com.ejianc.business.fill.service.IDayFillDetailService;
import com.ejianc.business.fill.vo.DayFillDetailVO;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fill.bean.DayFillEntity;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.fill.vo.DayFillVO;

/**
 * 日进度计划填报
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dayFill")
public class DayFillController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDayFillDetailService detailService;
    @Autowired
    private IDayFillService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DayFillVO> saveOrUpdate(@RequestBody DayFillVO saveOrUpdateVO) {
        // 日历的例外日期普加加载后有问题
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getCalendars())){
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        CommonResponse<DayFillVO> response = service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DayFillVO> queryDetail(Long id) {
        DayFillVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DayFillVO> vos) {
        List<Long> ids = vos.stream().map(DayFillVO::getId).collect(Collectors.toList());
        service.removeByIds(ids, true);
        detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DayFillVO>> queryList(@RequestBody QueryParam param) {
/** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("fillUserName");
        fuzzyFields.add("updateUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        // 根据项目和结构码联查对应日反馈
        if(param.getParams().containsKey("structCode")){
            Long projectId = Long.valueOf(String.valueOf(param.getParams().get("projectId").getValue()));
            String structCode = String.valueOf(param.getParams().get("structCode").getValue());
            param.getParams().remove("projectId");
            param.getParams().remove("structCode");
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            // 非末级showState可能为0，用结构码右匹配查询是否显示
            queryParam.getParams().put("structCode", new Parameter(QueryParam.LIKE_RIGHT, structCode));
            queryParam.getParams().put("showState", new Parameter(QueryParam.EQ, 1));
            queryParam.getParams().put("actualStart", new Parameter(QueryParam.NE, null));
            List<DayFillDetailEntity> detailList = detailService.queryList(queryParam);
            if(CollectionUtils.isEmpty(detailList)){
                return CommonResponse.success("数据为空！", new Page<>());
            }
            List<Long> progressIds = detailList.stream().map(DayFillDetailEntity::getProgressId).collect(Collectors.toList());
            param.getParams().put("id", new Parameter(QueryParam.IN, progressIds));
        }
        IPage<DayFillEntity> page = service.queryPage(param, false);
        IPage<DayFillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DayFillVO> totalPlanVOS = BeanMapper.mapList(page.getRecords(), DayFillVO.class);
        pageData.setRecords(totalPlanVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DayFillEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DayFill-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDayFillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DayFillVO>> refDayFillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DayFillEntity> page = service.queryPage(param,false);
        IPage<DayFillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DayFillVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @RequestMapping(value = "/getExecPlan", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map> exportxml(@RequestBody DayFillVO vo) {
        return CommonResponse.success("查询参照数据成功！",service.getExecPlan(vo));
    }

    @RequestMapping(value = "/resetExecPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DayFillVO> resetExecPlan(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.resetExecPlan(id));
    }
    @RequestMapping(value = "/getExecPlanMobile", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map> exportxmlMobile(@RequestBody DayFillVO vo) {
        return CommonResponse.success("查询参照数据成功！",service.getExecPlanMobile(vo));
    }

    /**
     * @Description queryList 项目日偏差统计分析表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/projectDiffTypeList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> projectDiffTypeList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.projectDiffTypeList(param));
    }

    /**
     * @Description 项目日偏差统计分析表导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/exportDiffTypeList", method = RequestMethod.POST)
    @ResponseBody
    public void exportDiffTypeList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        JSONObject json = service.projectDiffTypeList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", json.getJSONArray("records"));
        ExcelExport.getInstance().export("diffTypeList-export.xlsx", beans, response);
    }
}
