package com.ejianc.business.fill.util;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yqls
 * @date 2022-11-24 18:43:33
 */
public class AddressUtil {
    private static Logger logger = LoggerFactory.getLogger(AddressUtil.class);

    public static JSONObject getAddresses(String ip){
        StringBuffer result = new StringBuffer();
        try {
            URL url = new URL("http://whois.pconline.com.cn/ipJson.jsp?json=true&ip=" + ip);
            URLConnection conn = url.openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "GBK"));
            String line = null;
            while((line = reader.readLine()) != null) {
                result.append(line);
            }
            reader.close();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject json = JSONObject.parseObject(result.toString());
        logger.info(json.toJSONString());
        return json;
    }

    public static Map<String, String> getAddressByIp(String ip){
        JSONObject json = getAddresses(ip);
        Map<String, String> map = new HashMap<>();
        String province = json.getString("pro");
        String city = json.getString("city");
        logger.info("省份： {}，城市： {}", province, city);
        map.put("province", province);//省
        map.put("city", city);//市
        return map;
    }
}