package com.ejianc.business.plan.controller;

import java.io.Serializable;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.TotalPlanDetailEntity;
import com.ejianc.business.plan.cons.PlanCloumCons;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.ITotalPlanDetailService;
import com.ejianc.business.plan.service.impl.TotalPlanBpmServiceImpl;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.vo.TotalPlanVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 总计划
 *
 * @author generator
 */
@Controller
@RequestMapping("totalPlan")
public class TotalPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ITotalPlanService service;
    @Autowired
    private ITotalPlanDetailService detailService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CommonHelper commonHelper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalPlanVO> saveOrUpdate(@RequestBody TotalPlanVO saveOrUpdateVO) {
        // 日历的例外日期普加加载后有问题
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getCalendars())){
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        CommonResponse<TotalPlanVO> response = service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TotalPlanVO> queryDetail(Long id) {
        TotalPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param projectId
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TotalPlanVO> queryByProjectId(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<TotalPlanEntity> list = service.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return CommonResponse.error("该项目下没有查询到对应总计划！");
        }
        TotalPlanVO vo = service.queryDetail(list.get(0).getId());
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TotalPlanVO> vos) {
        List<Long> ids = vos.stream().map(TotalPlanVO::getId).collect(Collectors.toList());
        service.removeByIds(ids, true);
        detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TotalPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<TotalPlanEntity> page = service.queryPage(param, false);
        IPage<TotalPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<TotalPlanVO> totalPlanVOS = BeanMapper.mapList(page.getRecords(), TotalPlanVO.class);
        totalPlanVOS.forEach(vo -> {
            vo.setChangeStatusName(PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
            vo.setChangeVersionName("第" + NumberUtil.int2chineseNum(vo.getChangeVersion()) + "版");
        });
        pageData.setRecords(totalPlanVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TotalPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TotalPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refTotalPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TotalPlanVO>> refTotalPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TotalPlanEntity> page = service.queryPage(param, false);
        IPage<TotalPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TotalPlanVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/getxml", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return service.getxml(request);
    }

    @RequestMapping(value = "/exportxml", method = RequestMethod.POST)
    @ResponseBody
    public void exportxml(HttpServletResponse response,@RequestBody XmlVO vo) {
        service.exportxml(response, vo);
    }

    /*@Autowired
    private TotalPlanBpmServiceImpl bpmService;

    @RequestMapping(value = "/abc", method = RequestMethod.POST)
    @ResponseBody
    public void abc() {
        bpmService.beforeSubmitProcessor(1542094944489611266L,null,null);
    }*/

}
