package com.ejianc.business.plan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.business.plan.vo.*;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.business.progress.utils.WarnDateUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.service.IWeekPlanService;

/**
 * 周计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("weekPlan")
public class WeekPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWeekPlanService service;

    @Autowired
    private IWeekPlanDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExecPlanService execPlanService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeekPlanVO> saveOrUpdate(@RequestBody WeekPlanVO saveOrUpdateVO) {
        // 日历的例外日期普加加载后有问题
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getCalendars())){
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        CommonResponse<WeekPlanVO> response = service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeekPlanVO> queryDetail(Long id) {
        WeekPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeekPlanVO> vos) {
        List<Long> ids = vos.stream().map(WeekPlanVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeekPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<WeekPlanEntity> page = service.queryPage(param,false);
        IPage<WeekPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<WeekPlanVO> weekPlanVOS = BeanMapper.mapList(page.getRecords(), WeekPlanVO.class);
        weekPlanVOS.forEach(vo -> {
            if (vo.getChangeStatus()!=null && vo.getChangeVersion() !=null){
                vo.setChangeStatusName(PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
                vo.setChangeVersionName("第" + NumberUtil.int2chineseNum(vo.getChangeVersion()) + "版");
            }
        });
        pageData.setRecords(weekPlanVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WeekPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WeekPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWeekPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WeekPlanVO>> refWeekPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("projectManagerName");
        param.getFuzzyFields().add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("changeStatus", new Parameter(QueryParam.NE, 2));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("createTime", "desc");
        IPage<WeekPlanEntity> page = service.queryPage(param,false);
        IPage<WeekPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeekPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description validateContract 校验项目下是否存在未生效单据
     * @param projectId 项目ID
     * @param billId 单据主键
     */
    @RequestMapping(value = "/validateProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam("projectId") Long projectId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateProject(projectId, billId);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @Description queryWeekPlan 查询该项目下最新生效的周计划
     * @param projectId 项目ID
     */
    @RequestMapping(value = "/queryWeekPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeekPlanVO> queryWeekPlan(@RequestParam("projectId") Long projectId,@RequestParam(value = "billId", required = false) Long billId,@RequestParam(required = false,value = "planMonth") Date planMonth) {
        execPlanService.validateProject(projectId,billId);
        service.queryMonthPlan(projectId,planMonth);
        QueryWrapper<WeekPlanEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.eq("dr",0);
        wrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        wrapper.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc("create_time");
        wrapper.last("LIMIT 1");
        WeekPlanEntity entity = service.getOne(wrapper);
        if(entity == null){
            return CommonResponse.success("未查询到该项目下最新生效的周计划！", null);
        }
        WeekPlanVO vo = BeanMapper.map(entity, WeekPlanVO.class);
        if (planMonth != null){
            // 保证周计划在本月范围内至少有一天
            Date maxMonth = WarnDateUtil.beginOfMonth(WarnDateUtil.addDays(entity.getPlanEndDate(), 1));
            Date thisMonth = WarnDateUtil.beginOfMonth(planMonth);
            if(WarnDateUtil.compareDay(maxMonth, thisMonth) < 0){
                vo.setPlanEndDate(WarnDateUtil.addDays(thisMonth, -1));
            }
        }
        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * @Description queryMonthPlan 查询该项目下有没有的做月计划
     * @param projectId 项目ID
     */
    @RequestMapping(value = "/queryMonthPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryMonthPlan(@RequestParam("projectId") Long projectId,@RequestParam(required = false,value = "planMonth") Date planMonth,@RequestParam(value = "billId", required = false) Long billId) {
        execPlanService.validateProject(projectId,billId);
        return CommonResponse.success(service.queryMonthPlan(projectId,planMonth));
    }

    @RequestMapping(value = "/getxml", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return service.getxml(request);
    }

    @RequestMapping(value = "/exportxml", method = RequestMethod.POST)
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        service.exportxml(response, vo);
    }

    @RequestMapping(value = "/generateWeekPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeekPlanVO> generateWeekPlan(@RequestParam("projectId") Long projectId, @RequestParam("startDate") Date firstDay,
            @RequestParam("endDate") Date LastDay, @RequestParam(value = "changeFlag",required = false) Boolean changeFlag,
            @RequestParam(value = "sourceId",required = false) Long sourceId){
        Integer planState = BooleanUtils.isTrue(changeFlag) ? PlanConstant.WEEK_PLAN : PlanConstant.MONTH_PLAN;
        ExecPlanVO execPlanVO = execPlanService.queryRefDetail(projectId, planState, firstDay, LastDay, changeFlag, true);
        List<ExecPlanDetailVO> execlDetailList = execPlanVO.getProgressDetailList();
        if (CollectionUtils.isEmpty(execlDetailList)){
            throw new BusinessException("该项目的月计划没有计划详情！");
        }
        execPlanVO.setProgressDetailList(null);
        WeekPlanVO planVO = new WeekPlanVO();
        BeanUtils.copyProperties(execPlanVO, planVO);
        List<ExecPlanDetailVO> progressDetailList = TreeHelper2.tree2List(execlDetailList);
        List<WeekPlanDetailVO> list = new ArrayList<>();
        String name = "";
        for (ExecPlanDetailVO vo : progressDetailList){
            if(PlanConstant.WEEK_PLAN.equals(vo.getPlanState())){// 原计划新增
                if(vo.getSourceId().equals(sourceId)){
                    vo.setPlanState(null);
                }
            }
            if (StringUtils.isNotBlank(vo.getPercentTask())){
                vo.setName(vo.getName()+vo.getPercentTask());
            }
            WeekPlanDetailVO weekPlanDetailVO = new WeekPlanDetailVO();
            BeanUtils.copyProperties(vo, weekPlanDetailVO);
            weekPlanDetailVO.setSourceId(execPlanVO.getId());
            weekPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            list.add(weekPlanDetailVO);
        }
        List<WeekPlanDetailVO> monthPlanTree = TreeHelper2.list2Tree(list);
        planVO.setProgressDetailList(monthPlanTree);
        planVO.setSourceId(execPlanVO.getId());
        return CommonResponse.success(planVO);
    }
}
