package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MonthPlanDetailHistoryEntity;
import com.ejianc.business.plan.bean.MonthPlanHistoryEntity;
import com.ejianc.business.plan.service.IMonthPlanDetailHistoryService;
import com.ejianc.business.plan.vo.MonthPlanDetailHistoryVO;
import com.ejianc.business.plan.vo.MonthPlanHistoryVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.MonthPlanHistoryMapper;
import com.ejianc.business.plan.bean.MonthPlanHistoryEntity;
import com.ejianc.business.plan.service.IMonthPlanHistoryService;

import java.util.ArrayList;
import java.util.List;

/**
 * 月计划历史
 * 
 * @author generator
 * 
 */
@Service("monthPlanHistoryService")
public class MonthPlanHistoryServiceImpl extends BaseServiceImpl<MonthPlanHistoryMapper, MonthPlanHistoryEntity> implements IMonthPlanHistoryService{

    @Autowired
    private IMonthPlanDetailHistoryService detailHistoryService;

    @Override
    public MonthPlanHistoryVO queryDetailByChangeId(Long id) {
        MonthPlanHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<MonthPlanHistoryEntity>().eq("change_id", id));
        if (historyEntity != null) {
            MonthPlanHistoryVO historyVo = BeanMapper.map(historyEntity, MonthPlanHistoryVO.class);
            //查询子表
            QueryWrapper<MonthPlanDetailHistoryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("progress_id", historyVo.getId());
            queryWrapper.orderByAsc("tid");
            List<MonthPlanDetailHistoryEntity> progressDetailList = detailHistoryService.list(queryWrapper);

            if (progressDetailList != null && progressDetailList.size() > 0) {
                List<MonthPlanDetailHistoryVO> progressDetailVoList = new ArrayList<>();
                for (MonthPlanDetailHistoryEntity progressDetailEntity : progressDetailList) {
                    progressDetailVoList.add(MonthPlanDetailHistoryEntity.convertEntityToVo(progressDetailEntity));
                }
                historyVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
            }
            return historyVo;
        }
        return null;
    }
    
}
