package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fill.bean.ProjectLightEntity;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service("totalPlan")
public class TotalPlanBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;
    @Autowired
    private ITotalPlanDetailService detailService;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IWeekPlanService weekPlanService;
    @Autowired
    private IProjectLightService projectLightService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("这是提交前回调");
        //校验关联负责人
        List<TotalPlanDetailEntity> detailList = detailService.list(new QueryWrapper<TotalPlanDetailEntity>().eq("progress_id", billId));
        commonHelper.validateEmployeeEntity(detailList);

        LambdaUpdateWrapper<TotalPlanEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(TotalPlanEntity::getCommitTime, new Date());
        lambd.eq(TotalPlanEntity::getId, billId);
        totalPlanService.update(lambd);
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("这是提交完回调");
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //校验关联负责人
        List<TotalPlanDetailEntity> detailList = detailService.list(new QueryWrapper<TotalPlanDetailEntity>().eq("progress_id", billId));
        commonHelper.validateEmployeeEntity(detailList);
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state){
            LambdaUpdateWrapper<TotalPlanEntity> lambd = new LambdaUpdateWrapper<>();
            lambd.set(TotalPlanEntity::getCommitTime, new Date());
            lambd.eq(TotalPlanEntity::getId, billId);
            totalPlanService.update(lambd);
        }

        TotalPlanEntity totalPlanEntity = totalPlanService.selectById(billId);
        LambdaUpdateWrapper<TotalPlanEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(TotalPlanEntity::getApprovedTime, new Date());
        if (totalPlanEntity.getStartDate() != null) {
            Integer subDay = DateUtil.getBetweenDays(new Date(), totalPlanEntity.getStartDate());
            Integer finishFlag = subDay - 9;
            lambd.set(TotalPlanEntity::getFinishFlag, finishFlag);
        }
        if (state == 1) {
            lambd.set(TotalPlanEntity::getCommitTime, new Date());
        }
        lambd.eq(TotalPlanEntity::getId, billId);
        totalPlanService.update(lambd);
        execPlanService.pushExecPlan(billId, PlanConstant.TOTAL_PLAN);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        TotalPlanEntity totalPlanEntity = totalPlanService.selectById(billId);
        if (totalPlanEntity.getChangeStatus() != PlanConstant.CHANGE_NO) {
            return CommonResponse.error("计划存在变更单，暂不支持回退!");
        }
        if(checkBill(totalPlanEntity.getProjectId())){
            return CommonResponse.error("单据被下游引用，暂不支持回退!");
        }
        execPlanService.validateProject(totalPlanEntity.getProjectId(),totalPlanEntity.getId());

        // 删除项目完成时间亮灯状态中的数据
        ExecPlanEntity data = execPlanService.getOne(new QueryWrapper<ExecPlanEntity>()
                .eq("project_id", totalPlanEntity.getProjectId()));
        projectLightService.remove(new LambdaQueryWrapper<ProjectLightEntity>().eq(ProjectLightEntity::getExecPlanId,data.getId()));

        LambdaUpdateWrapper<TotalPlanEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(TotalPlanEntity::getCommitTime, null);
        lambd.set(TotalPlanEntity::getApprovedTime, null);
        lambd.set(TotalPlanEntity::getFinishFlag, null);
        lambd.eq(TotalPlanEntity::getId, billId);
        totalPlanService.update(lambd);
        execPlanService.pushExecPlanRollBack(billId, PlanConstant.TOTAL_PLAN);
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    private Boolean checkBill(Long project) {
        LambdaQueryWrapper<YearPlanEntity> ylambd = new LambdaQueryWrapper<>();
        ylambd.eq(YearPlanEntity::getProjectId, project);
        List<YearPlanEntity> list1 = yearPlanService.list(ylambd);
        if(CollectionUtils.isNotEmpty(list1)){
            return true;
        }
        LambdaQueryWrapper<MonthPlanEntity> mlambd = new LambdaQueryWrapper<>();
        mlambd.eq(MonthPlanEntity::getProjectId, project);
        List<MonthPlanEntity> list2 = monthPlanService.list(mlambd);
        if(CollectionUtils.isNotEmpty(list2)){
            return true;
        }
        LambdaQueryWrapper<WeekPlanEntity> wlambd = new LambdaQueryWrapper<>();
        wlambd.eq(WeekPlanEntity::getProjectId, project);
        List<WeekPlanEntity> list3 = weekPlanService.list(wlambd);
        if(CollectionUtils.isNotEmpty(list3)){
            return true;
        }
        return false;
    }

}
