package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanCloumCons;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.TotalPlanDetailMapper;
import com.ejianc.business.plan.mapper.TotalPlanMapper;
import com.ejianc.business.plan.mapper.YearPlanDetailMapper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.Export;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.*;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.business.progress.utils.TreeUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.tls.MACAlgorithm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.YearPlanMapper;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 年计划
 * 
 * @author generator
 * 
 */
@Service("yearPlanService")
public class YearPlanServiceImpl extends BaseServiceImpl<YearPlanMapper, YearPlanEntity> implements IYearPlanService{

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private YearPlanMapper progressMapper;
    @Autowired
    private YearPlanDetailMapper progressDetailMapper;
    @Autowired
    private IYearPlanDetailService detailService;

    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IExecPlanService execPlanService;

    @Autowired
    private CommonHelper commonHelper;

    @Override
    public void validateYearPlan(YearPlanVO saveOrUpdateVO){

        /*List<YearPlanDetailVO> tasks = saveOrUpdateVO.getTasks();
        if (CollectionUtils.isEmpty(tasks)){
            throw new BusinessException("计划详情不能为空");
        }*/

        LambdaQueryWrapper<YearPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(YearPlanEntity::getProjectId, saveOrUpdateVO.getProjectId());
        queryWrapper.eq(YearPlanEntity::getPlanYear, saveOrUpdateVO.getPlanYear());
        queryWrapper.eq(YearPlanEntity::getDr,0);
        queryWrapper.eq(YearPlanEntity::getTenantId,InvocationInfoProxy.getTenantid());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), YearPlanEntity::getId, saveOrUpdateVO.getId());
        List<YearPlanEntity> yearPlanList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(yearPlanList)) {
            throw new BusinessException("该项目在"+saveOrUpdateVO.getPlanYear()+"年已存在年计划！");
        }

        LambdaQueryWrapper<TotalPlanEntity> totalPlanQueryWrapper = new LambdaQueryWrapper<TotalPlanEntity>();
        totalPlanQueryWrapper.eq(TotalPlanEntity::getProjectId,saveOrUpdateVO.getProjectId());
        totalPlanQueryWrapper.eq(TotalPlanEntity::getDr,0);
        totalPlanQueryWrapper.in(TotalPlanEntity::getBillState,1,3);
        totalPlanQueryWrapper.eq(TotalPlanEntity::getTenantId,InvocationInfoProxy.getTenantid());
        List<TotalPlanEntity> totalPlanList = totalPlanService.list(totalPlanQueryWrapper);
        if (CollectionUtils.isEmpty(totalPlanList)) {
            throw new BusinessException("该项目下无审批通过的总计划！");
        }

    }


    @Override
    public YearPlanVO saveOrUpdate(YearPlanVO saveOrUpdateVO) {

        validateYearPlan(saveOrUpdateVO);
        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());
        commonHelper.validatePredecessorLink(saveOrUpdateVO.getTasks(), saveOrUpdateVO.getProjectId());

        OrgVO corp = orgUtil.findById(saveOrUpdateVO.getOrgId());
        saveOrUpdateVO.setCorpId(corp.getId());
        saveOrUpdateVO.setCorpCode(corp.getCode());
        saveOrUpdateVO.setCorpName(corp.getName());
        saveOrUpdateVO.setBillCode("N"+saveOrUpdateVO.getPlanYear().toString());

        YearPlanEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改

            YearPlanEntity yearPlanEntity = progressMapper.selectById(saveOrUpdateVO.getId());
            progressEntity = BeanMapper.map(saveOrUpdateVO, YearPlanEntity.class);
            progressMapper.updateById(progressEntity);

            //子表
            List<YearPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<YearPlanDetailVO> saveVOList = new ArrayList<>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList,saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                List<YearPlanDetailEntity> planEntityList = new ArrayList<>();
                if (saveOrUpdateVO.getImportFlag() || yearPlanEntity.getPlanYear() != saveOrUpdateVO.getPlanYear()) {
                    detailService.deleteByProgressId(progressEntity.getId());
                    for (YearPlanDetailVO progressDetailVo : saveVOList) {
                        YearPlanDetailEntity progressDetailEntity = YearPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        planEntityList.add(progressDetailEntity);
                    }
                }else{
                    for (YearPlanDetailVO progressDetailVo : saveVOList) {
                        if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                            YearPlanDetailEntity progressDetailEntity = YearPlanDetailEntity.convertVoToEntity(progressDetailVo);
                            progressDetailEntity.setProgressId(progressEntity.getId());
                            planEntityList.add(progressDetailEntity);
                        } else if ("modified".equals(progressDetailVo.get_state())) {
                            YearPlanDetailEntity progressDetailEntity = YearPlanDetailEntity.convertVoToEntity(progressDetailVo);
                            progressDetailEntity.setProgressId(progressEntity.getId());
                            progressDetailMapper.updateById(progressDetailEntity);
                        }
                    }
                }




                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailService.saveOrUpdateBatch(planEntityList);
                }
            }

            //子表删除
            List<YearPlanDetailVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (YearPlanDetailVO progressDetailVo : delDetailList) {
                    progressDetailMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            Long masterPkId = IdWorker.getId();
            progressEntity = BeanMapper.map(saveOrUpdateVO, YearPlanEntity.class);
            progressEntity.setId(masterPkId);
            progressEntity.setChangeVersion(1);
            progressEntity.setChangeStatus(PlanConstant.CHANGE_NO);
            progressMapper.insert(progressEntity);

            //子表
            List<YearPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();

            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<YearPlanDetailVO> saveVOList = new ArrayList<>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList,saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                List<YearPlanDetailEntity> planEntityList = new ArrayList<>();
                for (YearPlanDetailVO progressDetailVo : saveVOList) {
                    YearPlanDetailEntity progressDetailEntity = YearPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }

                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailService.saveOrUpdateBatch(planEntityList);
                }
            }
        }

        // 生效后更新执行计划
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())
                || BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())){
            execPlanService.updateExecPlan(saveOrUpdateVO.getId(), PlanConstant.YEAR_PLAN);
        }

        YearPlanVO yearPlanVO = queryDetail(progressEntity.getId());
        return yearPlanVO;
    }

    @Override
    public YearPlanVO queryDetail(Long id) {
        YearPlanEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<YearPlanDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<YearPlanDetailEntity> progressDetailList = detailService.list(queryWrapper);

        YearPlanVO progressVo = BeanMapper.map(progressEntity, YearPlanVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<YearPlanDetailVO> progressDetailVoList = new ArrayList<>();
            for (YearPlanDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(YearPlanDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public Map getDetail(Long id) {
        YearPlanVO planVO = queryDetail(id);
        Map map = new HashMap();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List<YearPlanDetailVO> detailList = planVO.getProgressDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> pkMap = new HashMap<>();
            List<YearPlanDetailVO> saveVOList = new ArrayList<>();
            TreeHelper2.tree2List(pkMap, saveVOList, detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List<Map> list = JSONObject.parseArray(jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") != null) {
                    List<Map> link = JSONObject.parseArray(JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                    m.put("PredecessorLink", link);
                }
            }
            key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", null);
        }
        map.put("MinutesPerWeek", null);
        String calendars = planVO.getCalendars();
        if (StringUtils.isNotBlank(calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", planVO.getPlanEndDate());
        map.put("Name", planVO.getProjectName());
        map.put("StartDate", planVO.getPlanBeginDate());
        map.put("CalendarUID", planVO.getCalendarUid());
        map.put("UID", planVO.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xml".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            HashMap read = PlusUtil.read(file, PlanCloumCons.YEAR_PLAN_CLOUM);
//            Map<String, Map> filed = new HashMap<>();
//            filed.put("taskLine", PlanConstant.TASK_LINE);
//            filed.put("nodeLevel", PlanConstant.NODE_LEVEL);
//            filed.put("unit", PlanConstant.UNIT);
//            filed.put("type", PlanConstant.RESOURCE_TYPE);
//            filed.put("typeUnit", PlanConstant.RESOURCE_UNIT);
            Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList) read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
            HashMap hashMap = PlusUtil.readMain(read, filed);


            Long projectId = Long.valueOf(request.getParameter("project"));
            Integer planYear = Integer.parseInt(request.getParameter("planYear"));

            //获取某年的第一天
            Calendar c1 = Calendar.getInstance();
            c1.clear();
            c1.set(Calendar.YEAR,planYear);
            Date yearFirstDate = c1.getTime();

            //获取某年的最后一天
            Calendar c2 = Calendar.getInstance();
            c2.clear();
            c2.set(Calendar.YEAR,planYear);
            c2.roll(Calendar.DAY_OF_YEAR,-1);
            Date yearLastDate = c2.getTime();

            Object tasks = hashMap.get("Tasks");
            Date startDate = DateUtil.beginOfDate(yearFirstDate);
            Date endDate = DateUtil.endOfDate(yearLastDate);

            // 日历替换成执行计划日历
            commonHelper.getExecClandars(hashMap, projectId);
            Object o = execPlanService.converMap(tasks,startDate,endDate,projectId);
            hashMap.put("Tasks",o);


            return CommonResponse.success("解析数据成功！",hashMap );
        }
    }
    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = getDetail(vo.getId());
        Export.exportExtendedAttributes((HashMap) dataProject);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.YEAR_PLAN_CLOUM);
    }

    private List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            key2Value(map, "unit", PlanConstant.UNIT);
            key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

}
