package com.ejianc.business.progress.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Component
public class TreeHelper2 {

    public static <T extends BaseDetailVO> List<T> list2Tree(List<T> list) {
        List<T> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, T> listMap = new HashMap<>();
        for (T detail : list) {
            listMap.put(detail.getUid().toString(), detail);
        }

        for (int i = 0; i < list.size(); i++) {
            T detail = list.get(i);
            String parentId = StringUtils.isNotBlank(detail.getParentTaskUID()) ? detail.getParentTaskUID() : "";
            T parent = listMap.get(parentId);
            if (parent != null) {
                List<T> child = getChilerenValue(parent, "children");
                if (child != null) {
                    child.add(detail);
                } else {
                    List<T> children = new ArrayList<T>();
                    children.add(detail);
                    setChilerenValue(parent, "children", children);
                }
            } else {
                rootItems.add(detail.getUid().toString());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    public static <T extends BaseDetailVO> List<T> tree2List(List<T> tree) {
        return tree2List(tree, false);
    }

    public static <T extends BaseDetailVO> List<T> tree2List(List<T> tree, Boolean importFlag) {
        List<T> copy = Utils.deepCopy(tree);
        Map<String, Long> pkMap = new HashMap<>();
        List<T> list = new ArrayList<>();
        getPkMap(pkMap, copy, importFlag != null ? importFlag : false);
        tree2List(pkMap, list, copy, (String) null);
        return list;
    }

    public static <T extends BaseDetailVO> void tree2List(Map<String, Long> pkMap, List<T> list, List<T> tree){
        List<T> copy = Utils.deepCopy(tree);
        getPkMap(pkMap, copy, false);
        tree2List(pkMap, list, copy, (String) null);
    }

    public static <T extends BaseDetailVO> void tree2List(Map<String, Long> pkMap, List<T> list, List<T> tree, Boolean importFlag){
        List<T> copy = Utils.deepCopy(tree);
        getPkMap(pkMap, copy, importFlag != null ? importFlag : false);
        tree2List(pkMap, list, copy, (String) null);
    }

    /**
     * 循环遍历获取主键Map
     * @param pkMap
     * @param tree
     */
    private static <T extends BaseDetailVO> void getPkMap(Map<String,Long> pkMap, List<T> tree, Boolean importFlag) {
        for (int i = 0, len = tree.size(); i < len; i++) {
            T vo = tree.get(i);
            Long pkId = IdWorker.getId();
            if(!"added".equals(vo.get_state()) && !importFlag) {
                pkId = Long.valueOf(vo.getUid());
            }
            pkMap.put(vo.getUid(), pkId);
            List<T> children = getChilerenValue(vo, "children");
            if (children != null && children.size() > 0) {
                getPkMap(pkMap, children, importFlag);
            }
        }
    }

    private static <T extends BaseDetailVO> void tree2List(Map<String, Long> pkMap, List<T> list, List<T> tree, String parentCode) {
        List<String> codeSet = tree.stream().filter(x->StringUtils.isNotEmpty(x.getCode())).map(BaseDetailVO::getCode).collect(Collectors.toList());
        for (int i = 0, len = tree.size(); i < len; i++) {
            T vo = tree.get(i);
            if(pkMap.containsKey(vo.getUid())){
                vo.setUid(pkMap.get(vo.getUid()).toString());
            }
            // 编码如果为空，默认等于序号，同级不能重复，如果重复取序号最大值加1
            if(StringUtils.isEmpty(vo.getCode())){
                String code = String.valueOf(vo.getId());
                if(codeSet.contains(code)){
                    Integer maxCode = codeSet.stream().filter(x->isInteger(x)).map(x->Integer.valueOf(x)).max(Integer::compare).orElse(0);
                    code = String.valueOf(maxCode + 1);
                }
                codeSet.add(code);
                vo.setCode(code);
            } else {
                Long count = codeSet.stream().filter(x->x.equals(vo.getCode())).count();
                if(count > 1){
                    throw new BusinessException("存在重复编码！");
                }
            }
            // 结构码
            vo.setStructCode(parentCode != null ? parentCode + "@@" + vo.getCode() : vo.getCode());
            if (StringUtils.isNotBlank(vo.getParentTaskUID())) {
                if (pkMap.containsKey(vo.getParentTaskUID())) {
                    vo.setParentTaskUID(pkMap.get(vo.getParentTaskUID()) + "");
                }
            }
            // 默认开始时间早上8点，结束时间下午5点
            vo.setStart(DateUtil.setHours(vo.getStart(), 8));
            vo.setFinish(DateUtil.setHours(vo.getFinish(), 17));
            // 限制时间
            if(vo.getConstraintDate() != null){
                vo.setConstraintDate(DurationUtil.getConstraintDate(vo.getStart(), vo.getFinish(), vo.getConstraintType()));
            }
            if (vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
                for (int j = 0; j < vo.getPredecessorLink().size(); j++) {
                    JSONObject predecessorLinkObj = vo.getPredecessorLink().getJSONObject(j);
                    String PredecessorUID = predecessorLinkObj.getString("PredecessorUID");
                    if (pkMap.containsKey(PredecessorUID)) {
                        predecessorLinkObj.put("PredecessorUID", pkMap.get(PredecessorUID));
                    }
                    String TaskUID = predecessorLinkObj.getString("TaskUID");
                    if (pkMap.containsKey(TaskUID)) {
                        predecessorLinkObj.put("TaskUID", pkMap.get(TaskUID));
                    }
                }
            }
            if (vo.getAssignments() != null && vo.getAssignments().size() > 0) {
                for (int j = 0; j < vo.getAssignments().size(); j++) {
                    JSONObject assignmentsObj = vo.getAssignments().getJSONObject(j);
                    String TaskUID = assignmentsObj.getString("TaskUID");
                    if (pkMap.containsKey(TaskUID)) {
                        assignmentsObj.put("TaskUID", pkMap.get(TaskUID));
                    }
                }
            }
            //list.add(vo);
            List<T> children = getChilerenValue(vo, "children");
            if (children != null && children.size() > 0) {
                tree2List(pkMap, list, children, vo.getStructCode());
            }
            setChilerenValue(vo, "children", null);
            list.add(vo);
        }
    }

    private static <T extends BaseDetailVO> List<T> getChilerenValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), (Class[]) null);
            try {
                return (List<T>) m.invoke(t, (Object[]) null);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置get方法！");
        }
    }

    private static <T extends BaseDetailVO> void setChilerenValue(T t, String code, List<T> value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), List.class);
            try {
                subPid.invoke(t, value);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的set方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的set方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置set方法！");
        }
    }

    public static List<Map> listMap2Tree(List<Map> list) {
        List<Map> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, Map> listMap = new HashMap<>();
        for (Map vo : list) {
            listMap.put(vo.get("UID").toString(), vo);
        }
        for (int i = 0; i < list.size(); i++) {
            Map vo = list.get(i);
            if (vo.get("children") == null || ((List<Map>) vo.get("children")).size() <= 0) {
                vo.remove("children");
            }
			// JSONArray转成ArrayList，否则导出转换报错
			for(Object key : vo.keySet()){
				if(vo.get(key) instanceof JSONArray){
					vo.put(key, JSONObject.parseArray(vo.get(key).toString(), Map.class));
				}
			}
//			String start = vo.get("Start").toString();
//            vo.put("Start",PlusUtil.utc2Local(start));
//			String finish = vo.get("Finish").toString();
//            vo.put("Finish",PlusUtil.utc2Local(finish));
//			vo.put("UID",vo.get("UID"));
//			vo.put("ParentTaskUID",vo.get("ParentTaskUID"));
            String parentId = vo.get("ParentTaskUID") != null ? vo.get("ParentTaskUID").toString() : "";
            Map parent = listMap.get(parentId);
            if (parent != null) {
                List<Map> child = (List<Map>) parent.get("children");
                if (child != null) {
                    child.add(vo);
                } else {
                    List<Map> children = new ArrayList<Map>();
                    children.add(vo);
                    parent.put("children", children);
                }
            } else {
                rootItems.add(vo.get("UID").toString());
            }
        }
        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }
        return resp;
    }

    public static List<Map> listMap2Tree2(List<Map> list) {
        List<Map> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, Map> listMap = new HashMap<>();
        for (Map vo : list) {
            listMap.put(vo.get("id").toString(), vo);
        }
        for (int i = 0; i < list.size(); i++) {
            Map vo = list.get(i);
            if (vo.get("children") == null || ((List<Map>) vo.get("children")).size() <= 0) {
                vo.remove("children");
            }
            String parentId = vo.get("parentId") != null ? vo.get("parentId").toString() : "";
            Map parent = listMap.get(parentId);
            if (parent != null) {
                List<Map> child = (List<Map>) parent.get("children");
                if (child != null) {
                    child.add(vo);
                } else {
                    List<Map> children = new ArrayList<Map>();
                    children.add(vo);
                    parent.put("children", children);
                }
            } else {
                rootItems.add(vo.get("id").toString());
            }
        }
        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }
        return resp;
    }

    /**
     * 获取结构码下所有子级
     * @param tree
     * @param parentCode
     * @return
     */
    public static  List<Map> getAllChildList(List<Map> tree, String parentCode) {
        List<Map> resp = new ArrayList<>();
        for (Map vo : tree) {
            List<Map> children = (List<Map>) vo.get("children");
            if(CollectionUtils.isNotEmpty(children)){
                if(parentCode.equals(vo.get("structCode"))){
                    List<Map> list = new ArrayList<>();
                    treeMap2List(list, Utils.deepCopy(children));
                    resp.addAll(list);
                } else {
                    resp.addAll(getAllChildList(children, parentCode));
                }
            }
        }
        return resp;
    }

    private static void treeMap2List(List<Map> list, List<Map> tree) {
        for (Map vo : tree) {
            List<Map> children = (List<Map>) vo.get("children");
            if (CollectionUtils.isNotEmpty(children)) {
                treeMap2List(list, children);
            }
            vo.put("children", children);
            list.add(vo);
        }
    }

    /**
     * 推荐，速度最快
     * 判断是否为整数
     * @param str 传入的字符串
     * @return 是整数返回true,否则返回false
     */

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            key2Value(map, "unit", PlanConstant.UNIT);
            key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private static Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

    public static void main(String[] args) {
//        Boolean A = false;
//        Boolean B = false;
//        System.out.println(!(A || B) == (!A && !B));
        String ass = "[{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"5\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"4\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"3\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"2\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"1\",\"Cost\":0,\"Units\":1}]";
        JSONArray jsonArray = JSONArray.parseArray(ass);
        System.out.println(jsonArray.toJSONString());
        System.out.println(JSONObject.toJSONString(JSONObject.parseArray(jsonArray.toString(), Map.class)));
    }
}
