/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fill.bean.MonthFillDetailEntity;
import com.ejianc.business.fill.bean.MonthFillEntity;
import com.ejianc.business.fill.service.IMonthFillDetailService;
import com.ejianc.business.fill.service.IMonthFillService;
import com.ejianc.business.fill.vo.MonthFillDetailVO;
import com.ejianc.business.fill.vo.MonthFillVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"monthFill"})
public class MonthFillController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZJKJ_MONTH_FILL";
    @Autowired
    private IMonthFillService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IMonthFillDetailService detailService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IMonthFillDetailService monthFillDetailService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MonthFillVO> saveOrUpdate(@RequestBody MonthFillVO saveOrUpdateVO) {
        MonthFillEntity entity;
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getCalendars())) {
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        if ((entity = (MonthFillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MonthFillEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            this.detailService.deleteByProgressId(entity.getId());
        }
        Integer subDay = DateUtil.getSubDay(new Date(), entity.getFillDate());
        entity.setFinishFlag(subDay);
        OrgVO orgVO = this.orgUtil.findById(saveOrUpdateVO.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
        this.service.saveOrUpdate((Object)entity, false);
        List detailList = saveOrUpdateVO.getTasks();
        if (!CollectionUtils.isNotEmpty((Collection)detailList)) return this.queryDetail(entity.getId());
        List<MonthFillDetailVO> voList = TreeHelper2.tree2List(detailList);
        ArrayList<MonthFillDetailEntity> saveList = new ArrayList<MonthFillDetailEntity>();
        for (MonthFillDetailVO mvo : voList) {
            MonthFillDetailEntity detail = MonthFillDetailEntity.convertVoToEntity(mvo);
            detail.setProgressId(entity.getId());
            saveList.add(detail);
        }
        if (!CollectionUtils.isNotEmpty(saveList)) return this.queryDetail(entity.getId());
        this.detailService.saveOrUpdateBatch(saveList);
        return this.queryDetail(entity.getId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthFillVO> queryDetail(Long id) {
        MonthFillVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthFillVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MonthFillVO monthFillVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MonthFillVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("updateUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthFillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MonthFill-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMonthFillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MonthFillVO>> refMonthFillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthFillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getMonthFillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthFillVO> getMonthFillData(@RequestParam(value="monthId") Long monthId, @RequestParam(required=false, value="billId") Long billId) {
        MonthPlanEntity entity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(monthId));
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"progress_id", (Object)monthId);
        qw.orderByAsc((Object)"tid");
        List detailList = this.monthPlanDetailService.list((Wrapper)qw);
        ArrayList<MonthPlanDetailVO> monthDetailVOList = new ArrayList<MonthPlanDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (MonthPlanDetailEntity detail : detailList) {
                monthDetailVOList.add(MonthPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        ExecPlanEntity execEntity = (ExecPlanEntity)((Object)this.execPlanService.selectById(entity.getSourceId()));
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)execEntity), ExecPlanVO.class);
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getSourceId());
        ew.orderByAsc((Object)"tid");
        List execPlanDetail = this.execPlanDetailService.list((Wrapper)ew);
        ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)execPlanDetail)) {
            for (ExecPlanDetailEntity detail : execPlanDetail) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        List resultList = detailVOList.stream().filter(ExecPlanDetailVO2 -> monthDetailVOList.stream().map(BaseDetailVO::getStructCode).collect(Collectors.toList()).contains(ExecPlanDetailVO2.getStructCode())).collect(Collectors.toList());
        List<Object> mfList = new ArrayList();
        mfList = resultList.stream().map(ExecPlanDetailVO2 -> {
            MonthFillDetailVO mfvo = new MonthFillDetailVO();
            BeanUtils.copyProperties((Object)ExecPlanDetailVO2, (Object)mfvo);
            return mfvo;
        }).collect(Collectors.toList());
        mfList = TreeHelper2.list2Tree(mfList);
        mfList = TreeHelper2.tree2List(mfList, true);
        vo.setProgressDetailList(null);
        MonthFillVO fillVO = new MonthFillVO();
        BeanUtils.copyProperties((Object)vo, (Object)fillVO);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        if (billId != null) {
            queryWrapper.ne((Object)"id", (Object)billId);
        }
        queryWrapper.orderByDesc((Object)"fill_date");
        queryWrapper.last("LIMIT 1");
        MonthFillEntity mfEntity = (MonthFillEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        List fList = new ArrayList();
        Map<Object, Object> fMap = new HashMap();
        if (mfEntity != null) {
            fList = this.monthFillDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)mfEntity.getId())).orderByAsc((Object)"tid"));
            fMap = fList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, a -> a, (k1, k2) -> k1));
        }
        String name = "";
        String percentTask = "";
        String[] arr = new String[]{};
        BigDecimal complete = BigDecimal.ZERO;
        BigDecimal yx = BigDecimal.ZERO;
        BigDecimal cComplete = BigDecimal.ZERO;
        for (MonthFillDetailVO monthFillDetailVO : mfList) {
            for (MonthPlanDetailEntity we : detailList) {
                if (!monthFillDetailVO.getStructCode().equals(we.getStructCode())) continue;
                monthFillDetailVO.setPlanStart(we.getStart());
                monthFillDetailVO.setDuration(we.getDuration());
                monthFillDetailVO.setPlanFinish(we.getFinish());
                monthFillDetailVO.setNodeLevel(we.getNodeLevel());
                monthFillDetailVO.setEmployeeId(we.getEmployeeId());
                monthFillDetailVO.setEmployeeName(we.getEmployeeName());
                monthFillDetailVO.setPlanNum(we.getPlanNum());
                monthFillDetailVO.setUnit(we.getUnit());
                monthFillDetailVO.setResourceName(we.getResourceName());
                monthFillDetailVO.setType(we.getType());
                monthFillDetailVO.setTypeUnit(we.getTypeUnit());
                monthFillDetailVO.setNeedNum(we.getNeedNum());
                complete = MapUtils.isNotEmpty(fMap) ? ComputeUtil.safeSub(new BigDecimal(monthFillDetailVO.getPercentComplete().toString()), fMap.get(we.getStructCode()) != null ? ((MonthFillDetailEntity)((Object)fMap.get(we.getStructCode()))).getCurrentComplete() : BigDecimal.ZERO) : new BigDecimal(monthFillDetailVO.getPercentComplete().toString());
                percentTask = we.getName().replace(monthFillDetailVO.getName(), "");
                if (StringUtils.isNotBlank((CharSequence)percentTask)) {
                    arr = percentTask.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\-", ",").replaceAll("\\%", "").split(",");
                    if (arr.length > 2) {
                        if (arr[0].equals("")) {
                            arr[0] = "-" + arr[1];
                        }
                        if (arr[1].equals("")) {
                            arr[1] = "-" + arr[2];
                        }
                        if (arr[2].equals("")) {
                            arr[1] = "-" + arr[3];
                        }
                    }
                    yx = ComputeUtil.safeSub(new BigDecimal(arr[1]), new BigDecimal(arr[0]));
                } else {
                    yx = new BigDecimal("100");
                }
                cComplete = ComputeUtil.bigDecimalPercent(complete, yx, 0);
                monthFillDetailVO.setCurrentComplete(cComplete.compareTo(new BigDecimal("100")) == 1 ? new BigDecimal("100") : (cComplete.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : cComplete));
            }
            name = StringUtils.isNotBlank((CharSequence)percentTask) ? monthFillDetailVO.getName() + percentTask : monthFillDetailVO.getName();
            monthFillDetailVO.setName(name);
        }
        fillVO.setProgressDetailList(TreeHelper2.list2Tree(mfList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)fillVO);
    }

    @RequestMapping(value={"/queryMonthFill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Date> queryMonthFill(@RequestParam(value="projectId") Long projectId, @RequestParam(required=false, value="billId") Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (billId != null) {
            wrapper.ne((Object)"id", (Object)billId);
        }
        wrapper.orderByDesc((Object)"fill_date");
        List list = this.service.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01", (Object)((MonthFillEntity)((Object)list.get(0))).getFillDate());
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01");
    }
}

