/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fill.mapper.ProjectLightMapper;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.fill.util.AddressUtil;
import com.ejianc.business.fill.util.IPUtils;
import com.ejianc.business.fill.vo.ProjectDynamicVO;
import com.ejianc.business.fill.vo.ProjectLightExportVO;
import com.ejianc.business.fill.vo.ProjectLightVO;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.utils.WeatherUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.maxmind.geoip2.DatabaseReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectLight"})
public class ProjectLightController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectLightService service;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectPoolApi projectApi;
    @Autowired
    private ProjectLightMapper lightMapper;

    @RequestMapping(value={"/projectList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> monthPageList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.projectList(param));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.monthPageList(param);
        List records = (List)((JSONObject)commonResponse.getData()).get((Object)"records");
        List list = BeanMapper.mapList((Iterable)records, ProjectLightExportVO.class);
        if (ListUtil.isNotEmpty((List)list)) {
            for (ProjectLightExportVO vo : list) {
                if (null != vo.getProjectControlLevel()) {
                    vo.setControlLevelName(this.getDefDocById(vo.getProjectControlLevel()).getName());
                }
                if (null != vo.getContractualModel()) {
                    DefdocDetailVO defdoc = this.getDefDocById(vo.getContractualModel());
                    vo.setContractualModelName(defdoc != null ? defdoc.getName() : null);
                }
                if (LightTypeEnum.\u7eff\u706f.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("\u7eff\u706f");
                } else if (LightTypeEnum.\u84dd\u706f.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("\u84dd\u706f");
                } else if (LightTypeEnum.\u9ec4\u706f.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("\u9ec4\u706f");
                } else if (LightTypeEnum.\u7ea2\u706f.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("\u7ea2\u706f");
                } else {
                    vo.setLightTypeName(null);
                }
                if (vo.getCriticalPath() != null && 1 == vo.getCriticalPath()) {
                    vo.setCriticalPathName("\u662f");
                    Integer diffValue = vo.getDiffValue() != null ? vo.getDiffValue().intValue() : 0;
                    vo.setProjectIsSet("\u9884\u6d4b\u6ede\u540e" + diffValue + "\u5929");
                } else {
                    vo.setCriticalPathName("\u5426");
                    vo.setProjectIsSet("\u9884\u6d4b\u672a\u6ede\u540e");
                }
                if (vo.getSumWarn() == null) continue;
                vo.setSumWarnName(vo.getSumWarn().intValue() + "\u6b21");
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("projectList-export.xlsx", beans, response);
    }

    public DefdocDetailVO getDefDocById(Long id) {
        if (id == null) {
            return new DefdocDetailVO();
        }
        CommonResponse resp = this.defdocApi.getDefDocById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (DefdocDetailVO)resp.getData();
    }

    @RequestMapping(value={"/getProjectInfoNotLight"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectLightVO> getProjectInfoNotLight(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getProjectInfoNotLight(projectId));
    }

    @RequestMapping(value={"/getWeather"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getWeather(HttpServletRequest request) throws Exception {
        ClassPathResource resource = new ClassPathResource("GeoLite2-City_20210420/GeoLite2-City.mmdb");
        DatabaseReader reader = new DatabaseReader.Builder(resource.getInputStream()).build();
        String ip = IPUtils.getIP(request).split(",")[0];
        this.logger.info("IP:" + ip);
        if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            ip = "222.240.44.187";
        }
        String p = IPUtils.getProvince(reader, ip);
        String c = IPUtils.getCity(reader, ip);
        if (StringUtils.isEmpty((CharSequence)p) || StringUtils.isEmpty((CharSequence)c)) {
            JSONObject json = AddressUtil.getAddresses(ip);
            p = json.getString("pro");
            c = json.getString("city");
        }
        JSONObject weather = WeatherUtil.getWeather(request, p, c);
        weather.put("province", (Object)p);
        weather.put("city", (Object)c);
        return CommonResponse.success((String)"\u67e5\u8be2\u5929\u6c14\u6210\u529f\uff01", (Object)weather);
    }

    @RequestMapping(value={"/numMap"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> numMap(@RequestParam(value="orgId") Long orgId, @RequestParam(value="orgType") Integer orgType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.numMap(orgId, orgType));
    }

    @RequestMapping(value={"/getProjectLightInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getProjectLightInfo(@RequestParam(value="orgId") Long orgId, @RequestParam(value="orgType") Integer orgType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.getProjectLightInfo(orgId, orgType));
    }

    @RequestMapping(value={"/getCorpLightSum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map>> getCorpLightSum(@RequestParam(value="orgId") Long orgId, @RequestParam(value="orgType") Integer orgType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.getCorpLightSum(orgId, orgType));
    }

    @RequestMapping(value={"/excelExportCorpLight"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportCorpLight(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
        Integer orgType = Integer.valueOf(((Parameter)param.getParams().get("orgType")).getValue().toString());
        List<Map> list = this.service.getCorpLightSum(orgId, orgType);
        HashMap<String, List<Map>> beans = new HashMap<String, List<Map>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("corpLightList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getProjectLightSum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<WarnProjectVO>> getProjectLightSum(@RequestParam(value="orgId") Long orgId, @RequestParam(value="orgType") Integer orgType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.getProjectLightSum(orgId, orgType));
    }

    @RequestMapping(value={"/getProjectInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getProjectInfo(@RequestParam(value="orgId") Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.getProjectInfo(orgId));
    }

    @RequestMapping(value={"/getMonthFirstLevel"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ExecPlanDetailVO>> getMonthFirstLevel(@RequestParam(value="orgId") Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.getMonthFirstLevel(orgId));
    }

    @RequestMapping(value={"/getMapProjectList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> getMapProjectList(@RequestParam(value="orgId") Long orgId, @RequestParam(value="lightType", required=false) Integer lightType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.getMapProjectList(orgId, lightType));
    }

    @RequestMapping(value={"/projectDynamic"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProjectDynamicVO>> projectDynamic(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.projectDynamic(projectId));
    }

    @RequestMapping(value={"/queryEasyProject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectLightVO>> queryEasyProject(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.lightMapper.queryEasyProject((Page<ProjectLightVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

