/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.service.impl;

import com.ejianc.business.fill.bean.ContractLightEntity;
import com.ejianc.business.fill.cons.FillConstant;
import com.ejianc.business.fill.mapper.ContractLightMapper;
import com.ejianc.business.fill.service.IContractLightService;
import com.ejianc.business.fill.vo.ContractLightVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractLightService")
public class ContractLightServiceImpl
extends BaseServiceImpl<ContractLightMapper, ContractLightEntity>
implements IContractLightService {
    @Autowired
    private IExecPlanDetailService execPlanDetailService;

    @Override
    public ContractLightVO getContractLevelInfo(Long bid) {
        ContractLightVO contractLightVO = new ContractLightVO();
        ExecPlanDetailEntity execPlanDetailEntity = (ExecPlanDetailEntity)((Object)this.execPlanDetailService.selectById(bid));
        Integer status = null;
        if (null == execPlanDetailEntity.getActualStart() && null == execPlanDetailEntity.getActualFinish()) {
            status = FillConstant.NOT_STAR;
        }
        if (null != execPlanDetailEntity.getActualStart() && null != execPlanDetailEntity.getPredictFinish() && null == execPlanDetailEntity.getActualFinish()) {
            status = FillConstant.UNDERWAY;
        }
        if (null != execPlanDetailEntity.getActualStart() && null != execPlanDetailEntity.getActualFinish()) {
            status = FillConstant.FINISHED;
        }
        contractLightVO.setStatus(status);
        contractLightVO.setPlanName(execPlanDetailEntity.getName());
        contractLightVO.setLightType(execPlanDetailEntity.getLightType());
        contractLightVO.setStarDate(execPlanDetailEntity.getStart());
        contractLightVO.setEndDate(execPlanDetailEntity.getFinish());
        contractLightVO.setActualStart(execPlanDetailEntity.getActualStart());
        contractLightVO.setActualEnd(execPlanDetailEntity.getActualFinish());
        return contractLightVO;
    }
}

