/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fill.consumer.TransferVO;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.service.ILightRuleService;
import com.ejianc.business.progress.utils.DetailListUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WarnFeignUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${weChat.cgdd-agentid}")
    private String cgddAgentid;
    @Value(value="${weChat.cgdd-secret}")
    private String cgddSecret;
    @Autowired
    private ILightRuleService lightRuleService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IProjectPoolApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private DetailListUtil detailListUtil;

    public Map<Long, ProjectVO> getProjectMapByIds(List<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return new HashMap<Long, ProjectVO>();
        }
        List<ProjectVO> projectList = this.queryProjectByIds(projectIds);
        Map<Long, ProjectVO> projectMap = projectList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        return projectMap;
    }

    public List<ProjectVO> queryProjectByIds(List<Long> projectIds) {
        CommonResponse resp = this.projectApi.queryProjectArray(projectIds);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List result = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectVO.class);
        return result;
    }

    public List<ProjectVO> queryProjects(QueryParam param) {
        CommonResponse resp = this.projectApi.queryArray(param);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List result = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectVO.class);
        return result;
    }

    public List<ProjectVO> queryProjectsByOrgId(Long orgId) {
        CommonResponse resp = this.projectApi.queryArrayByOrgId(orgId);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List result = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectVO.class);
        return result;
    }

    public List<DefdocDetailVO> getDefDocListById(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocByDefId(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public DefdocDetailVO getDefDocDetail(List<DefdocDetailVO> defList, Long id) {
        if (CollectionUtils.isEmpty(defList) || id == null) {
            return new DefdocDetailVO();
        }
        return defList.stream().filter(x -> id.equals(x.getId())).findAny().orElse(new DefdocDetailVO());
    }

    public TransferVO getTransferVO(List<Long> projectIds) {
        List<ProjectVO> projectList = this.queryProjectByIds(projectIds);
        Map<Long, ProjectVO> projectMap = projectList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        HashMap<Long, OrgVO> orgMap = new HashMap<Long, OrgVO>();
        HashMap<Long, OrgVO> corpMap = new HashMap<Long, OrgVO>();
        CommonResponse rootResp = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        if (rootResp.isSuccess() && rootResp.getData() != null) {
            for (OrgVO root : (List)rootResp.getData()) {
                CommonResponse orgResp = this.orgApi.findChildrenByParentId(root.getId());
                if (!orgResp.isSuccess() || orgResp.getData() == null) continue;
                List orgList = (List)orgResp.getData();
                orgMap.putAll(orgList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
                corpMap.putAll(orgList.stream().filter(x -> x.getOrgType() == 2).collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
        }
        TransferVO transferVO = new TransferVO();
        transferVO.setProjectMap(projectMap);
        transferVO.setOrgMap(orgMap);
        transferVO.setCorpMap(corpMap);
        return transferVO;
    }

    public Map<String, LightRuleEntity> getLightRuleMapByTypes(List<Long> typeList, Map<Long, OrgVO> orgMap) {
        if (CollectionUtils.isEmpty(typeList)) {
            return new HashMap<String, LightRuleEntity>();
        }
        QueryParam queryParam = new QueryParam();
        List lightRuleList = this.lightRuleService.queryList(queryParam);
        this.detailListUtil.setDetailList(lightRuleList);
        HashMap orgIdMap = new HashMap();
        List orgIds = lightRuleList.stream().map(LightRuleEntity::getOrgId).collect(Collectors.toList());
        List<Object> orgList = new ArrayList();
        if (orgMap == null) {
            CommonResponse orgResp = this.orgApi.findChildrenByParentIds(orgIds);
            if (orgResp.isSuccess() && orgResp.getData() != null) {
                orgList = (List)orgResp.getData();
            } else {
                this.logger.error(orgResp.getMsg());
            }
        } else {
            orgList = orgMap.values().stream().collect(Collectors.toList());
        }
        for (Long orgId : orgIds) {
            for (OrgVO orgVO : orgList) {
                if (!orgIdMap.containsKey(orgId)) {
                    orgIdMap.put(orgId, new ArrayList());
                }
                if (!orgVO.getInnerCode().contains(String.valueOf(orgId))) continue;
                ((List)orgIdMap.get(orgId)).add(orgVO.getId());
            }
        }
        ArrayList list = new ArrayList(orgIdMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Long, List<Long>>>(){

            @Override
            public int compare(Map.Entry<Long, List<Long>> o1, Map.Entry<Long, List<Long>> o2) {
                Integer s1 = o1.getValue().size();
                Integer s2 = o2.getValue().size();
                return s1.compareTo(s2);
            }
        });
        HashMap<String, LightRuleEntity> lightRuleMap = new HashMap<String, LightRuleEntity>();
        for (Long l : orgIdMap.keySet()) {
            for (LightRuleEntity rule : lightRuleList) {
                if (!rule.getOrgId().equals(l)) continue;
                List childIds = (List)orgIdMap.get(rule.getOrgId());
                for (Long childId : childIds) {
                    lightRuleMap.put(childId + "|" + rule.getIndustryTypeId(), rule);
                }
            }
        }
        return lightRuleMap;
    }

    public Map<String, LightRuleEntity> getLightRuleMapByTypes2(List<Long> typeList, Map<Long, OrgVO> orgMap) {
        if (CollectionUtils.isEmpty(typeList)) {
            return new HashMap<String, LightRuleEntity>();
        }
        QueryParam queryParam = new QueryParam();
        List lightRuleList = this.lightRuleService.queryList(queryParam);
        this.detailListUtil.setDetailList(lightRuleList);
        HashMap orgIdMap = new HashMap();
        List orgIds = lightRuleList.stream().map(LightRuleEntity::getOrgId).collect(Collectors.toList());
        List<Object> orgList = new ArrayList();
        if (orgMap == null) {
            CommonResponse orgResp = this.orgApi.findChildrenByParentIds(orgIds);
            if (orgResp.isSuccess() && orgResp.getData() != null) {
                orgList = (List)orgResp.getData();
            } else {
                this.logger.error(orgResp.getMsg());
            }
        } else {
            orgList = orgMap.values().stream().collect(Collectors.toList());
        }
        for (Long orgId : orgIds) {
            for (OrgVO orgVO : orgList) {
                if (!orgIdMap.containsKey(orgId)) {
                    orgIdMap.put(orgId, new ArrayList());
                }
                if (!orgVO.getInnerCode().contains(String.valueOf(orgId))) continue;
                ((List)orgIdMap.get(orgId)).add(orgVO.getId());
            }
        }
        ArrayList list = new ArrayList(orgIdMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Long, List<Long>>>(){

            @Override
            public int compare(Map.Entry<Long, List<Long>> o1, Map.Entry<Long, List<Long>> o2) {
                Integer s1 = o1.getValue().size();
                Integer s2 = o2.getValue().size();
                return s1.compareTo(s2);
            }
        });
        HashMap<String, LightRuleEntity> lightRuleMap = new HashMap<String, LightRuleEntity>();
        for (Long l : orgIdMap.keySet()) {
            for (LightRuleEntity rule : lightRuleList) {
                if (!rule.getOrgId().equals(l)) continue;
                List childIds = (List)orgIdMap.get(rule.getOrgId());
                for (Long childId : childIds) {
                    lightRuleMap.put(childId + "|" + rule.getIndustryTypeId(), rule);
                }
            }
        }
        return lightRuleMap;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl) {
        this.sendMsg(messageType, user, msgType, subject, content, mobileUrl, null);
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl, String formurl) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        if (messageType.contains("dingding")) {
            channel.add("dingding");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.cgddAgentid);
            weixineeParams.put("secret", (Object)this.cgddSecret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("url", (Object)mobileUrl);
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        if (messageType.contains("dingding")) {
            JSONObject dingdingParams = new JSONObject();
            dingdingParams.put("title", (Object)subject);
            String ddcontent = subject + ",\u901a\u77e5\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            dingdingParams.put("content", (Object)ddcontent);
            dingdingParams.put("maurl", (Object)mobileUrl);
            dingdingParams.put("pcurl", (Object)formurl);
            parameter.setDingdingParams(dingdingParams);
        }
        try {
            this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

