/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.WeekPlanDetailVO;
import com.ejianc.business.plan.vo.WeekPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.business.progress.utils.WarnDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"weekPlan"})
public class WeekPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWeekPlanService service;
    @Autowired
    private IWeekPlanDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecPlanService execPlanService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WeekPlanVO> saveOrUpdate(@RequestBody WeekPlanVO saveOrUpdateVO) {
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getCalendars())) {
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        CommonResponse<WeekPlanVO> response = this.service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeekPlanVO> queryDetail(Long id) {
        WeekPlanVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeekPlanVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        this.detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WeekPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List weekPlanVOS = BeanMapper.mapList((Iterable)page.getRecords(), WeekPlanVO.class);
        weekPlanVOS.forEach(vo -> {
            if (vo.getChangeStatus() != null && vo.getChangeVersion() != null) {
                vo.setChangeStatusName((String)PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
                vo.setChangeVersionName("\u7b2c" + NumberUtil.int2chineseNum(vo.getChangeVersion()) + "\u7248");
            }
        });
        pageData.setRecords(weekPlanVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WeekPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWeekPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WeekPlanVO>> refWeekPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("projectManagerName");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("changeStatus", new Parameter("ne", (Object)2));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WeekPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validateProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateProject(projectId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/queryWeekPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeekPlanVO> queryWeekPlan(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId, @RequestParam(required=false, value="planMonth") Date planMonth) {
        Date thisMonth;
        Date maxMonth;
        this.execPlanService.validateProject(projectId, billId);
        this.service.queryMonthPlan(projectId, planMonth);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc((Object)"create_time");
        wrapper.last("LIMIT 1");
        WeekPlanEntity entity = (WeekPlanEntity)((Object)this.service.getOne((Wrapper)wrapper));
        if (entity == null) {
            return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0b\u6700\u65b0\u751f\u6548\u7684\u5468\u8ba1\u5212\uff01", null);
        }
        WeekPlanVO vo = (WeekPlanVO)BeanMapper.map((Object)((Object)entity), WeekPlanVO.class);
        if (planMonth != null && WarnDateUtil.compareDay(maxMonth = WarnDateUtil.beginOfMonth(WarnDateUtil.addDays(entity.getPlanEndDate(), 1)), thisMonth = WarnDateUtil.beginOfMonth(planMonth)) < 0) {
            vo.setPlanEndDate(WarnDateUtil.addDays(thisMonth, -1));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryMonthPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryMonthPlan(@RequestParam(value="projectId") Long projectId, @RequestParam(required=false, value="planMonth") Date planMonth, @RequestParam(value="billId", required=false) Long billId) {
        this.execPlanService.validateProject(projectId, billId);
        return CommonResponse.success((String)this.service.queryMonthPlan(projectId, planMonth));
    }

    @RequestMapping(value={"/getxml"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return this.service.getxml(request);
    }

    @RequestMapping(value={"/exportxml"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        this.service.exportxml(response, vo);
    }

    @RequestMapping(value={"/generateWeekPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeekPlanVO> generateWeekPlan(@RequestParam(value="projectId") Long projectId, @RequestParam(value="startDate") Date firstDay, @RequestParam(value="endDate") Date LastDay, @RequestParam(value="changeFlag", required=false) Boolean changeFlag, @RequestParam(value="sourceId", required=false) Long sourceId) {
        Integer planState = BooleanUtils.isTrue((Boolean)changeFlag) ? PlanConstant.WEEK_PLAN : PlanConstant.MONTH_PLAN;
        ExecPlanVO execPlanVO = this.execPlanService.queryRefDetail(projectId, planState, firstDay, LastDay, changeFlag, true);
        List execlDetailList = execPlanVO.getProgressDetailList();
        if (CollectionUtils.isEmpty((Collection)execlDetailList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u7684\u6708\u8ba1\u5212\u6ca1\u6709\u8ba1\u5212\u8be6\u60c5\uff01");
        }
        execPlanVO.setProgressDetailList(null);
        WeekPlanVO planVO = new WeekPlanVO();
        BeanUtils.copyProperties((Object)execPlanVO, (Object)planVO);
        List<ExecPlanDetailVO> progressDetailList = TreeHelper2.tree2List(execlDetailList);
        ArrayList<WeekPlanDetailVO> list = new ArrayList<WeekPlanDetailVO>();
        String name = "";
        for (ExecPlanDetailVO vo : progressDetailList) {
            if (PlanConstant.WEEK_PLAN.equals(vo.getPlanState()) && vo.getSourceId().equals(sourceId)) {
                vo.setPlanState(null);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPercentTask())) {
                vo.setName(vo.getName() + vo.getPercentTask());
            }
            WeekPlanDetailVO weekPlanDetailVO = new WeekPlanDetailVO();
            BeanUtils.copyProperties((Object)vo, (Object)weekPlanDetailVO);
            weekPlanDetailVO.setSourceId(execPlanVO.getId());
            weekPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            list.add(weekPlanDetailVO);
        }
        List monthPlanTree = TreeHelper2.list2Tree(list);
        planVO.setProgressDetailList(monthPlanTree);
        planVO.setSourceId(execPlanVO.getId());
        return CommonResponse.success((Object)planVO);
    }
}

