/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TreeUtils<T> {
    public static <T> List<T> restParentId(List<T> list) {
        list = TreeUtils.listToTree(list);
        list = TreeUtils.treeToList(list);
        return list;
    }

    public static <T> T resetProjectClomn(T vo, Map<Long, Long> idMap) {
        Object assiObj;
        String TaskUID;
        Map<String, Long> pkMap = idMap.entrySet().stream().collect(Collectors.toMap(x -> String.valueOf(x.getKey()), x -> (Long)x.getValue()));
        Object preObj = TreeUtils.getValue(vo, "predecessorLink");
        if (preObj != null) {
            JSONArray predecessorLink = JSONArray.parseArray((String)String.valueOf(TreeUtils.getValue(vo, "predecessorLink")));
            if (predecessorLink.size() > 0) {
                for (int j = 0; j < predecessorLink.size(); ++j) {
                    JSONObject json = predecessorLink.getJSONObject(j);
                    String PredecessorUID = json.getString("PredecessorUID");
                    if (pkMap.containsKey(PredecessorUID)) {
                        json.put("PredecessorUID", (Object)pkMap.get(PredecessorUID));
                    }
                    if (!pkMap.containsKey(TaskUID = json.getString("TaskUID"))) continue;
                    json.put("TaskUID", (Object)pkMap.get(TaskUID));
                }
            }
            TreeUtils.setValue(vo, "predecessorLink", String.valueOf(predecessorLink));
        }
        if ((assiObj = TreeUtils.getValue(vo, "assignments")) != null) {
            JSONArray assignments = JSONArray.parseArray((String)String.valueOf(TreeUtils.getValue(vo, "assignments")));
            if (assignments.size() > 0) {
                for (int j = 0; j < assignments.size(); ++j) {
                    JSONObject json = assignments.getJSONObject(j);
                    TaskUID = json.getString("TaskUID");
                    if (!pkMap.containsKey(TaskUID)) continue;
                    json.put("TaskUID", (Object)pkMap.get(TaskUID));
                }
            }
            TreeUtils.setValue(vo, "assignments", String.valueOf(assignments));
        }
        return vo;
    }

    public static <T> List<T> getPreLinkList(List<T> list, String structCode) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Map<String, Object> codeMap = list.stream().collect(Collectors.toMap(x -> String.valueOf(TreeUtils.getValue(x, "structCode")), x -> x));
        Map<String, Object> idMap = list.stream().collect(Collectors.toMap(x -> String.valueOf(TreeUtils.getValue(x, "id")), x -> x));
        if (!codeMap.containsKey(structCode)) {
            return null;
        }
        Object vo = codeMap.get(structCode);
        Object preObj = TreeUtils.getValue(vo, "predecessorLink");
        if (preObj == null) {
            return null;
        }
        JSONArray predecessorLink = JSONArray.parseArray((String)String.valueOf(TreeUtils.getValue(vo, "predecessorLink")));
        ArrayList<Object> result = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)predecessorLink)) {
            for (int j = 0; j < predecessorLink.size(); ++j) {
                JSONObject json = predecessorLink.getJSONObject(j);
                String PredecessorUID = json.getString("PredecessorUID");
                if (!idMap.containsKey(PredecessorUID)) continue;
                result.add(idMap.get(PredecessorUID));
            }
        }
        return result;
    }

    public static <T extends BaseDetailVO> String getPlanPreLink(LinkedList<T> result, JSONArray predecessorLink) {
        ArrayList<String> strs = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)predecessorLink)) {
            return null;
        }
        for (Object o : predecessorLink) {
            JSONObject obj = (JSONObject)o;
            Integer index = -1;
            for (int i = 0; i < result.size(); ++i) {
                if (!((BaseDetailVO)result.get(i)).getUid().equals(obj.getString("PredecessorUID"))) continue;
                index = i + 1;
            }
            if (index == -1) continue;
            StringBuffer str = new StringBuffer();
            str.append(index);
            if (obj.getInteger("Type") == 0) {
                str.append("FF");
            } else if (obj.getInteger("Type") == 1 && obj.getInteger("LinkLag") != 0) {
                str.append("FS");
            } else if (obj.getInteger("Type") == 2) {
                str.append("SF");
            } else if (obj.getInteger("Type") == 3) {
                str.append("SS");
            }
            if (obj.getInteger("LinkLag") > 0) {
                str.append("+" + obj.getInteger("LinkLag"));
            } else if (obj.getInteger("LinkLag") < 0) {
                str.append(obj.getInteger("LinkLag"));
            }
            strs.add(str.toString());
        }
        return strs.stream().collect(Collectors.joining(","));
    }

    public static <T> List<T> listToTree(List<T> list) {
        ArrayList resp = new ArrayList();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, T> listMap = new HashMap<String, T>();
        for (T detail : list) {
            listMap.put(String.valueOf(TreeUtils.getValue(detail, "id")), detail);
        }
        for (int i = 0; i < list.size(); ++i) {
            T detail;
            detail = list.get(i);
            String parentId = String.valueOf(TreeUtils.getValue(detail, "parentId"));
            Object parent = listMap.get(parentId);
            if (parent != null) {
                List<T> children = TreeUtils.castList(TreeUtils.getValue(parent, "children"), parent.getClass());
                children.add(detail);
                TreeUtils.setValue(parent, "children", children);
                continue;
            }
            rootItems.add(String.valueOf(TreeUtils.getValue(detail, "id")));
        }
        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }
        return resp;
    }

    public static <T> List<T> treeToList(List<T> tree) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        ArrayList list = new ArrayList();
        TreeUtils.getPkMap(pkMap, tree);
        TreeUtils.treeToList(pkMap, list, tree);
        return list;
    }

    private static <T> void getPkMap(Map<String, Long> pkMap, List<T> tree) {
        int len = tree.size();
        for (int i = 0; i < len; ++i) {
            T vo = tree.get(i);
            TreeUtils.setValue(vo, "sourceBid", TreeUtils.getValue(vo, "id"));
            Long pkId = IdWorker.getId();
            pkMap.put(String.valueOf(TreeUtils.getValue(vo, "id")), pkId);
            List<T> children = TreeUtils.castList(TreeUtils.getValue(vo, "children"), vo.getClass());
            if (children == null || children.size() <= 0) continue;
            TreeUtils.getPkMap(pkMap, children);
        }
    }

    public static <T> void treeToList(Map<String, Long> pkMap, List<T> list, List<T> tree) {
        int len = tree.size();
        for (int i = 0; i < len; ++i) {
            List<T> children;
            Object assiObj;
            String TaskUID;
            Object preObj;
            String parentId;
            T vo = tree.get(i);
            if (pkMap.containsKey(String.valueOf(TreeUtils.getValue(vo, "id")))) {
                TreeUtils.setValue(vo, "id", pkMap.get(String.valueOf(TreeUtils.getValue(vo, "id"))));
            }
            if (StringUtils.isNotBlank((CharSequence)(parentId = String.valueOf(TreeUtils.getValue(vo, "parentId")))) && pkMap.containsKey(parentId)) {
                TreeUtils.setValue(vo, "parentId", pkMap.get(parentId));
            }
            if ((preObj = TreeUtils.getValue(vo, "predecessorLink")) != null) {
                JSONArray predecessorLink = JSONArray.parseArray((String)String.valueOf(TreeUtils.getValue(vo, "predecessorLink")));
                if (predecessorLink.size() > 0) {
                    for (int j = 0; j < predecessorLink.size(); ++j) {
                        JSONObject json = predecessorLink.getJSONObject(j);
                        String PredecessorUID = json.getString("PredecessorUID");
                        if (pkMap.containsKey(PredecessorUID)) {
                            json.put("PredecessorUID", (Object)pkMap.get(PredecessorUID));
                        }
                        if (!pkMap.containsKey(TaskUID = json.getString("TaskUID"))) continue;
                        json.put("TaskUID", (Object)pkMap.get(TaskUID));
                    }
                }
                TreeUtils.setValue(vo, "predecessorLink", String.valueOf(predecessorLink));
            }
            if ((assiObj = TreeUtils.getValue(vo, "assignments")) != null) {
                JSONArray assignments = JSONArray.parseArray((String)String.valueOf(TreeUtils.getValue(vo, "assignments")));
                if (assignments.size() > 0) {
                    for (int j = 0; j < assignments.size(); ++j) {
                        JSONObject json = assignments.getJSONObject(j);
                        TaskUID = json.getString("TaskUID");
                        if (!pkMap.containsKey(TaskUID)) continue;
                        json.put("TaskUID", (Object)pkMap.get(TaskUID));
                    }
                }
                TreeUtils.setValue(vo, "assignments", String.valueOf(assignments));
            }
            if ((children = TreeUtils.castList(TreeUtils.getValue(vo, "children"), vo.getClass())) != null && children.size() > 0) {
                TreeUtils.treeToList(pkMap, list, children);
            }
            TreeUtils.setValue(vo, "children", null);
            list.add(vo);
        }
    }

    private static <T> Object getValue(T t, String fieldName) {
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                try {
                    return m.invoke(t, (Object[])null);
                }
                catch (IllegalAccessException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                }
                catch (InvocationTargetException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                }
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    private static <T> void setValue(T t, String fieldName, Object obj) {
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                Method m = clazz.getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), field.getType());
                try {
                    m.invoke(t, obj);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                }
                catch (InvocationTargetException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> List<T> castList(Object obj, Class<?> clazz) {
        ArrayList result = new ArrayList();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
        }
        return result;
    }
}

