package com.ejianc.business.fill.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.fill.vo.MonthFillDetailVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import org.apache.commons.lang3.StringUtils;

/**
 * 月进度计划填报详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zjkjprogress_month_fill_detail")
public class MonthFillDetailEntity extends ProgressDetailEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="task_line")
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    @TableField(value="node_level")
    private Integer nodeLevel; // 节点级别
    @TableField(value="plan_start")
    private Date planStart; // 计划开始日期
    @TableField(value="plan_finish")
    private Date planFinish; // 计划完成日期
    @TableField(value="estimate_finish")
    private Date estimateFinish; // 预计完成日期
    @TableField(value="employee_id")
    private Long employeeId; // 负责人主键
    @TableField(value="employee_name")
    private String employeeName; // 负责人名称
    @TableField(value="plan_num")
    private BigDecimal planNum; // 工程量
    @TableField(value="finish_num")
    private BigDecimal finishNum; // 完成工程量
    @TableField(value="unit")
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    @TableField(value="diff_value")
    private BigDecimal diffValue; // 偏差时间
    @TableField(value="diff_type")
    private Long diffType; // 偏差原因类型
    @TableField(value="diff_resson")
    private String diffResson; // 偏差原因
    @TableField(value="resource_name")
    private String resourceName; // 资源名称
    @TableField(value="type")
    private Integer type; // 资源类型(劳动力、材料、机械)
    @TableField(value="type_unit")
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    @TableField(value="need_num")
    private BigDecimal needNum; // 需求量
    @TableField(value="resource_num")
    private BigDecimal resourceNum; // 实际资源量
    @TableField(value="diff_num")
    private BigDecimal diffNum; // 资源偏差
    @TableField(value="current_complete")
    private BigDecimal currentComplete; // 本期完成百分比
    @TableField(exist=false)
    private List<MonthFillDetailEntity> children = new ArrayList<>();// 子任务
    

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    public Date getPlanStart() {
        return planStart;
    }

    public void setPlanStart(Date planStart) {
        this.planStart = planStart;
    }
    public Date getPlanFinish() {
        return planFinish;
    }

    public void setPlanFinish(Date planFinish) {
        this.planFinish = planFinish;
    }
    public Date getEstimateFinish() {
        return estimateFinish;
    }

    public void setEstimateFinish(Date estimateFinish) {
        this.estimateFinish = estimateFinish;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }
    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }
    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }
    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }
    public Long getDiffType() {
        return diffType;
    }

    public void setDiffType(Long diffType) {
        this.diffType = diffType;
    }
    public String getDiffResson() {
        return diffResson;
    }

    public void setDiffResson(String diffResson) {
        this.diffResson = diffResson;
    }
    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }
    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }
    public BigDecimal getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(BigDecimal resourceNum) {
        this.resourceNum = resourceNum;
    }
    public BigDecimal getDiffNum() {
        return diffNum;
    }

    public void setDiffNum(BigDecimal diffNum) {
        this.diffNum = diffNum;
    }

    public List<MonthFillDetailEntity> getChildren() {
        return children;
    }

    public void setChildren(List<MonthFillDetailEntity> children) {
        this.children = children;
    }

    /**
     * entity to vo
     */
    public static MonthFillDetailVO convertEntityToVo(MonthFillDetailEntity entity) {
        MonthFillDetailVO progressDetailVo = new MonthFillDetailVO();
        progressDetailVo.setUid(entity.getId().toString());
        progressDetailVo.setManual(entity.getManual());
        progressDetailVo.setActualDuration(entity.getActualDuration());
        progressDetailVo.setDuration(entity.getDuration());
        progressDetailVo.setPercentComplete(entity.getPercentComplete());
        progressDetailVo.setDepartment(entity.getDepartment());
        progressDetailVo.setProjectUID(entity.getProjectId());
        progressDetailVo.setMilestone(entity.getMilestone());
        progressDetailVo.setFinish(entity.getFinish());
        progressDetailVo.setConstraintType(entity.getConstraintType());
        progressDetailVo.setPrincipal(entity.getPrincipal());
        progressDetailVo.setParentTaskUID(entity.getParentId() + "");
        progressDetailVo.setWbs(entity.getWbs());
        if (StringUtils.isNotBlank(entity.getAssignments())) {
            progressDetailVo.setAssignments(JSON.parseArray(entity.getAssignments()));
        }
        progressDetailVo.setStart(entity.getStart());
        progressDetailVo.setOutlineLevel(entity.getOutlineLevel());
        progressDetailVo.setOutlineNumber(entity.getOutlineNumber());
        progressDetailVo.setCritical(entity.getCritical());
        progressDetailVo.setNote(entity.getNotes());
        progressDetailVo.setSummary(entity.getSummary());
        progressDetailVo.setActualFinish(entity.getActualFinish());
        progressDetailVo.setName(entity.getName());
        progressDetailVo.setId(entity.getTid());
        progressDetailVo.setCode(entity.getCode());
        progressDetailVo.setStructCode(entity.getStructCode());
        progressDetailVo.setWeight(entity.getWeight());
        progressDetailVo.setFixedDate(entity.getFixedDate());
        progressDetailVo.setWork(entity.getWork());
        progressDetailVo.setConstraintDate(entity.getConstraintDate());
        if(StringUtils.isNotBlank(entity.getPredecessorLink())) {
            progressDetailVo.setPredecessorLink(JSON.parseArray(entity.getPredecessorLink()));
        }
        progressDetailVo.setPriority(entity.getPriority());
        progressDetailVo.setActualStart(entity.getActualStart());

        progressDetailVo.setTaskLine(entity.getTaskLine()); // 任务条线(手续线、设计线、建造线、招采线)
        progressDetailVo.setNodeLevel(entity.getNodeLevel()); // 节点级别
        progressDetailVo.setEmployeeId(entity.getEmployeeId()); // 负责人主键
        progressDetailVo.setEmployeeName(entity.getEmployeeName()); // 负责人名称
        progressDetailVo.setPlanNum(entity.getPlanNum()); // 工程量
        progressDetailVo.setUnit(entity.getUnit()); // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
        progressDetailVo.setResourceName(entity.getResourceName()); // 资源名称
        progressDetailVo.setType(entity.getType()); // 资源类型(劳动力、材料、机械)
        progressDetailVo.setTypeUnit(entity.getTypeUnit()); // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
        progressDetailVo.setNeedNum(entity.getNeedNum()); // 需求量

        progressDetailVo.setPlanStart(entity.getPlanStart());
        progressDetailVo.setPlanFinish(entity.getPlanFinish());
        progressDetailVo.setEstimateFinish(entity.getEstimateFinish());
        progressDetailVo.setFinishNum(entity.getFinishNum());
        progressDetailVo.setDiffValue(entity.getDiffValue());
        progressDetailVo.setDiffType(entity.getDiffType());
        progressDetailVo.setDiffResson(entity.getDiffResson());
        progressDetailVo.setDiffNum(entity.getDiffNum());
        progressDetailVo.setResourceNum(entity.getResourceNum());
        progressDetailVo.setCurrentComplete(entity.getCurrentComplete());

        return progressDetailVo;
    }

    /**
     * vo to entity
     */
    public static MonthFillDetailEntity convertVoToEntity(MonthFillDetailVO vo) {
        MonthFillDetailEntity progressDetailEntity = new MonthFillDetailEntity();
        if(StringUtils.isNotBlank(vo.getUid())) {
            progressDetailEntity.setId(Long.parseLong(vo.getUid()));
        }
        progressDetailEntity.setManual(vo.getManual());
        progressDetailEntity.setActualDuration(vo.getActualDuration());
        progressDetailEntity.setDuration(vo.getDuration());
        progressDetailEntity.setPercentComplete(vo.getPercentComplete());
        progressDetailEntity.setDepartment(vo.getDepartment());
        progressDetailEntity.setProjectId(vo.getProjectUID());
        progressDetailEntity.setMilestone(vo.getMilestone());
        progressDetailEntity.setFinish(vo.getFinish());
        progressDetailEntity.setConstraintType(vo.getConstraintType());
        progressDetailEntity.setPrincipal(vo.getPrincipal());
        if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
            progressDetailEntity.setParentId(Long.parseLong(vo.getParentTaskUID()));
        }
        progressDetailEntity.setWbs(vo.getWbs());
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            progressDetailEntity.setAssignments(JSON.toJSONString(vo.getAssignments()));
        }
        progressDetailEntity.setStart(vo.getStart());
        progressDetailEntity.setOutlineLevel(vo.getOutlineLevel());
        progressDetailEntity.setOutlineNumber(vo.getOutlineNumber());
        progressDetailEntity.setCritical(vo.getCritical());
        progressDetailEntity.setNotes(vo.getNote());
        progressDetailEntity.setSummary(vo.getSummary());
        progressDetailEntity.setActualFinish(vo.getActualFinish());
        progressDetailEntity.setName(vo.getName());
        progressDetailEntity.setTid(vo.getId());
        progressDetailEntity.setCode(vo.getCode());
        progressDetailEntity.setStructCode(vo.getStructCode());
        progressDetailEntity.setWeight(vo.getWeight());
        progressDetailEntity.setFixedDate(vo.getFixedDate());
        progressDetailEntity.setWork(vo.getWork());
        progressDetailEntity.setConstraintDate(vo.getConstraintDate());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            progressDetailEntity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
        }
        progressDetailEntity.setPriority(vo.getPriority());
        progressDetailEntity.setActualStart(vo.getActualStart());

        progressDetailEntity.setTaskLine(vo.getTaskLine()); // 任务条线(手续线、设计线、建造线、招采线)
        progressDetailEntity.setNodeLevel(vo.getNodeLevel()); // 节点级别
        progressDetailEntity.setEmployeeId(vo.getEmployeeId()); // 负责人主键
        progressDetailEntity.setEmployeeName(vo.getEmployeeName()); // 负责人名称
        progressDetailEntity.setPlanNum(vo.getPlanNum()); // 工程量
        progressDetailEntity.setUnit(vo.getUnit()); // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
        progressDetailEntity.setResourceName(vo.getResourceName()); // 资源名称
        progressDetailEntity.setType(vo.getType()); // 资源类型(劳动力、材料、机械)
        progressDetailEntity.setTypeUnit(vo.getTypeUnit()); // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
        progressDetailEntity.setNeedNum(vo.getNeedNum()); // 需求量

        progressDetailEntity.setPlanStart(vo.getPlanStart());
        progressDetailEntity.setPlanFinish(vo.getPlanFinish());
        progressDetailEntity.setEstimateFinish(vo.getEstimateFinish());
        progressDetailEntity.setFinishNum(vo.getFinishNum());
        progressDetailEntity.setDiffValue(vo.getDiffValue());
        progressDetailEntity.setDiffType(vo.getDiffType());
        progressDetailEntity.setDiffResson(vo.getDiffResson());
        progressDetailEntity.setDiffNum(vo.getDiffNum());
        progressDetailEntity.setResourceNum(vo.getResourceNum());
        progressDetailEntity.setCurrentComplete(vo.getCurrentComplete());

        return progressDetailEntity;
    }

    public BigDecimal getCurrentComplete() {
        return currentComplete;
    }

    public void setCurrentComplete(BigDecimal currentComplete) {
        this.currentComplete = currentComplete;
    }
}
