package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 执行计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("execPlan")
public class ExecPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IExecPlanService service;

    @Autowired
    private IExecPlanDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExecPlanVO> saveOrUpdate(@RequestBody ExecPlanVO saveOrUpdateVO) {
    	ExecPlanVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> queryDetail(Long id) {
    	ExecPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExecPlanVO> vos) {
        List<Long> ids = vos.stream().map(ExecPlanVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        detailService.remove(new QueryWrapper<ExecPlanDetailEntity>().in("progress_id", ids));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ExecPlanEntity> page = service.queryPage(param,false);
        IPage<ExecPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExecPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExecPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExecPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refExecPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> refExecPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExecPlanEntity> page = service.queryPage(param,false);
        IPage<ExecPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExecPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 执行计划明细参照
     * @param projectId 项目主键
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划，默认向上兼容，即为3时，查询"1,2,3"
     *                  ，参照哪级计划传哪个，一般不会参照周计划
     * @param startDate 到天即可，会处理成当天00:00:00
     * @param endDate   到天即可，会处理成当天23:59:59
     * @return
     */
    @RequestMapping(value = "/refExecPlanDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> refExecPlanDetail(@RequestParam("projectId") Long projectId,
            @RequestParam(value = "planState", required = false) Integer planState,
            @RequestParam(value = "startDate", required = false) Date startDate,
            @RequestParam(value = "endDate", required = false) Date endDate) {
        ExecPlanVO vo = service.queryRefDetail(projectId, planState, startDate, endDate);
        return CommonResponse.success("查询清单参照成功！", vo);
    }

    @RequestMapping(value = "/getxml", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return service.getxml(request);
    }

    /**
     * @param vo id 执行计划主键
     * @param vo planState 1-总计划、2-年计划、3-月计划、4-周计划，默认总计划
     * @param vo startDate 到天即可，会处理成当天00:00:00，默认总计划计划开始时间
     * @param vo endDate   到天即可，会处理成当天23:59:59，默认总计划计划结束时间
     * @return
     */
    @RequestMapping(value = "/exportxml", method = RequestMethod.POST)
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        service.exportxml(response, vo);
    }

    /**
     * 推送执行计划
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    @RequestMapping(value = "/pushExecPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlan(@RequestParam("id") Long id, @RequestParam("planState") Integer planState) {
        ExecPlanEntity vo = service.pushExecPlan(id, planState);
        return CommonResponse.success("推送执行计划成功！", vo);
    }

    /**
     * 推送执行计划回退
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    @RequestMapping(value = "/pushExecPlanRollBack", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlanRollBack(@RequestParam("id") Long id, @RequestParam("planState") Integer planState) {
        ExecPlanEntity vo = service.pushExecPlanRollBack(id, planState);
        return CommonResponse.success("推送执行计划回退成功！", vo);
    }

    /**
     * @Description validateProject 校验项目下是否存在未生效单据
     * @param projectId 项目ID
     * @param billId 单据主键
     */
    @RequestMapping(value = "/validateProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam("projectId") Long projectId,
                                                  @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateProject(projectId, billId);
        return CommonResponse.success("校验成功！", msg);
    }
}
