package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.bean.DayFillDetailEntity;
import com.ejianc.business.fill.bean.DayFillEntity;
import com.ejianc.business.fill.service.IDayFillDetailService;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Component
public class CommonHelper {

    @Autowired
    private IExecPlanService execService;

    @Autowired
    private IExecPlanDetailService execDetailService;

    @Autowired
    private IYearPlanService yearService;

    @Autowired
    private IYearPlanDetailService yearDetailService;

    @Autowired
    private IMonthPlanService monthService;

    @Autowired
    private IMonthPlanDetailService monthDetailService;

    @Autowired
    private IWeekPlanService weekService;

    @Autowired
    private IWeekPlanDetailService weekDetailService;

    @Autowired
    private IDayFillService fillService;

    @Autowired
    private IDayFillDetailService fillDetailService;

    /**
     * 获取计划明细主键对应关系
     * 如执行计划存在，则使用执行计划主键
     * 如执行计划不存在，使用重置后的主键
     * @param sourceList
     * @param detailList
     * @return
     */
    public static <T extends ProgressDetailEntity> Map<Long, Long> getIdMap(List<T> sourceList, List<ExecPlanDetailEntity> detailList) {
        Map<Long, String> sourceMap = sourceList.stream().collect(Collectors.toMap(x->x.getId(), x->x.getStructCode()));
        Map<String, Long> execMap = detailList.stream().collect(Collectors.toMap(x->x.getStructCode(), x->x.getId()));
        Map<Long, Long> idMap = new HashMap<>();
        String task = null;
        for(Long id : sourceMap.keySet()){
            task = sourceMap.get(id);
            if(execMap.containsKey(task)){
                idMap.put(id, execMap.get(task));
            } else {
                idMap.put(id, id);
            }
        }
        idMap.put(-1L, -1L);// 根目录父级为-1
        return idMap;
    }

    /**
     * 获取执行计划明细删除主键集合及是否下游引用校验
     * @param sourceList    不删除的明细
     * @param detailList    执行计划明细
     * @return
     */
    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList,
            Long projectId, Integer planState) {
        return transferDelIds(sourceList, detailList, projectId, planState, false);
    }

    /**
     * 获取执行计划明细删除主键集合及是否下游引用校验
     * @param sourceList
     * @param detailList
     * @param isDel true-sourceList(待删除明细)，false-sourceList(不删除明细), null-只删除自己的
     * @return
     */
    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList,
                Long projectId, Integer planState, Boolean isDel) {
        List<Long> delIds = new ArrayList<>();
        Map<String, T> sourceMap = sourceList.stream().collect(Collectors.toMap(T::getStructCode, x->x));
        Long sourceId = CollectionUtils.isNotEmpty(sourceList) ? sourceList.get(0).getProgressId() : null;
        if(CollectionUtils.isNotEmpty(detailList)){
            List<String> delTasks = new ArrayList<>();
            List<ExecPlanDetailEntity> execList = new ArrayList<>();
            if(isDel == null || !isDel) {// 4级计划变更删除后推送执行计划校验
                execList = detailList.stream().filter(x->sourceId == null
                        || x.getSourceId().equals(sourceId)).collect(Collectors.toList());
                execList.forEach(item->{
                    if(isDel == null ? sourceMap.containsKey(item.getStructCode()) : !sourceMap.containsKey(item.getStructCode())){
                        delIds.add(item.getId());
                        delTasks.add(item.getStructCode());
                    }
                });
                List<Long> parentIds = detailList.stream().filter(x->x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId())
                        && !delIds.contains(x.getId())).map(x->x.getParentId()).collect(Collectors.toList());
                List<String> parentTasks = detailList.stream().filter(x->parentIds.contains(x.getId()) &&
                        delTasks.contains(x.getStructCode())).map(x->x.getOutlineNumber()).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(parentTasks)) {
                    throw new BusinessException("【" + StringUtils.join(parentTasks, "，") + "】计划已被下游引用！");
                }
            } else {// 删除下游引用校验
                execList = detailList.stream().collect(Collectors.toList());
                execList.forEach(item->{
                    if(sourceMap.containsKey(item.getStructCode())){
                        delIds.add(item.getId());
                        delTasks.add(item.getStructCode());
                    }
                });
                if(CollectionUtils.isNotEmpty(delTasks)){
                    if(planState < PlanConstant.YEAR_PLAN){
                        // 校验年计划引用
                        this.validateYearPlan(projectId, delTasks);
                    }
                    if(planState < PlanConstant.MONTH_PLAN){
                        // 校验月计划引用
                        this.validateMonthPlan(projectId, delTasks);
                    }
                    if(planState < PlanConstant.WEEK_PLAN){
                        // 校验周计划引用
                        this.validateWeekPlan(projectId, delTasks);
                    }
                }
            }
            if(CollectionUtils.isNotEmpty(delTasks)){
                // 校验日反馈引用
                this.validateDayFill(projectId, delTasks);
            }
        }
        return delIds;
    }

    /**
     * 校验年计划引用
     * @param projectId
     * @param delTasks
     */
    private void validateYearPlan(Long projectId, List<String> delTasks) {
        List<YearPlanEntity> list = yearService.list(new QueryWrapper<YearPlanEntity>().eq("project_id", projectId));
        List<Long> ids = list.stream().map(YearPlanEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            QueryWrapper ew = new QueryWrapper();
            ew.in("progress_id", ids);
            ew.in("struct_code", delTasks);
            List<YearPlanDetailEntity> detailList = yearDetailService.list(ew);
            if(CollectionUtils.isNotEmpty(detailList)){
                List<String> detailTasks = detailList.stream().map(YearPlanDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被下游引用！");
            }
        }
    }

    /**
     * 校验月计划引用
     * @param projectId
     * @param delTasks
     */
    private void validateMonthPlan(Long projectId, List<String> delTasks) {
        List<MonthPlanEntity> list = monthService.list(new QueryWrapper<MonthPlanEntity>().eq("project_id", projectId));
        List<Long> ids = list.stream().map(MonthPlanEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            QueryWrapper ew = new QueryWrapper();
            ew.in("progress_id", ids);
            ew.in("struct_code", delTasks);
            List<MonthPlanDetailEntity> detailList = monthDetailService.list(ew);
            if(CollectionUtils.isNotEmpty(detailList)){
                List<String> detailTasks = detailList.stream().map(MonthPlanDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被下游引用！");
            }
        }
    }

    /**
     * 校验周计划引用
     * @param projectId
     * @param delTasks
     */
    private void validateWeekPlan(Long projectId, List<String> delTasks) {
        List<WeekPlanEntity> list = weekService.list(new QueryWrapper<WeekPlanEntity>().eq("project_id", projectId));
        List<Long> ids = list.stream().map(WeekPlanEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            QueryWrapper ew = new QueryWrapper();
            ew.in("progress_id", ids);
            ew.in("struct_code", delTasks);
            List<WeekPlanDetailEntity> detailList = weekDetailService.list(ew);
            if(CollectionUtils.isNotEmpty(detailList)){
                List<String> detailTasks = detailList.stream().map(WeekPlanDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被下游引用！");
            }
        }
    }

    /**
     * 校验日反馈引用
     * @param projectId
     * @param delTasks
     */
    private void validateDayFill(Long projectId, List<String> delTasks) {
        List<DayFillEntity> list = fillService.list(new QueryWrapper<DayFillEntity>().eq("project_id", projectId));
        List<Long> ids = list.stream().map(DayFillEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            QueryWrapper ew = new QueryWrapper();
            ew.in("progress_id", ids);
            ew.in("struct_code", delTasks);
            ew.eq("show_state", 1);// 显示即为引用
            ew.gt("percent_complete", 0);// 百分比大于0即为有实际数据
            List<DayFillDetailEntity> detailList = fillDetailService.list(ew);
            if(CollectionUtils.isNotEmpty(detailList)){
                List<String> detailTasks = detailList.stream().map(DayFillDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被日进度反馈引用！");
            }
        }
    }

    /**
     * 获取执行计划明细删除主键集合及是否下游引用校验
     * @param sourceList    待删除明细
     * @param projectId     待删除明细，所属项目id
     * @return
     */
    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, Long projectId, Integer planState) {
        // 执行计划
        ExecPlanEntity data = execService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
        if(data == null) {
            throw new BusinessException("未查询到项目下执行计划！");
        }
        List<ExecPlanDetailEntity> detailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
                    .eq("progress_id", data.getId()).orderByAsc("tid"));
        return transferDelIds(sourceList, detailList, projectId, planState, null);
    }

    /**
     * 获取被日反馈引用结构码集合
     * @param sourceList    待校验明细
     * @param projectId     待校验明细，所属项目id
     * @return
     */
    public <T extends ProgressDetailEntity> List<String> transferUseIds(List<T> sourceList, Long projectId) {
        // 执行计划
        ExecPlanEntity data = execService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
        if(data == null) {
            throw new BusinessException("未查询到项目下执行计划！");
        }
        List<ExecPlanDetailEntity> detailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
                .eq("progress_id", data.getId()).orderByAsc("tid"));
//        Map<String, T> sourceMap = sourceList.stream().collect(Collectors.toMap(T::getStructCode, x->x));
        if(CollectionUtils.isEmpty(detailList)) {
            return new ArrayList<>();
        }
        // 校验日反馈引用
        List<DayFillEntity> list = fillService.list(new QueryWrapper<DayFillEntity>().eq("project_id", projectId));
        if(CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        List<Long> ids = list.stream().map(DayFillEntity::getId).collect(Collectors.toList());
        List<String> sourceTasks = sourceList.stream().map(T::getStructCode).collect(Collectors.toList());
        QueryWrapper ew = new QueryWrapper();
        ew.in("progress_id", ids);
        ew.in("struct_code", sourceTasks);
        ew.eq("show_state", 1);// 显示即为引用
        ew.gt("percent_complete", 0);// 百分比大于0即为有实际数据
        List<DayFillDetailEntity> fillDetailList = fillDetailService.list(ew);
        List<String> delTasks = fillDetailList.stream().map(DayFillDetailEntity::getStructCode).collect(Collectors.toList());
        return delTasks;
    }

    public void getExecClandars(HashMap hashMap, Long projectId){
        ExecPlanVO execPlan = execService.queryRefDetail(projectId, null , null, null);
        hashMap.put("Calendars", JSONObject.parseArray(execPlan.getCalendars(), Map.class));
        hashMap.put("CalendarUID", execPlan.getCalendarUid());
    }

    public static void main(String[] args) {
        Boolean flag = null;
        System.out.println(!flag);
        List<ExecPlanDetailEntity> detailList = new ArrayList<>();
        ExecPlanDetailEntity vo1 = new ExecPlanDetailEntity();
        vo1.setId(Long.valueOf(1L));
        vo1.setParentId(Long.valueOf(-1));
        vo1.setStructCode("1");
        vo1.setOutlineNumber("1");
        detailList.add(vo1);
        ExecPlanDetailEntity vo2 = new ExecPlanDetailEntity();
        vo2.setId(Long.valueOf(2L));
        vo2.setParentId(Long.valueOf(1L));
        vo2.setStructCode("1&&2");
        vo2.setOutlineNumber("1.1");
        detailList.add(vo2);
        ExecPlanDetailEntity vo3 = new ExecPlanDetailEntity();
        vo3.setId(Long.valueOf(3L));
        vo3.setParentId(Long.valueOf(2L));
        vo3.setStructCode("1&&2&&3");
        vo3.setOutlineNumber("1.1.1");
        detailList.add(vo3);
        ExecPlanDetailEntity vo4 = new ExecPlanDetailEntity();
        vo4.setId(Long.valueOf(4L));
        vo4.setParentId(Long.valueOf(3L));
        vo4.setStructCode("1&&2&&3&&4");
        vo4.setOutlineNumber("1.1.1.1");
        detailList.add(vo4);
        List<Long> delIds = new ArrayList<>();
        delIds.add(1L);
//        delIds.add(2L);
//        delIds.add(3L);
//        delIds.add(4L);
        List<String> delTasks = new ArrayList<>();
        delTasks.add("1");
//        delTasks.add("1&&2");
//        delTasks.add("1&&2&&3");
//        delTasks.add("1&&2&&3&&4");
        List<Long> parentIds = detailList.stream().filter(x->x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId())
                && !delIds.contains(x.getId())).map(x->x.getParentId()).collect(Collectors.toList());
        List<String> parentTasks = detailList.stream().filter(x->parentIds.contains(x.getId()) &&
                delTasks.contains(x.getStructCode())).map(x->x.getOutlineNumber()).collect(Collectors.toList());
        System.out.println("【" + StringUtils.join(parentTasks, "，") + "】计划已被下游引用，无法删除！");
    }

    /**
     * 校验末级关联负责人
     * @param planDetailList
     * @param <T>
     */
    public <T extends BaseDetailVO> void validateEmployee(List<T> planDetailList){

        List<String> parentIds = planDetailList.stream().filter(e -> null != e.getParentTaskUID()).map(T::getParentTaskUID).distinct().collect(Collectors.toList());
        List<T> validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getUid())).collect(Collectors.toList());

        for (T t : validatePlanDetailList){
            Class<? extends BaseDetailVO> aClass = t.getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId");
                invoke = getEmployeeId.invoke(t);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (null == invoke){
                throw new BusinessException("您的计划中存在末级任务未关联责任人");
            }
        }

    }

    /**
     * 校验末级关联负责人
     * @param planDetailList
     * @param <T>
     */
    public <T extends ProgressDetailEntity> void validateEmployeeEntity(List<T> planDetailList){

        List<Long> parentIds = planDetailList.stream().filter(e -> null != e.getParentId()).map(T::getParentId).distinct().collect(Collectors.toList());
        List<T> validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getId())).collect(Collectors.toList());

        for (T t : validatePlanDetailList){
            Class<? extends ProgressDetailEntity> aClass = t.getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId");
                invoke = getEmployeeId.invoke(t);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (null == invoke){
                throw new BusinessException("您的计划中存在末级任务未关联责任人");
            }
        }

    }

    /**
     * 推荐，速度最快
     * 判断是否为整数
     * @param str 传入的字符串
     * @return 是整数返回true,否则返回false
     */
    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

}
