package com.ejianc.business.progress.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.progress.bean.PushSetEntity;
import com.ejianc.business.progress.service.IPushSetLevelService;
import com.ejianc.business.progress.service.IPushSetService;
import com.ejianc.business.progress.vo.PushSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 推送设置实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("pushSet")
public class PushSetController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_PUSH_SET";//此处需要根据实际修改
    
    @Autowired
    private IPushSetService service;

    @Autowired
    private IPushSetLevelService levelService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PushSetVO> saveOrUpdate(@RequestBody PushSetVO saveorUpdateVO) {
    	PushSetEntity entity = BeanMapper.map(saveorUpdateVO, PushSetEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        CommonResponse<OrgVO> org = iOrgApi.getOneById(entity.getOrgId());
    	if(org.isSuccess()){
    	    entity.setOrgInnerCode(org.getData().getInnerCode());
        }
//    	service.saveOrUpdate(entity, false);
        // 处理复合子表
        service.saveOrUpdate(entity);
    	if(CollectionUtils.isNotEmpty(entity.getLevelList())) {
            entity.getLevelList().forEach(vo ->{
                vo.setSetId(entity.getId());
                if(CollectionUtils.isNotEmpty(vo.getReceiveList())){
                    vo.getReceiveList().forEach(i ->{
                        i.setSetId(entity.getId());
                    });
                }
                levelService.saveOrUpdate(vo, false);
            });
        }
    	PushSetVO vo = BeanMapper.map(entity, PushSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PushSetVO> queryDetail(Long id) {
    	PushSetEntity entity = service.selectById(id);
        // 处理复合子表
        if(CollectionUtils.isNotEmpty(entity.getLevelList())) {
            entity.getLevelList().forEach(vo ->{
                vo.setReceiveList(levelService.selectById(vo.getId()).getReceiveList());
            });
        }
    	PushSetVO vo = BeanMapper.map(entity, PushSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PushSetVO> vos) {
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> ids = vos.stream().map(PushSetVO::getId).collect(Collectors.toList());
        Collection<PushSetEntity> list = service.listByIds(ids);
        for(PushSetEntity entity : list){
            if(entity.getOrgInnerCode().indexOf(InvocationInfoProxy.getOrgId().toString()) == -1){
                return CommonResponse.error("没有删除权限！");
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PushSetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("industryTypeName");
        fuzzyFields.add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PushSetEntity> page = service.queryPage(param,false);
        IPage<PushSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PushSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PushSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PushSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param searchObject
     * @Return void
     */
    @RequestMapping(value = "/refPushSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PushSetVO>> refPushSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PushSetEntity> page = service.queryPage(param,false);
        IPage<PushSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PushSetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
