package com.ejianc.business.progress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.progress.bean.DocEntity;
import com.ejianc.business.progress.cons.PartCons;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.mapper.DocMapper;
import com.ejianc.business.progress.service.IDocService;
import com.ejianc.business.progress.utils.DetailIndexExcelReader;
import com.ejianc.business.progress.utils.ExcelImportUtil;
import com.ejianc.business.progress.utils.InnerCodeTool;
import com.ejianc.business.progress.utils.TreeUtil;
import com.ejianc.business.progress.vo.DocVO;
import com.ejianc.business.progress.vo.comparator.DocComparatorVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 节点档案
 * 
 * @author generator
 * 
 */
@Service("docService")
public class DocServiceImpl extends BaseServiceImpl<DocMapper, DocEntity> implements IDocService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public CommonResponse<DocVO> saveOrUpdate(DocVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(saveorUpdateVO.getNodeArchivesId() == null || saveorUpdateVO.getNodeArchivesId() <= 0){
            throw new BusinessException("请先选择方案分类!");
        }
        DocEntity entity = BeanMapper.map(saveorUpdateVO, DocEntity.class);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            // 修改
            entity.setTenantId(tenantId);
            entity.setCode(entity.getName());

            super.saveOrUpdate(entity, false);
            DocVO vo = BeanMapper.map(entity, DocVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
        } else {
            // 新增
            String code = entity.getCode();
            String name = entity.getName();
            if (StringUtils.isBlank(code)) {
//                code = creatCode2(entity,tenantId);
                code = name;
            } else {
                LambdaQueryWrapper<DocEntity> lambda = new LambdaQueryWrapper<>();
                lambda.eq(DocEntity::getTenantId, tenantId);
                lambda.eq(DocEntity::getName, entity.getName());
                lambda.eq(DocEntity::getDr, 0);
                List<DocEntity> entities = super.list(lambda);
                if (entities != null && entities.size() > 0) {
                    throw new BusinessException("存在相同节点名称，不允许保存!");
                }
            }

            Long oldId = entity.getId();
            String structCode = entity.getStructCode();
            String innerCode = entity.getInnerCode();
            long id = IdWorker.getId();
            entity.setId(id);
            entity.setCode(name);

            // 树形编码
//            String detailIndex = StringUtils.replace(code, "0", "");
//            detailIndex = detailIndex.replaceAll("(.{1})", ".$1").substring(1);
//            entity.setDetailIndex(detailIndex);

            if (StringUtils.isBlank(structCode)) {
                // 新增一级树
                entity.setNodeLevel(LevelEnum.一级.getCode());
                entity.setLeafFlag(false);
                entity.setInnerCode(String.valueOf(id));
                entity.setStructCode(code);
            }else {
                long parentId = Math.abs(oldId);
                Integer nodeLevel = entity.getNodeLevel();
                // 查询子级数据
                LambdaQueryWrapper<DocEntity> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(DocEntity::getTenantId, tenantId);
                wrapper.eq(DocEntity::getParentId, parentId);
                wrapper.eq(DocEntity::getDr, 0);
                List<DocEntity> entityList = super.list(wrapper);

                if (CollectionUtils.isEmpty(entityList)) {
                    entity.setLeafFlag(true);

                    DocEntity byId = this.getById(parentId);
                    byId.setLeafFlag(false);

                    super.saveOrUpdate(byId);
                }else {
                    entity.setLeafFlag(entityList.get(0).getLeafFlag());
                }

                // 新增子级树
                entity.setStructCode(structCode + "&&" + code);
                entity.setParentId(parentId);
                entity.setInnerCode(innerCode + "&&" + id);
                entity.setNodeLevel(entity.getNodeLevel() + 1);
            }

            super.saveOrUpdate(entity, false);
            DocVO vo = BeanMapper.map(entity, DocVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);

        }

    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if(result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }

                // 同一编码覆盖，不同编码新增；
                HashMap<String, DocVO> codeMap = new HashMap<>();
                List<DocVO> errorList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DocVO vo = new DocVO();
                    vo.setExcelIndex(i + 2);
                    String warnType = "";
                    boolean flag = false;
                    String detailIndex = datas.get(0); // 序号（树形编码）
//                    String code = datas.get(1); // 节点编码
                    String name = datas.get(1); // 节点名称
                    String nodeTypeName = datas.get(2); // 节点标识名称
                    String unit = datas.get(3); // 单位

                    Long pk = IdWorker.getId();
                    String id = pk.toString();
                    vo.setId(pk);
                    if (StringUtils.isEmpty(detailIndex)) {
                        vo.setDetailIndex(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }else {
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                        if (split.length > 4) {
                            warnType = warnType + "[导入只支持4级]";
                            flag = true;
                        }
                        vo.setDetailIndex(detailIndex);
                    }

//                    if (StringUtils.isEmpty(code)) {
//                        vo.setCode(null);
//                        warnType = warnType + "[节点编码为空]";
//                        flag = true;
//                    } else {
//                        if (code.contains("&&")) {
//                            vo.setCode(null);
//                            warnType = warnType + "[节点编码含特殊字符“&&”]";
//                        } else {
//                            vo.setCode(code);
//                        }
//                    }

                    if (StringUtils.isEmpty(name)) {
                        vo.setName(null);
                        warnType = warnType + "[节点名称为空]";
                        flag = true;
                    } else {
                        if (name.contains("&&")) {
                            vo.setCode(null);
                            warnType = warnType + "[节点编码含特殊字符“&&”]";
                        } else {
                            vo.setName(name);
                            vo.setCode(name);
                        }
                    }

                    if (StringUtils.isEmpty(nodeTypeName)) {
                        vo.setNodeType(null);
                        warnType = warnType + "[节点标识为空]";
                        flag = true;
                    } else {
                        if ("非关键节点".equals(nodeTypeName)) {
                            vo.setNodeType(0);
                        } else if ("关键节点".equals(nodeTypeName)) {
                            vo.setNodeType(1);
                        } else {
                            warnType = warnType + "[节点标识不存在]";
                        }
                        vo.setNodeTypeName(nodeTypeName);
                    }


                    vo.setUnit(unit);
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setRowState("add");

                    if (flag) {
                        vo.setWarnType(warnType);
                        errorList.add(vo);
                    }else {
                        codeMap.put(name, vo);
                    }
                }

                List<DocVO> successList = new ArrayList<>(codeMap.values());
                for (DocVO vo : successList) {
                    vo.setTpid(tidMap.get(vo.getTpid()));
                }

                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(successList, Map.class));
                List<Map<String, Object>> ListCodeDate = creatCode(deailTreeData, null, null);

                // 扁平化数据
                List<Map<String, Object>> listDate = TreeUtil.treeToList(ListCodeDate);

                resp.put("successList", listDate);
                resp.put("errorList", errorList);
                resp.put("successNum", listDate.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);

            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public void insertBatch(List<DocEntity> list) {
        if(ListUtil.isNotEmpty(list)){
            super.saveBatch(list);
        }
    }

    @Override
    public List<DocEntity> queryListByArchivesId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("nodeArchivesId", new Parameter(QueryParam.LIKE, id));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        return super.queryList(param);

    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {

        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));

        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<DocEntity> pageData = queryPage(param, false);

        Map<String, Object> beans = new HashMap<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<DocVO> list = BeanMapper.mapList(pageData.getRecords(), DocVO.class);
            list.forEach(vo -> {
                if (vo.getNodeType() == 0) {
                    vo.setWarnType("非关键节点");
                }else {
                    vo.setWarnType("关键节点");
                }

            });
            Collections.sort(list, new DocComparatorVo());
            beans.put("records", list);
            ExcelExport.getInstance().export("node-doc-export.xlsx", beans, response);
        }
    }

    /**
     * 生成编码
     *
     * @param tenantid
     * @return
     */
    private String creatCode2(DocEntity entity, Long tenantid) {
        String structCode = entity.getStructCode();
        if (StringUtils.isNotBlank(structCode)) {
            String[] split = structCode.split("&&");
            structCode = split[split.length - 1];
        }
        int nodeLevel = entity.getNodeLevel() == null ? 1 : entity.getNodeLevel();
        if (nodeLevel != LevelEnum.一级.getCode()) {
            nodeLevel++;
        }
        Long oldId = entity.getId() == null ? null : Math.abs(entity.getId());
        String getMaxCode = baseMapper.getMaxCode(oldId, nodeLevel, tenantid, PartCons.DOC_LENGTH);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, PartCons.DOC_LENGTH);

        if (nodeLevel != LevelEnum.一级.getCode() && nextValue.length()  <= PartCons.DOC_LENGTH) {
            // 子级为空的树
            return structCode + nextValue;
        }

        // 一级树和非空子级树
        return nextValue;
    }

    /**
     * 生成结构码、内码、逻辑内码
     *
     * @param list
     * @param structCode
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String structCode, String innerCode) {
        for (Map<String, Object> ypd : list) {
            // 结构码
            if (StringUtils.isNotEmpty(structCode)) {
                ypd.put("structCode", structCode + "&&" + ypd.get("code"));
            } else {
                ypd.put("structCode", ypd.get("code"));
            }
            // 节点级次
            int length = ypd.get("structCode").toString().split("&&").length;
            ypd.put("nodeLevel", length);
            // 生成内码
            if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }


            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatCode((List) ypd.get("children"), ypd.get("structCode").toString(), ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            } else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }






}
