/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.handler.IPlanHandler;
import com.ejianc.business.plan.handler.PlanLockUtil;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonthHandler
implements IPlanHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMonthPlanService service;
    @Autowired
    private IMonthPlanDetailService detailService;
    @Autowired
    private IExecPlanService execService;
    @Autowired
    private IExecPlanDetailService execDetailService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public ExecPlanEntity handle(Long id) {
        MonthPlanEntity source = (MonthPlanEntity)((Object)this.service.selectById(id));
        if (source == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6708\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)id)).orderByAsc((Object)"tid");
        List<MonthPlanDetailEntity> sourceList = this.detailService.list((Wrapper)ew);
        sourceList = TreeUtils.restParentId(sourceList);
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)source.getProjectId())));
        if (data == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u751f\u6548\u603b\u8ba1\u5212\uff01");
        }
        Long execPlanId = data.getId();
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)execPlanId)).orderByAsc((Object)"tid"));
        Boolean lock = PlanLockUtil.getLock(source.getProjectId());
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u6267\u884c\u8ba1\u5212\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            List<Long> delIds;
            List<ExecPlanDetailEntity> saveList = this.transferSaveList(sourceList, detailList, execPlanId, data.getProjectId());
            if (CollectionUtils.isNotEmpty(saveList)) {
                this.execDetailService.saveOrUpdateBatch(saveList);
            }
            if (CollectionUtils.isNotEmpty(delIds = this.commonHelper.transferDelIds(sourceList, detailList, data.getProjectId(), PlanConstant.MONTH_PLAN))) {
                this.execDetailService.removeByIds(delIds);
            }
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(MonthPlanEntity::getSourceId, (Object)execPlanId);
            lambd.eq(BaseEntity::getId, (Object)id);
            this.service.update((Wrapper)lambd);
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u6708\u8ba1\u5212id-{}\u7ed9\u6267\u884c\u8ba1\u5212id-{} \u5f02\u5e38\uff0c", new Object[]{id, execPlanId, e});
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (lock.booleanValue()) {
                PlanLockUtil.releaseLock(source.getProjectId());
            }
        }
        return data;
    }

    private List<ExecPlanDetailEntity> transferSaveList(List<MonthPlanDetailEntity> sourceList, List<ExecPlanDetailEntity> detailList, Long progressId, Long projectId) {
        ArrayList<ExecPlanDetailEntity> saveList = new ArrayList<ExecPlanDetailEntity>();
        Map<String, ExecPlanDetailEntity> detailMap = detailList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getStructCode())).collect(Collectors.toMap(ProgressDetailEntity::getStructCode, x -> x));
        Map<Long, Long> idMap = CommonHelper.getIdMap(sourceList, detailList);
        List<MonthPlanDetailEntity> filterList = sourceList.stream().filter(x -> x.getPlanState() == null).collect(Collectors.toList());
        filterList.forEach(source -> {
            JSONArray assignments;
            Long TaskUID;
            JSONArray predecessorLink;
            Boolean same = this.dealSourceList(detailMap, (MonthPlanDetailEntity)((Object)source), filterList);
            ExecPlanDetailEntity vo = (ExecPlanDetailEntity)((Object)((Object)BeanMapper.map((Object)source, ExecPlanDetailEntity.class)));
            if (detailMap.containsKey(source.getStructCode()) && !same.booleanValue()) {
                ExecPlanDetailEntity detail = (ExecPlanDetailEntity)((Object)((Object)detailMap.get(source.getStructCode())));
                vo.setId(detail.getId());
                vo.setParentId(detail.getParentId());
                vo.setPercentComplete(detail.getPercentComplete());
                vo.setActualStart(detail.getActualStart());
                vo.setActualFinish(detail.getActualFinish());
                vo.setEstimateFinish(detail.getEstimateFinish());
                vo.setPredictStart(detail.getPredictStart());
                vo.setPredictFinish(detail.getPredictFinish());
                vo.setFinishNum(detail.getFinishNum());
                vo.setFinishState(detail.getFinishState());
                vo.setLightType(detail.getLightType());
                vo.setDiffValue(detail.getDiffValue());
                vo.setDiffNum(detail.getDiffNum());
                vo.setDiffType(detail.getDiffType());
                vo.setDiffResson(detail.getDiffResson());
                vo.setResourceNum(detail.getResourceNum());
                vo.setCreateTime(detail.getCreateTime());
                vo.setCreateUserCode(detail.getCreateUserCode());
                vo.setVersion(detail.getVersion());
                vo.setBimIds(detail.getBimIds());
                vo.setBimDetailIds(detail.getBimDetailIds());
                vo.setState(detail.getState());
            } else {
                vo.setParentId((Long)idMap.get(vo.getParentId()));
                vo.setCreateUserCode(null);
                vo.setCreateTime(null);
                vo.setVersion(null);
            }
            vo.setUpdateUserCode(null);
            vo.setUpdateTime(null);
            vo.setProgressId(progressId);
            vo.setSourceId(source.getProgressId());
            vo.setSourceBid(source.getSourceBid());
            vo.setPlanState(PlanConstant.MONTH_PLAN);
            vo.setPlanStart(source.getStart());
            vo.setPlanFinish(source.getFinish());
            if (vo.getActualStart() == null) {
                vo.setPredictStart(source.getStart());
                vo.setPredictFinish(source.getFinish());
            }
            if ((predecessorLink = JSONArray.parseArray((String)source.getPredecessorLink())) != null && predecessorLink.size() > 0) {
                for (int j = 0; j < predecessorLink.size(); ++j) {
                    JSONObject json = predecessorLink.getJSONObject(j);
                    Long PredecessorUID = json.getLong("PredecessorUID");
                    if (idMap.containsKey(PredecessorUID)) {
                        json.put("PredecessorUID", idMap.get(PredecessorUID));
                    }
                    if (!idMap.containsKey(TaskUID = json.getLong("TaskUID"))) continue;
                    json.put("TaskUID", idMap.get(TaskUID));
                }
                vo.setPredecessorLink(String.valueOf(predecessorLink));
            }
            if ((assignments = JSONArray.parseArray((String)source.getAssignments())) != null && assignments.size() > 0) {
                for (int j = 0; j < assignments.size(); ++j) {
                    JSONObject json = assignments.getJSONObject(j);
                    TaskUID = json.getLong("TaskUID");
                    if (!idMap.containsKey(TaskUID)) continue;
                    json.put("TaskUID", idMap.get(TaskUID));
                }
                vo.setAssignments(String.valueOf(assignments));
            }
            vo.setProjectId(projectId);
            if (vo.getConstraintDate() != null) {
                vo.setConstraintDate(DurationUtil.getConstraintDate(vo.getStart(), vo.getFinish(), vo.getConstraintType()));
            }
            if (vo.getConstraintType() == 0) {
                vo.setConstraintType(4);
                vo.setConstraintDate(vo.getStart());
            }
            vo.setFixedDate(1);
            vo.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(vo.getPredictFinish(), vo.getPlanFinish())));
            saveList.add(vo);
        });
        return saveList;
    }

    private Boolean dealSourceList(Map<String, ExecPlanDetailEntity> detailMap, MonthPlanDetailEntity source, List<MonthPlanDetailEntity> filterList) {
        ExecPlanDetailEntity detail;
        if (detailMap.containsKey(source.getStructCode()) && !(detail = detailMap.get(source.getStructCode())).getSourceId().equals(source.getProgressId())) {
            Set codeSet = detailMap.values().stream().filter(x -> x.getParentId().equals(detail.getParentId())).map(ProgressDetailEntity::getCode).filter(Objects::nonNull).collect(Collectors.toSet());
            Set sourceSet = filterList.stream().filter(x -> x.getParentId().equals(source.getParentId())).map(ProgressDetailEntity::getCode).filter(Objects::nonNull).collect(Collectors.toSet());
            codeSet.addAll(sourceSet);
            if (codeSet.contains(source.getCode())) {
                Integer maxCode = codeSet.stream().filter(x -> CommonHelper.isInteger(x)).map(x -> Integer.valueOf(x)).max(Integer::compare).orElse(0);
                Integer code = maxCode + 1;
                source.setTid(code);
                source.setCode(String.valueOf(code));
                String parentCode = detailMap.values().stream().filter(x -> x.getId().equals(detail.getParentId())).map(ProgressDetailEntity::getStructCode).findAny().orElse(null);
                source.setStructCode(parentCode != null ? parentCode + "@@" + source.getCode() : source.getCode());
                UpdateWrapper update = new UpdateWrapper();
                update.set((Object)"tid", (Object)source.getTid());
                update.set((Object)"code", (Object)source.getCode());
                update.set((Object)"struct_code", (Object)source.getStructCode());
                update.eq((Object)"id", (Object)source.getSourceBid());
                this.detailService.update((Wrapper)update);
                return true;
            }
        }
        return false;
    }

    @Override
    public ExecPlanEntity handleRollback(Long id) {
        MonthPlanEntity source = (MonthPlanEntity)((Object)this.service.selectById(id));
        if (source == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6708\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)id)).isNull((Object)"plan_state")).orderByAsc((Object)"tid");
        List sourceList = this.detailService.list((Wrapper)ew);
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)source.getProjectId())));
        if (data == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u6267\u884c\u8ba1\u5212\uff01");
        }
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)data.getId())).orderByAsc((Object)"tid"));
        MonthPlanDetailEntity entity = new MonthPlanDetailEntity();
        entity.setProgressId(id);
        entity.setStructCode("");
        List<Long> delIds = this.commonHelper.transferDelIds(sourceList, detailList, data.getProjectId(), PlanConstant.MONTH_PLAN, null);
        if (CollectionUtils.isNotEmpty(delIds)) {
            this.execDetailService.remove((Wrapper)new QueryWrapper().in((Object)"id", delIds));
        }
        return data;
    }

    @Override
    public ExecPlanEntity handleUpdate(Long id) {
        MonthPlanEntity source = (MonthPlanEntity)((Object)this.service.selectById(id));
        if (source == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)id)).orderByAsc((Object)"tid");
        List sourceList = this.detailService.list((Wrapper)ew);
        sourceList = sourceList.stream().filter(x -> x.getPlanState() == null).collect(Collectors.toList());
        ExecPlanEntity entity = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)source.getProjectId())));
        Long execPlanId = entity != null ? entity.getId() : null;
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)execPlanId)).orderByAsc((Object)"tid"));
        Boolean lock = PlanLockUtil.getLock(source.getProjectId());
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u6267\u884c\u8ba1\u5212\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            ArrayList<ExecPlanDetailEntity> saveList = new ArrayList<ExecPlanDetailEntity>();
            Map<String, ExecPlanDetailEntity> detailMap = detailList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getStructCode())).collect(Collectors.toMap(ProgressDetailEntity::getStructCode, x -> x));
            for (MonthPlanDetailEntity detail : sourceList) {
                if (!detailMap.containsKey(detail.getStructCode()) || detailMap.get(detail.getStructCode()).getEmployeeId().equals(detail.getEmployeeId())) continue;
                ExecPlanDetailEntity vo = (ExecPlanDetailEntity)((Object)BeanMapper.map((Object)((Object)detailMap.get(detail.getStructCode())), ExecPlanDetailEntity.class));
                vo.setEmployeeId(detail.getEmployeeId());
                vo.setEmployeeName(detail.getEmployeeName());
                saveList.add(vo);
            }
            if (CollectionUtils.isNotEmpty(saveList)) {
                this.execDetailService.saveOrUpdateBatch(saveList);
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u6708\u8ba1\u5212id-{}\u7ed9\u6267\u884c\u8ba1\u5212id-{} \u5f02\u5e38\uff0c", new Object[]{id, execPlanId, e});
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (lock.booleanValue()) {
                PlanLockUtil.releaseLock(source.getProjectId());
            }
        }
        return entity;
    }
}

