/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.WeekPlanChangeDetailEntity;
import com.ejianc.business.plan.bean.WeekPlanChangeEntity;
import com.ejianc.business.plan.bean.WeekPlanDetailEntity;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.mapper.WeekPlanChangeDetailMapper;
import com.ejianc.business.plan.mapper.WeekPlanChangeMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IWeekPlanChangeDetailService;
import com.ejianc.business.plan.service.IWeekPlanChangeService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.vo.WeekPlanChangeDetailVO;
import com.ejianc.business.plan.vo.WeekPlanChangeVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weekPlanChangeService")
public class WeekPlanChangeServiceImpl
extends BaseServiceImpl<WeekPlanChangeMapper, WeekPlanChangeEntity>
implements IWeekPlanChangeService {
    @Autowired
    private WeekPlanChangeMapper changeMapper;
    @Autowired
    private WeekPlanChangeDetailMapper detailChangeMapper;
    @Autowired
    private IWeekPlanChangeDetailService detailChangeService;
    @Autowired
    private IWeekPlanService weekPlanService;
    @Autowired
    private IWeekPlanDetailService weekPlanDetailService;
    @Autowired
    private IWeekPlanChangeDetailService changeDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<WeekPlanChangeVO> saveOrUpdate(WeekPlanChangeVO saveOrUpdateVO) {
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
        Long tenantId = InvocationInfoProxy.getTenantid();
        WeekPlanChangeEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            progressEntity = (WeekPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WeekPlanChangeEntity.class));
            this.changeMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.changeDetailService.deleteDetailByProgressId(progressEntity.getId());
                }
                Iterator iterator = saveVOList.iterator();
                while (iterator.hasNext()) {
                    WeekPlanChangeDetailEntity progressDetailEntity;
                    WeekPlanChangeDetailVO progressDetailVo = (WeekPlanChangeDetailVO)iterator.next();
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = WeekPlanChangeDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        this.detailChangeMapper.insert((Object)progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = WeekPlanChangeDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    this.detailChangeMapper.updateById((Object)progressDetailEntity);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (WeekPlanChangeDetailVO progressDetailVo : delDetailList) {
                    this.detailChangeMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            WeekPlanEntity weekPlanEntity = (WeekPlanEntity)((Object)this.weekPlanService.selectById(saveOrUpdateVO.getWeekId()));
            if (weekPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING) {
                throw new BusinessException("\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            Long masterPkId = IdWorker.getId();
            progressEntity = (WeekPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WeekPlanChangeEntity.class));
            progressEntity.setId(masterPkId);
            this.changeMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, true);
                for (WeekPlanChangeDetailVO progressDetailVo : saveVOList) {
                    WeekPlanChangeDetailEntity progressDetailEntity = WeekPlanChangeDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    this.detailChangeMapper.insert((Object)progressDetailEntity);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(WeekPlanEntity::getChangeId, (Object)progressEntity.getId());
            updateWrapper.set(WeekPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_ING);
            updateWrapper.set(WeekPlanEntity::getChangeCode, (Object)progressEntity.getBillCode());
            updateWrapper.eq(BaseEntity::getId, (Object)progressEntity.getWeekId());
            this.weekPlanService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public WeekPlanChangeVO queryDetail(Long id) {
        WeekPlanChangeEntity progressEntity = (WeekPlanChangeEntity)((Object)((WeekPlanChangeMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailChangeService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        WeekPlanChangeVO progressVo = (WeekPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), WeekPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<WeekPlanChangeDetailVO> progressDetailVoList = new ArrayList<WeekPlanChangeDetailVO>();
            for (WeekPlanChangeDetailEntity progressDetailEntity : progressDetailList) {
                WeekPlanChangeDetailVO changeVO = WeekPlanChangeDetailEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public WeekPlanChangeVO queryDetailChange(Long id) {
        WeekPlanEntity progressEntity = (WeekPlanEntity)((Object)this.weekPlanService.selectById(id));
        WeekPlanChangeVO vo = (WeekPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), WeekPlanChangeVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.weekPlanDetailService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<WeekPlanChangeDetailVO> progressDetailVoList = new ArrayList<WeekPlanChangeDetailVO>();
            for (WeekPlanDetailEntity progressDetailEntity : progressDetailList) {
                WeekPlanChangeDetailEntity changeDetailEntity = (WeekPlanChangeDetailEntity)((Object)BeanMapper.map((Object)((Object)progressDetailEntity), WeekPlanChangeDetailEntity.class));
                changeDetailEntity.setWeekId(changeDetailEntity.getProgressId());
                changeDetailEntity.setWeekBid(changeDetailEntity.getId());
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                changeDetailEntity.setProgressId(null);
                WeekPlanChangeDetailVO changeVO = WeekPlanChangeDetailEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setWeekId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() + 1));
        return vo;
    }

    @Override
    public void deleteWeekPlan(List<WeekPlanChangeVO> vos) {
        for (WeekPlanChangeVO vo : vos) {
            WeekPlanChangeEntity changeEntity = (WeekPlanChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(WeekPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(WeekPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getWeekId());
            this.weekPlanService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
            this.detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<WeekPlanChangeVO> queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = ((WeekPlanChangeMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"week_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, WeekPlanChangeVO.class);
            for (WeekPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(Long projectId, List<Long> ids) {
        LambdaQueryWrapper wlambd = new LambdaQueryWrapper();
        wlambd.in(BaseEntity::getId, ids);
        List list = this.weekPlanDetailService.list((Wrapper)wlambd);
        return this.commonHelper.transferDelIds(list, projectId, PlanConstant.WEEK_PLAN);
    }
}

