/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.vo.ProgressDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TreeHelper {
    public static List<ProgressDetailVO> list2Tree(List<ProgressDetailVO> list) {
        ArrayList<ProgressDetailVO> resp = new ArrayList<ProgressDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProgressDetailVO> listMap = new HashMap<String, ProgressDetailVO>();
        for (ProgressDetailVO progressDetailVo : list) {
            listMap.put(progressDetailVo.getUid().toString(), progressDetailVo);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProgressDetailVO progressDetailVo;
            progressDetailVo = list.get(i);
            String parentId = StringUtils.isNotBlank((CharSequence)progressDetailVo.getParentTaskUID()) ? progressDetailVo.getParentTaskUID() : "";
            ProgressDetailVO parent = (ProgressDetailVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(progressDetailVo);
                    continue;
                }
                ArrayList<ProgressDetailVO> children = new ArrayList<ProgressDetailVO>();
                children.add(progressDetailVo);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(progressDetailVo.getUid().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProgressDetailVO)listMap.get(rootId));
        }
        return resp;
    }

    public static void tree2List(List<ProgressDetailVO> tree) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        ArrayList<ProgressDetailVO> list = new ArrayList<ProgressDetailVO>();
        TreeHelper.getPkMap(pkMap, tree);
        TreeHelper.tree2List(pkMap, list, tree);
    }

    public static void tree2List(Map<String, Long> pkMap, List<ProgressDetailVO> list, List<ProgressDetailVO> tree) {
        TreeHelper.getPkMap(pkMap, tree);
        TreeHelper.tree2List(pkMap, list, tree, null);
    }

    private static void getPkMap(Map<String, Long> pkMap, List<ProgressDetailVO> tree) {
        int len = tree.size();
        for (int i = 0; i < len; ++i) {
            ProgressDetailVO progressVo = tree.get(i);
            Long pkId = IdWorker.getId();
            if (!"added".equals(progressVo.get_state())) {
                pkId = Long.valueOf(progressVo.getUid());
            }
            pkMap.put(progressVo.getUid(), pkId);
            List children = progressVo.getChildren();
            if (children == null || children.size() <= 0) continue;
            TreeHelper.getPkMap(pkMap, children);
        }
    }

    private static void tree2List(Map<String, Long> pkMap, List<ProgressDetailVO> list, List<ProgressDetailVO> tree, String parentCode) {
        List codeSet = tree.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getCode())).map(ProgressDetailVO::getCode).collect(Collectors.toList());
        int len = tree.size();
        for (int i = 0; i < len; ++i) {
            List children;
            ProgressDetailVO progressVo = tree.get(i);
            if (pkMap.containsKey(progressVo.getUid())) {
                progressVo.setUid(pkMap.get(progressVo.getUid()).toString());
            }
            if (StringUtils.isEmpty((CharSequence)progressVo.getCode())) {
                String code = String.valueOf(progressVo.getId());
                if (codeSet.contains(code)) {
                    Integer maxCode = codeSet.stream().filter(x -> TreeHelper.isInteger(x)).map(x -> Integer.valueOf(x)).max(Integer::compare).orElse(0);
                    code = String.valueOf(maxCode + 1);
                }
                codeSet.add(code);
                progressVo.setCode(code);
            } else {
                Long count = codeSet.stream().filter(x -> x.equals(progressVo.getCode())).count();
                if (count > 1L) {
                    throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff01");
                }
            }
            progressVo.setStructCode(parentCode != null ? parentCode + "@@" + progressVo.getCode() : progressVo.getCode());
            if (StringUtils.isNotBlank((CharSequence)progressVo.getParentTaskUID()) && pkMap.containsKey(progressVo.getParentTaskUID())) {
                progressVo.setParentTaskUID(pkMap.get(progressVo.getParentTaskUID()) + "");
            }
            progressVo.setStart(DateUtil.setHours(progressVo.getStart(), 8));
            progressVo.setFinish(DateUtil.setHours(progressVo.getFinish(), 17));
            if (progressVo.getConstraintDate() != null) {
                progressVo.setConstraintDate(DurationUtil.getConstraintDate(progressVo.getStart(), progressVo.getFinish(), progressVo.getConstraintType()));
            }
            if (progressVo.getPredecessorLink() != null && progressVo.getPredecessorLink().size() > 0) {
                for (int j = 0; j < progressVo.getPredecessorLink().size(); ++j) {
                    String TaskUID;
                    JSONObject predecessorLinkObj = progressVo.getPredecessorLink().getJSONObject(j);
                    String PredecessorUID = predecessorLinkObj.getString("PredecessorUID");
                    if (pkMap.containsKey(PredecessorUID)) {
                        predecessorLinkObj.put("PredecessorUID", (Object)pkMap.get(PredecessorUID));
                    }
                    if (!pkMap.containsKey(TaskUID = predecessorLinkObj.getString("TaskUID"))) continue;
                    predecessorLinkObj.put("TaskUID", (Object)pkMap.get(TaskUID));
                }
            }
            if (progressVo.getAssignments() != null && progressVo.getAssignments().size() > 0) {
                for (int j = 0; j < progressVo.getAssignments().size(); ++j) {
                    JSONObject assignmentsObj = progressVo.getAssignments().getJSONObject(j);
                    String TaskUID = assignmentsObj.getString("TaskUID");
                    if (!pkMap.containsKey(TaskUID)) continue;
                    assignmentsObj.put("TaskUID", (Object)pkMap.get(TaskUID));
                }
            }
            if ((children = progressVo.getChildren()) != null && children.size() > 0) {
                TreeHelper.tree2List(pkMap, list, children, progressVo.getStructCode());
            }
            progressVo.setChildren(null);
            list.add(progressVo);
        }
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }
}

