package com.ejianc.business.plan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.bean.YearPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.business.plan.vo.*;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.vo.MonthPlanVO;

/**
 * 月计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthPlan")
public class MonthPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IMonthPlanService service;
    @Autowired
    private IMonthPlanDetailService detailService;

    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IYearPlanService yearPlanService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthPlanVO> saveOrUpdate(@RequestBody MonthPlanVO saveOrUpdateVO) {
        // 日历的例外日期普加加载后有问题
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getCalendars())){
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        CommonResponse<MonthPlanVO> response = service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthPlanVO> queryDetail(Long id) {
        MonthPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthPlanVO> vos) {
        // todo 判断下级引用
        List<Long> ids = vos.stream().map(MonthPlanVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<MonthPlanEntity> page = service.queryPage(param,false);
        IPage<MonthPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MonthPlanVO> MonthPlanVOS = BeanMapper.mapList(page.getRecords(), MonthPlanVO.class);
        MonthPlanVOS.forEach(vo->{
            vo.setChangeStatusName(PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
            vo.setChangeVersionName("第"+ NumberUtil.int2chineseNum(vo.getChangeVersion())+"版");
        });
        pageData.setRecords(MonthPlanVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MonthPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMonthPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> refMonthPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("changeStatus", new Parameter(QueryParam.NE, 2));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")){
                Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }

        IPage<MonthPlanEntity> page = service.queryPage(param,false);
        IPage<MonthPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    @RequestMapping(value = "/getxml", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return service.getxml(request);
    }

    @RequestMapping(value = "/exportxml", method = RequestMethod.POST)
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        service.exportxml(response, vo);
    }


    @RequestMapping(value = "/generateMonthPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthPlanVO> generateMonthPlan(@RequestParam("projectId") Long projectId, @RequestParam("planMonth") Date planMonth,
            @RequestParam(value = "id",required = false) Long id, @RequestParam(value = "changeFlag",required = false) Boolean changeFlag){

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(planMonth).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month = Integer.valueOf(split[1]);

        //获取某月的第一天
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(Calendar.YEAR,year);
        c1.set(Calendar.MONTH,Month-1);
        int firstDay = c1.getActualMinimum(Calendar.DAY_OF_MONTH);
        c1.set(Calendar.DAY_OF_MONTH,firstDay);
        Date monthFirstDate = c1.getTime();

        //获取某月的最后一天
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(Calendar.YEAR,year);
        c2.set(Calendar.MONTH,Month-1);
        int lastDay = c2.getActualMaximum(Calendar.DAY_OF_MONTH);
        c2.set(Calendar.DAY_OF_MONTH,lastDay);
        Date monthLastDate = c2.getTime();


        if(BooleanUtils.isNotTrue(changeFlag)){
            MonthPlanVO monthPlanVO = new MonthPlanVO();
            monthPlanVO.setProjectId(projectId);
            monthPlanVO.setPlanMonth(monthFirstDate);
            monthPlanVO.setId(id);
            service.validateMonthPlan(monthPlanVO);
        }


        Integer planState = BooleanUtils.isTrue(changeFlag) ? PlanConstant.MONTH_PLAN : PlanConstant.YEAR_PLAN;
        ExecPlanVO execPlanVO = execPlanService.queryRefDetail(projectId, planState, monthFirstDate, monthLastDate, changeFlag);

        List<ExecPlanDetailVO> execlDetailList = execPlanVO.getProgressDetailList();
        List<ExecPlanDetailVO> allExeclDetailList = execPlanVO.getAllList();

        if (CollectionUtils.isEmpty(execlDetailList)){
            throw new BusinessException("该项目的年计划在"+year+"年"+Month+"月没有计划详情！");
        }

        execPlanVO.setProgressDetailList(null);
        MonthPlanVO planVO = new MonthPlanVO();
        BeanUtils.copyProperties(execPlanVO, planVO);

        List<ExecPlanDetailVO> progressDetailList = TreeHelper2.tree2List(execlDetailList);
        List<MonthPlanDetailVO> list = new ArrayList<>();
        for (ExecPlanDetailVO vo : progressDetailList){
            if(PlanConstant.MONTH_PLAN.equals(vo.getPlanState())){// 原计划新增
                vo.setPlanState(null);
            }
            if (StringUtils.isNotBlank(vo.getPercentTask())){
                vo.setName(vo.getName()+vo.getPercentTask());
            }
            MonthPlanDetailVO monthPlanDetailVO = new MonthPlanDetailVO();
            BeanUtils.copyProperties(vo, monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            list.add(monthPlanDetailVO);
        }
        List<ExecPlanDetailVO> allProgressDetailList = TreeHelper2.tree2List(allExeclDetailList);
        List<MonthPlanDetailVO> allList = new ArrayList<>();
        for (ExecPlanDetailVO vo : allProgressDetailList){
            if(PlanConstant.MONTH_PLAN.equals(vo.getPlanState())){// 原计划新增
                vo.setPlanState(null);
            }
            if (StringUtils.isNotBlank(vo.getPercentTask())){
                vo.setName(vo.getName()+vo.getPercentTask());
            }
            MonthPlanDetailVO monthPlanDetailVO = new MonthPlanDetailVO();
            BeanUtils.copyProperties(vo, monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            allList.add(monthPlanDetailVO);
        }

        List<MonthPlanDetailVO> monthPlanTree = TreeHelper2.list2Tree(list);
        List<MonthPlanDetailVO> allMonthPlanTree = TreeHelper2.list2Tree(allList);

        planVO.setProgressDetailList(monthPlanTree);
        planVO.setAllList(allMonthPlanTree);

        planVO.setSourceId(execPlanVO.getId());
        return CommonResponse.success(planVO);

    }

    /**
     * 获取日期当月月计划
     * @param projectId
     * @param date
     * @return
     */
    @RequestMapping(value = "/dateMonthPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthPlanVO> dateMonthPlan(@RequestParam("projectId") Long projectId, @RequestParam("date") String date){
        return CommonResponse.success(service.dateMonthPlan(projectId, DateUtil.parseDate(date)));
    }

}
