package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.utils.DateUtil;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

@Component
public class DurationUtil {

	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

	public static JSONObject getCalender(String calendars, String calenderUid){
		JSONArray json = JSONArray.parseArray(calendars);
		JSONObject calender = (JSONObject) json.stream().filter(x->calenderUid.equals(((JSONObject)x).getString("UID"))).findAny().orElse(new Object());
		return calender;
	}

	public static Integer calculateDuration(Date start, Date finish, JSONObject calender) {
		Integer period = DateUtil.getBetweenDays(finish, start);
		JSONArray WeekDays = new JSONArray();
		if(calender.containsKey("WeekDays")){
			WeekDays = calender.getJSONArray("WeekDays");
		}
		JSONArray Exceptions = new JSONArray();
		if(calender.containsKey("Exceptions")){
			Exceptions = calender.getJSONArray("Exceptions");
		}
		Integer duration = 1;
		Calendar cal = Calendar.getInstance();
		Date date = start;
		for(int i=0; i < period; i++){
			date = DateUtil.addDays(start, i);
			cal.setTime(date);
			Integer  DAY_OF_WEEK = DateUtil.turnZnDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			for(Object obj : WeekDays){
				Integer DayType = ((JSONObject)obj).getInteger("DayType");
				Integer DayWorking = ((JSONObject)obj).getInteger("DayWorking");
				if(DayType.equals(DAY_OF_WEEK) && DayWorking == 1){
					duration += 1;
				}
			}
			for(Object obj : Exceptions){
				JSONObject TimePeriod = ((JSONObject)obj).getJSONObject("TimePeriod");
				Date FromDate = utc2Local(TimePeriod.getString("FromDate"));
				Date ToDate = utc2Local(TimePeriod.getString("ToDate"));
				Integer DayWorking = ((JSONObject)obj).getInteger("DayWorking");
				// 普加例外日期存储00:00:00-23:59:00特殊处理
				if(FromDate.getHours() == 8){
					FromDate = utc2Local(TimePeriod.getString("FromDate"));
					ToDate = utc2Local(TimePeriod.getString("ToDate"));
				}
				if(DateUtil.compareDay(date, FromDate) >= 0 && DateUtil.compareDay(date, ToDate) <= 0){
					// 普加未选中即生效，选中表示是否将例外日期当成工作日
					if(DayWorking == 0){
						duration -= 1;
					} else {
						duration += 1;
					}
				}
			}
		}
		return duration;
	}

	/**
	 * 根据限制类型获取限制时间
	 * @param start
	 * @param finish
	 * @param constraintType
	 * @return
	 */
	public static Date getConstraintDate(Date start, Date finish, Integer constraintType){
		if(constraintType == 2 || constraintType == 4 || constraintType == 5){
			return start;
		}
		if(constraintType == 3 || constraintType == 6 || constraintType == 7){
			return finish;
		}
		return start;
	}

	public static String resetCalender(String calendars){
		JSONArray json = JSONArray.parseArray(calendars);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
		for(Object obj : json){
			JSONObject calender = (JSONObject) obj;
			JSONArray Exceptions = new JSONArray();
			if(calender.containsKey("Exceptions")){
				Exceptions = calender.getJSONArray("Exceptions");
			}
			for(Object obj2 : Exceptions){
				JSONObject TimePeriod = ((JSONObject)obj2).getJSONObject("TimePeriod");
				Date FromDate = TimePeriod.getDate("FromDate");
				Date ToDate = TimePeriod.getDate("ToDate");
				// 普加例外日期存储00:00:00-23:59:00特殊处理
				if(FromDate.getHours() == 0){
					TimePeriod.put("FromDate", sdf.format(FromDate) + ".000Z");
					TimePeriod.put("ToDate", sdf.format(ToDate) + ".000Z");
				}
			}
		}
		return json.toJSONString();
	}

	public static Date utc2Local(String time) {
		Date date = null;
		try {
			date = sdf.parse(time);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return date;
	}

	public static void main(String[] args) {
//		String calendars = "[{\"UID\":1,\"IsBaseCalendar\":1,\"BaseCalendarUID\":-1,\"Name\":\"默认日历\",\"WeekDays\":[{\"DayType\":1,\"DayWorking\":1,\"_id\":675,\"_uid\":675},{\"DayType\":2,\"DayWorking\":1,\"_id\":676,\"_uid\":676},{\"DayType\":3,\"DayWorking\":0,\"_id\":677,\"_uid\":677,\"_state\":\"modified\"},{\"DayType\":4,\"DayWorking\":1,\"_id\":678,\"_uid\":678},{\"DayType\":5,\"DayWorking\":1,\"_id\":679,\"_uid\":679},{\"DayType\":6,\"DayWorking\":1,\"_id\":680,\"_uid\":680},{\"DayType\":7,\"DayWorking\":1,\"_id\":681,\"_uid\":681}],\"Exceptions\":[{\"DayWorking\":0,\"DayType\":0,\"Name\":\"\",\"TimePeriod\":{\"FromDate\":\"2022-05-31T16:00:00.000Z\",\"ToDate\":\"2022-06-10T15:59:59.000Z\"},\"_id\":674,\"_uid\":674}]}]";
		String calendars = "[{\"UID\":\"1\",\"WeekDays\":[{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":1,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":2,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":3,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":4,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":5,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":6,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":7,\"DayWorking\":1}],\"Exceptions\":[{\"TimePeriod\":{\"FromDate\":\"2022-02-20T16:00:00.000Z\",\"ToDate\":\"2022-02-21T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"\"}],\"IsBaseCalendar\":1,\"BaseCalendarUID\":\"-1\",\"Name\":\"标准\"},{\"UID\":\"42\",\"WeekDays\":[{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":1,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":2,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":3,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":4,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":5,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":6,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":7,\"DayWorking\":1}],\"Exceptions\":[{\"TimePeriod\":{\"FromDate\":\"2016-01-27T16:00:00.000Z\",\"ToDate\":\"2016-02-21T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2016年春节\"},{\"TimePeriod\":{\"FromDate\":\"2016-08-19T16:00:00.000Z\",\"ToDate\":\"2016-09-05T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"G20峰会\"},{\"TimePeriod\":{\"FromDate\":\"2017-01-16T16:00:00.000Z\",\"ToDate\":\"2017-02-10T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2017年春节\"},{\"TimePeriod\":{\"FromDate\":\"2018-02-04T16:00:00.000Z\",\"ToDate\":\"2018-03-01T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2018年春节\"},{\"TimePeriod\":{\"FromDate\":\"2019-01-24T16:00:00.000Z\",\"ToDate\":\"2019-02-18T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2019年春节\"},{\"TimePeriod\":{\"FromDate\":\"2020-01-13T16:00:00.000Z\",\"ToDate\":\"2020-02-07T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2020年春节\"}],\"IsBaseCalendar\":1,\"BaseCalendarUID\":\"-1\",\"Name\":\"“标准”的副本\"}]";
		String c2 = resetCalender(calendars);
		System.out.println(calendars);
		System.out.println(c2);
// 		String calenderUid = "1";
//		JSONObject calender = getCalender(calendars, calenderUid);
//		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//		Date start = null;
//		Date finish = null;
//		try {
//			start = sdf.parse("2022-02-21");
//			finish = sdf.parse("2023-10-19");
//		} catch (ParseException e) {
//			e.printStackTrace();
//		}
//		Integer duration = calculateDuration(start, finish, calender);
//		System.out.println(duration);
	}

}
