package com.ejianc.business.plan.handler;

import com.ejianc.framework.cache.utils.RedisTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.annotation.PostConstruct;

@Component
public class PlanLockUtil {

    @Autowired
    private JedisPool jedisPool2;


    private static JedisPool jedisPool;


    private final static String REQUEST_ID = "ExecPlanUpdate";

    private final static String LOCK_KEY = "PLANKEY";

    private static PlanLockUtil util;


    @PostConstruct
    public void init() {
        util = this;
        jedisPool = this.jedisPool2;
    }


    public static Boolean getLock(Long id) {
        boolean locked = false;
        if (id != null) {
            Jedis jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, LOCK_KEY + id, REQUEST_ID, 1000);
            return locked;

        }
        return false;
    }

    public static void releaseLock(Long id) {
        if (id != null) {
            Jedis jedis = jedisPool.getResource();
            RedisTool.releaseLock(jedis,LOCK_KEY + id, REQUEST_ID);
            jedis.close();
        }
    }
}
