package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.TotalPlanDetailEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.MonthPlanDetailMapper;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.service.IMonthPlanDetailService;

import java.util.List;

/**
 * 月计划详情
 * 
 * @author generator
 * 
 */
@Service("monthPlanDetailService")
public class MonthPlanDetailServiceImpl extends BaseServiceImpl<MonthPlanDetailMapper, MonthPlanDetailEntity> implements IMonthPlanDetailService{

    @Override
    public void deleteDetailByProgressIds(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<MonthPlanDetailEntity>().in("progress_id", ids));
    }

    @Override
    public void deleteDetailByIds(List<Long> ids) {
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public void deleteByProgressId(Long id) {
        baseMapper.delete(new QueryWrapper<MonthPlanDetailEntity>().eq("progress_id", id));
    }
    
}
