package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanCloumCons;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.MonthPlanDetailMapper;
import com.ejianc.business.plan.mapper.MonthPlanMapper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.Export;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.*;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.MonthPlanMapper;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 月计划
 * 
 * @author generator
 * 
 */
@Service("monthPlanService")
public class MonthPlanServiceImpl extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity> implements IMonthPlanService{

    @Autowired
    private MonthPlanMapper progressMapper;
    @Autowired
    private MonthPlanDetailMapper progressDetailMapper;
    @Autowired
    private IMonthPlanDetailService detailService;
    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IExecPlanService execPlanService;

    @Autowired
    private CommonHelper commonHelper;

    @Override
    public void validateMonthPlan(MonthPlanVO saveOrUpdateVO){

        /*List<MonthPlanDetailVO> tasks = saveOrUpdateVO.getTasks();
        if (CollectionUtils.isEmpty(tasks)){
            throw new BusinessException("计划详情不能为空");
        }*/

        LambdaQueryWrapper<MonthPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MonthPlanEntity::getProjectId, saveOrUpdateVO.getProjectId());
        queryWrapper.eq(MonthPlanEntity::getPlanMonth, saveOrUpdateVO.getPlanMonth());
        queryWrapper.eq(MonthPlanEntity::getDr,0);
        queryWrapper.eq(MonthPlanEntity::getTenantId,InvocationInfoProxy.getTenantid());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), MonthPlanEntity::getId, saveOrUpdateVO.getId());
        List<MonthPlanEntity> planList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(planList)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            String formatDate = sdf.format(saveOrUpdateVO.getPlanMonth());
            String[] split = formatDate.split("-");
            throw new BusinessException("该项目在"+split[0]+"年"+split[1]+"月已存在月计划！");
        }

        LambdaQueryWrapper<YearPlanEntity> planQueryWrapper = new LambdaQueryWrapper<>();
        planQueryWrapper.eq(YearPlanEntity::getProjectId,saveOrUpdateVO.getProjectId());
        planQueryWrapper.eq(YearPlanEntity::getDr,0);
        planQueryWrapper.in(YearPlanEntity::getBillState,1,3);
        planQueryWrapper.eq(YearPlanEntity::getTenantId,InvocationInfoProxy.getTenantid());
        Calendar cal = Calendar.getInstance();
        cal.setTime(saveOrUpdateVO.getPlanMonth());
        String year = String.valueOf(cal.get(Calendar.YEAR));
        planQueryWrapper.eq(YearPlanEntity::getPlanYear, year);
        List<YearPlanEntity> yearPlanList = yearPlanService.list(planQueryWrapper);
        if (CollectionUtils.isEmpty(yearPlanList)) {
            throw new BusinessException("该项目下无审批通过的【" + year + "】年计划！");
        }

        LambdaQueryWrapper<TotalPlanEntity> totalPlanQueryWrapper = new LambdaQueryWrapper<>();
        totalPlanQueryWrapper.eq(TotalPlanEntity::getProjectId,saveOrUpdateVO.getProjectId());
        totalPlanQueryWrapper.eq(TotalPlanEntity::getDr,0);
        totalPlanQueryWrapper.in(TotalPlanEntity::getBillState,1,3);
        totalPlanQueryWrapper.eq(TotalPlanEntity::getTenantId,InvocationInfoProxy.getTenantid());
        List<TotalPlanEntity> totalPlanList = totalPlanService.list(totalPlanQueryWrapper);
        if (CollectionUtils.isEmpty(totalPlanList)) {
            throw new BusinessException("该项目下无审批通过的总计划！");
        }

    }

    @Override
    public MonthPlanVO dateMonthPlan(Long projectId, Date date) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        param.getParams().put("planMonth", new Parameter(QueryParam.EQ, sdf.format(date) + "-01"));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<MonthPlanEntity> monthList = super.queryList(param);
        if(CollectionUtils.isEmpty(monthList)){
            return null;
        }
        return BeanMapper.map(monthList.get(0), MonthPlanVO.class);
    }

    @Override
    public CommonResponse<MonthPlanVO> saveOrUpdate(MonthPlanVO saveOrUpdateVO) {

        validateMonthPlan(saveOrUpdateVO);
        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());

        OrgVO orgVO = orgUtil.findById(saveOrUpdateVO.getOrgId());
        saveOrUpdateVO.setCorpId(orgVO.getId());
        saveOrUpdateVO.setCorpCode(orgVO.getCode());
        saveOrUpdateVO.setCorpName(orgVO.getName());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String formatDate = sdf.format(saveOrUpdateVO.getPlanMonth());
        saveOrUpdateVO.setBillCode("Y"+formatDate);

        MonthPlanEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改

            MonthPlanEntity monthPlanEntity = progressMapper.selectById(saveOrUpdateVO.getId());
            progressEntity = BeanMapper.map(saveOrUpdateVO, MonthPlanEntity.class);
            progressMapper.updateById(progressEntity);

            //子表
            List<MonthPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<MonthPlanDetailVO> saveVOList = new ArrayList<MonthPlanDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList,saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                List<MonthPlanDetailEntity> planEntityList = new ArrayList<>();
                if (saveOrUpdateVO.getImportFlag() || monthPlanEntity.getPlanMonth() != saveOrUpdateVO.getPlanMonth()) {
                    detailService.deleteByProgressId(progressEntity.getId());
                    for (MonthPlanDetailVO progressDetailVo : saveVOList) {
                        MonthPlanDetailEntity progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        planEntityList.add(progressDetailEntity);
                    }
                }else{
                    for (MonthPlanDetailVO progressDetailVo : saveVOList) {
                        if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                            MonthPlanDetailEntity progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                            progressDetailEntity.setProgressId(progressEntity.getId());
                            planEntityList.add(progressDetailEntity);
                        } else if ("modified".equals(progressDetailVo.get_state())) {
                            MonthPlanDetailEntity progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                            progressDetailEntity.setProgressId(progressEntity.getId());
                            progressDetailMapper.updateById(progressDetailEntity);
                        }
                    }
                }

                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailService.saveOrUpdateBatch(planEntityList);
                }
            }
            //子表删除
            List<MonthPlanDetailVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (MonthPlanDetailVO progressDetailVo : delDetailList) {
                    progressDetailMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            Long masterPkId = IdWorker.getId();
            progressEntity = BeanMapper.map(saveOrUpdateVO, MonthPlanEntity.class);
            progressEntity.setId(masterPkId);
            progressEntity.setChangeVersion(1);
            progressEntity.setChangeStatus(PlanConstant.CHANGE_NO);
            progressMapper.insert(progressEntity);

            //子表
            List<MonthPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();

            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<MonthPlanDetailVO> saveVOList = new ArrayList<MonthPlanDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList,saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                List<MonthPlanDetailEntity> planEntityList = new ArrayList<>();
                for (MonthPlanDetailVO progressDetailVo : saveVOList) {
                    MonthPlanDetailEntity progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }

                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailService.saveOrUpdateBatch(planEntityList);
                }
            }
        }

        // 生效后更新执行计划
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())
                || BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())){
            execPlanService.updateExecPlan(saveOrUpdateVO.getId(), PlanConstant.MONTH_PLAN);
        }

        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    @Override
    public MonthPlanVO queryDetail(Long id) {
        MonthPlanEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<MonthPlanDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<MonthPlanDetailEntity> progressDetailList = detailService.list(queryWrapper);

        MonthPlanVO progressVo = BeanMapper.map(progressEntity, MonthPlanVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<MonthPlanDetailVO> progressDetailVoList = new ArrayList<>();
            for (MonthPlanDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(MonthPlanDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public Map getDetail(Long id) {
        MonthPlanVO monthPlanVO = queryDetail(id);
        Map map = new HashMap();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List<MonthPlanDetailVO> detailList = monthPlanVO.getProgressDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> pkMap = new HashMap<>();
            List<MonthPlanDetailVO> saveVOList = new ArrayList<MonthPlanDetailVO>();
            TreeHelper2.tree2List(pkMap, saveVOList, detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List<Map> list = JSONObject.parseArray(jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") != null) {
                    List<Map> link = JSONObject.parseArray(JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                    m.put("PredecessorLink", link);
                }
            }
            key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", null);
        }
        map.put("MinutesPerWeek", null);
        String calendars = monthPlanVO.getCalendars();
        if (StringUtils.isNotBlank(calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", monthPlanVO.getPlanEndDate());
        map.put("Name", monthPlanVO.getProjectName());
        map.put("StartDate", monthPlanVO.getPlanBeginDate());
        map.put("CalendarUID", monthPlanVO.getCalendarUid());
        map.put("UID", monthPlanVO.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }


    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = getDetail(vo.getId());
        Export.exportExtendedAttributes((HashMap) dataProject);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.TOTAL_PLAN_CLOUM);
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xml".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            HashMap read = PlusUtil.read(file, PlanCloumCons.MONTH_PLAN_CLOUM);
//            Map<String, Map> filed = new HashMap<>();
//            filed.put("taskLine", PlanConstant.TASK_LINE);
//            filed.put("nodeLevel", PlanConstant.NODE_LEVEL);
//            filed.put("unit", PlanConstant.UNIT);
//            filed.put("type", PlanConstant.RESOURCE_TYPE);
//            filed.put("typeUnit", PlanConstant.RESOURCE_UNIT);
            Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList) read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
            HashMap hashMap = PlusUtil.readMain(read, filed);

            Long projectId = Long.valueOf(request.getParameter("project"));
            String planMonth = request.getParameter("planMonth");

            String[] split = planMonth.split("-");
            Integer year = Integer.valueOf(split[0]);
            Integer Month = Integer.valueOf(split[1]);

            //获取某月的第一天
            Calendar c1 = Calendar.getInstance();
            c1.clear();
            c1.set(Calendar.YEAR,year);
            c1.set(Calendar.MONTH,Month-1);
            int firstDay = c1.getActualMinimum(Calendar.DAY_OF_MONTH);
            c1.set(Calendar.DAY_OF_MONTH,firstDay);
            Date monthFirstDate = c1.getTime();

            //获取某月的最后一天
            Calendar c2 = Calendar.getInstance();
            c2.clear();
            c2.set(Calendar.YEAR,year);
            c2.set(Calendar.MONTH,Month-1);
            int lastDay = c2.getActualMaximum(Calendar.DAY_OF_MONTH);
            c2.set(Calendar.DAY_OF_MONTH,lastDay);
            Date monthLastDate = c2.getTime();


            Object tasks = hashMap.get("Tasks");
            Date startDate = DateUtil.beginOfDate(monthFirstDate);
            Date endDate = DateUtil.endOfDate(monthLastDate);

            // 日历替换成执行计划日历
            commonHelper.getExecClandars(hashMap, projectId);
            Object o = execPlanService.converMap(tasks,startDate,endDate,projectId);
            hashMap.put("Tasks",o);


            return CommonResponse.success("解析数据成功！", hashMap);
        }
    }

    private List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            key2Value(map, "unit", PlanConstant.UNIT);
            key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

    
    
}
