package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.WeekPlanDetailMapper;
import com.ejianc.business.plan.bean.WeekPlanDetailEntity;
import com.ejianc.business.plan.service.IWeekPlanDetailService;

import java.util.List;

/**
 * 周计划详情
 * 
 * @author generator
 * 
 */
@Service("weekPlanDetailService")
public class WeekPlanDetailServiceImpl extends BaseServiceImpl<WeekPlanDetailMapper, WeekPlanDetailEntity> implements IWeekPlanDetailService{

    @Override
    public void deleteDetailByProgressIds(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<WeekPlanDetailEntity>().in("progress_id", ids));
    }

    @Override
    public void deleteDetailByIds(List<Long> ids) {
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public void deleteByProgressId(Long id) {
        baseMapper.delete(new QueryWrapper<WeekPlanDetailEntity>().eq("progress_id", id));
    }
}
