package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.YearPlanDetailHistoryEntity;
import com.ejianc.business.plan.bean.YearPlanHistoryEntity;
import com.ejianc.business.plan.service.IYearPlanDetailHistoryService;
import com.ejianc.business.plan.service.IYearPlanDetailHistoryService;
import com.ejianc.business.plan.vo.YearPlanDetailHistoryVO;
import com.ejianc.business.plan.vo.YearPlanHistoryVO;
import com.ejianc.business.plan.vo.YearPlanHistoryVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.YearPlanHistoryMapper;
import com.ejianc.business.plan.bean.YearPlanHistoryEntity;
import com.ejianc.business.plan.service.IYearPlanHistoryService;

import java.util.ArrayList;
import java.util.List;

/**
 * 年计划历史
 * 
 * @author generator
 * 
 */
@Service("yearPlanHistoryService")
public class YearPlanHistoryServiceImpl extends BaseServiceImpl<YearPlanHistoryMapper, YearPlanHistoryEntity> implements IYearPlanHistoryService{

    @Autowired
    private IYearPlanDetailHistoryService detailHistoryService;

    @Override
    public YearPlanHistoryVO queryDetailByChangeId(Long id) {
        YearPlanHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<YearPlanHistoryEntity>().eq("change_id", id));
        if (historyEntity != null) {
            YearPlanHistoryVO historyVo = BeanMapper.map(historyEntity, YearPlanHistoryVO.class);
            //查询子表
            QueryWrapper<YearPlanDetailHistoryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("progress_id", historyVo.getId());
            queryWrapper.orderByAsc("tid");
            List<YearPlanDetailHistoryEntity> progressDetailList = detailHistoryService.list(queryWrapper);

            if (progressDetailList != null && progressDetailList.size() > 0) {
                List<YearPlanDetailHistoryVO> progressDetailVoList = new ArrayList<>();
                for (YearPlanDetailHistoryEntity progressDetailEntity : progressDetailList) {
                    progressDetailVoList.add(YearPlanDetailHistoryEntity.convertEntityToVo(progressDetailEntity));
                }
                historyVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
            }
            return historyVo;
        }
        return null;
    }
    
}
