package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.progress.bean.RiskCorrectionHistoryEntity;
import com.ejianc.business.progress.mapper.RiskCorrectionHistoryMapper;
import com.ejianc.business.progress.service.IRiskCorrectionHistoryService;
import com.ejianc.business.progress.vo.RiskCorrectionHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 风险纠偏历史
 * 
 * @author generator
 * 
 */
@Service("riskCorrectionHistoryService")
public class RiskCorrectionHistoryServiceImpl extends BaseServiceImpl<RiskCorrectionHistoryMapper, RiskCorrectionHistoryEntity> implements IRiskCorrectionHistoryService{

    @Override
    public List<RiskCorrectionHistoryVO> queryList(Long riskId) {
        LambdaQueryWrapper<RiskCorrectionHistoryEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BaseEntity::getDr, 0).eq(RiskCorrectionHistoryEntity::getRiskId, riskId);
        List<RiskCorrectionHistoryEntity> list = this.list(wrapper);
        return BeanMapper.mapList(list, RiskCorrectionHistoryVO.class);
    }
}
