/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.bean.YearPlanEntity;
import com.ejianc.business.plan.cons.PlanCloumCons;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.MonthPlanDetailMapper;
import com.ejianc.business.plan.mapper.MonthPlanMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.Export;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.plan.vo.MonthPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="monthPlanService")
public class MonthPlanServiceImpl
extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity>
implements IMonthPlanService {
    @Autowired
    private MonthPlanMapper progressMapper;
    @Autowired
    private MonthPlanDetailMapper progressDetailMapper;
    @Autowired
    private IMonthPlanDetailService detailService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public void validateMonthPlan(MonthPlanVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MonthPlanEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper.eq(MonthPlanEntity::getPlanMonth, (Object)saveOrUpdateVO.getPlanMonth());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        List planList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)planList)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            String formatDate = sdf.format(saveOrUpdateVO.getPlanMonth());
            String[] split = formatDate.split("-");
            throw new BusinessException("\u8be5\u9879\u76ee\u5728" + split[0] + "\u5e74" + split[1] + "\u6708\u5df2\u5b58\u5728\u6708\u8ba1\u5212\uff01");
        }
        LambdaQueryWrapper planQueryWrapper = new LambdaQueryWrapper();
        planQueryWrapper.eq(YearPlanEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        planQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        planQueryWrapper.in(YearPlanEntity::getBillState, new Object[]{1, 3});
        planQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        Calendar cal = Calendar.getInstance();
        cal.setTime(saveOrUpdateVO.getPlanMonth());
        String year = String.valueOf(cal.get(1));
        planQueryWrapper.eq(YearPlanEntity::getPlanYear, (Object)year);
        List yearPlanList = this.yearPlanService.list((Wrapper)planQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)yearPlanList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u65e0\u5ba1\u6279\u901a\u8fc7\u7684\u3010" + year + "\u3011\u5e74\u8ba1\u5212\uff01");
        }
        LambdaQueryWrapper totalPlanQueryWrapper = new LambdaQueryWrapper();
        totalPlanQueryWrapper.eq(TotalPlanEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        totalPlanQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        totalPlanQueryWrapper.in(TotalPlanEntity::getBillState, new Object[]{1, 3});
        totalPlanQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List totalPlanList = this.totalPlanService.list((Wrapper)totalPlanQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)totalPlanList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u65e0\u5ba1\u6279\u901a\u8fc7\u7684\u603b\u8ba1\u5212\uff01");
        }
    }

    @Override
    public MonthPlanVO dateMonthPlan(Long projectId, Date date) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        param.getParams().put("planMonth", new Parameter("eq", (Object)(sdf.format(date) + "-01")));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List monthList = super.queryList(param);
        if (CollectionUtils.isEmpty((Collection)monthList)) {
            return null;
        }
        return (MonthPlanVO)BeanMapper.map(monthList.get(0), MonthPlanVO.class);
    }

    @Override
    public CommonResponse<MonthPlanVO> saveOrUpdate(MonthPlanVO saveOrUpdateVO) {
        this.validateMonthPlan(saveOrUpdateVO);
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
        OrgVO orgVO = this.orgUtil.findById(saveOrUpdateVO.getOrgId());
        saveOrUpdateVO.setCorpId(orgVO.getId());
        saveOrUpdateVO.setCorpCode(orgVO.getCode());
        saveOrUpdateVO.setCorpName(orgVO.getName());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String formatDate = sdf.format(saveOrUpdateVO.getPlanMonth());
        saveOrUpdateVO.setBillCode("Y" + formatDate);
        MonthPlanEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            List delDetailList;
            MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)this.progressMapper.selectById(saveOrUpdateVO.getId()));
            progressEntity = (MonthPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MonthPlanEntity.class));
            this.progressMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                MonthPlanDetailEntity progressDetailEntity;
                MonthPlanDetailVO progressDetailVo;
                Iterator iterator;
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                List<MonthPlanDetailEntity> planEntityList = new ArrayList();
                if (saveOrUpdateVO.getImportFlag().booleanValue() || monthPlanEntity.getPlanMonth() != saveOrUpdateVO.getPlanMonth()) {
                    this.detailService.deleteByProgressId(progressEntity.getId());
                    iterator = saveVOList.iterator();
                    while (iterator.hasNext()) {
                        progressDetailVo = (MonthPlanDetailVO)iterator.next();
                        progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        planEntityList.add(progressDetailEntity);
                    }
                } else {
                    iterator = saveVOList.iterator();
                    while (iterator.hasNext()) {
                        progressDetailVo = (MonthPlanDetailVO)iterator.next();
                        if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                            progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                            progressDetailEntity.setProgressId(progressEntity.getId());
                            planEntityList.add(progressDetailEntity);
                            continue;
                        }
                        if (!"modified".equals(progressDetailVo.get_state())) continue;
                        progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        this.progressDetailMapper.updateById((Object)progressDetailEntity);
                    }
                }
                if (CollectionUtils.isNotEmpty(planEntityList)) {
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    this.detailService.saveOrUpdateBatch(planEntityList);
                }
            }
            if ((delDetailList = saveOrUpdateVO.getRemovedTasks()) != null && delDetailList.size() > 0) {
                for (MonthPlanDetailVO progressDetailVo : delDetailList) {
                    this.progressDetailMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            Long masterPkId = IdWorker.getId();
            progressEntity = (MonthPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MonthPlanEntity.class));
            progressEntity.setId(masterPkId);
            progressEntity.setChangeVersion(1);
            progressEntity.setChangeStatus(PlanConstant.CHANGE_NO);
            this.progressMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                List<MonthPlanDetailEntity> planEntityList = new ArrayList();
                for (MonthPlanDetailVO progressDetailVo : saveVOList) {
                    MonthPlanDetailEntity progressDetailEntity = MonthPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }
                if (CollectionUtils.isNotEmpty(planEntityList)) {
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    this.detailService.saveOrUpdateBatch(planEntityList);
                }
            }
        }
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())) {
            this.execPlanService.updateExecPlan(saveOrUpdateVO.getId(), PlanConstant.MONTH_PLAN);
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public MonthPlanVO queryDetail(Long id) {
        MonthPlanEntity progressEntity = (MonthPlanEntity)((Object)((MonthPlanMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailService.list((Wrapper)queryWrapper);
        MonthPlanVO progressVo = (MonthPlanVO)BeanMapper.map((Object)((Object)progressEntity), MonthPlanVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<MonthPlanDetailVO> progressDetailVoList = new ArrayList<MonthPlanDetailVO>();
            for (MonthPlanDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(MonthPlanDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public Map getDetail(Long id) {
        MonthPlanVO monthPlanVO = this.queryDetail(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List detailList = monthPlanVO.getProgressDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            HashMap<String, Long> pkMap = new HashMap<String, Long>();
            ArrayList saveVOList = new ArrayList();
            TreeHelper2.tree2List(pkMap, saveVOList, detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List list = JSONObject.parseArray((String)jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") == null) continue;
                List link = JSONObject.parseArray((String)JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                m.put("PredecessorLink", link);
            }
            this.key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", null);
        }
        map.put("MinutesPerWeek", null);
        String calendars = monthPlanVO.getCalendars();
        if (StringUtils.isNotBlank((CharSequence)calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", monthPlanVO.getPlanEndDate());
        map.put("Name", monthPlanVO.getProjectName());
        map.put("StartDate", monthPlanVO.getPlanBeginDate());
        map.put("CalendarUID", monthPlanVO.getCalendarUid());
        map.put("UID", monthPlanVO.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = this.getDetail(vo.getId());
        Export.exportExtendedAttributes((HashMap)dataProject);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.TOTAL_PLAN_CLOUM);
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            file = (MultipartFile)entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            extName = FileUtils.getFileExt((String)(originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_")), (Boolean)false);
            if ("xml".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        HashMap read = PlusUtil.read(file, PlanCloumCons.MONTH_PLAN_CLOUM);
        Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList)read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
        HashMap hashMap = PlusUtil.readMain(read, filed);
        Long projectId = Long.valueOf(request.getParameter("project"));
        String planMonth = request.getParameter("planMonth");
        String[] split = planMonth.split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month2 = Integer.valueOf(split[1]);
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(1, year);
        c1.set(2, Month2 - 1);
        int firstDay = c1.getActualMinimum(5);
        c1.set(5, firstDay);
        Date monthFirstDate = c1.getTime();
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(1, year);
        c2.set(2, Month2 - 1);
        int lastDay = c2.getActualMaximum(5);
        c2.set(5, lastDay);
        Date monthLastDate = c2.getTime();
        Object tasks = hashMap.get("Tasks");
        Date startDate = DateUtil.beginOfDate(monthFirstDate);
        Date endDate = DateUtil.endOfDate(monthLastDate);
        this.commonHelper.getExecClandars(hashMap, projectId);
        Object o = this.execPlanService.converMap(tasks, startDate, endDate, projectId);
        hashMap.put("Tasks", o);
        return CommonResponse.success((String)"\u89e3\u6790\u6570\u636e\u6210\u529f\uff01", (Object)hashMap);
    }

    private List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            this.key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            this.key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            this.key2Value(map, "unit", PlanConstant.UNIT);
            this.key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            this.key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }
}

