/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.TotalPlanChangeEntity;
import com.ejianc.business.plan.bean.TotalPlanDetailChangeEntity;
import com.ejianc.business.plan.bean.TotalPlanDetailEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.TotalPlanChangeMapper;
import com.ejianc.business.plan.mapper.TotalPlanDetailChangeMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.ITotalPlanChangeService;
import com.ejianc.business.plan.service.ITotalPlanDetailChangeService;
import com.ejianc.business.plan.service.ITotalPlanDetailService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.vo.TotalPlanChangeVO;
import com.ejianc.business.plan.vo.TotalPlanDetailChangeVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="totalPlanChangeService")
public class TotalPlanChangeServiceImpl
extends BaseServiceImpl<TotalPlanChangeMapper, TotalPlanChangeEntity>
implements ITotalPlanChangeService {
    @Autowired
    private TotalPlanChangeMapper changeMapper;
    @Autowired
    private TotalPlanDetailChangeMapper detailChangeMapper;
    @Autowired
    private ITotalPlanDetailChangeService detailChangeService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private ITotalPlanDetailService totalPlanDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<TotalPlanChangeVO> saveOrUpdate(TotalPlanChangeVO saveOrUpdateVO) {
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanChangeEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            progressEntity = (TotalPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TotalPlanChangeEntity.class));
            this.changeMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.detailChangeService.deleteDetailByProgressId(progressEntity.getId());
                }
                Iterator iterator = saveVOList.iterator();
                while (iterator.hasNext()) {
                    TotalPlanDetailChangeEntity progressDetailEntity;
                    TotalPlanDetailChangeVO progressDetailVo = (TotalPlanDetailChangeVO)iterator.next();
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = TotalPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        this.detailChangeMapper.insert((Object)progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = TotalPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    this.detailChangeMapper.updateById((Object)progressDetailEntity);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (TotalPlanDetailChangeVO progressDetailVo : delDetailList) {
                    this.detailChangeMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            TotalPlanEntity totalPlanEntity = (TotalPlanEntity)((Object)this.totalPlanService.selectById(saveOrUpdateVO.getTotalId()));
            if (totalPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING) {
                throw new BusinessException("\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            Long masterPkId = IdWorker.getId();
            progressEntity = (TotalPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TotalPlanChangeEntity.class));
            progressEntity.setId(masterPkId);
            this.changeMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                List<TotalPlanDetailChangeEntity> planEntityList = new ArrayList();
                for (TotalPlanDetailChangeVO progressDetailVo : saveVOList) {
                    TotalPlanDetailChangeEntity progressDetailEntity = TotalPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }
                if (CollectionUtils.isNotEmpty(planEntityList)) {
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    this.detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(TotalPlanEntity::getChangeId, (Object)progressEntity.getId());
            updateWrapper.set(TotalPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_ING);
            updateWrapper.set(TotalPlanEntity::getChangeCode, (Object)progressEntity.getBillCode());
            updateWrapper.eq(BaseEntity::getId, (Object)progressEntity.getTotalId());
            this.totalPlanService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public TotalPlanChangeVO queryDetail(Long id) {
        TotalPlanChangeEntity progressEntity = (TotalPlanChangeEntity)((Object)((TotalPlanChangeMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailChangeService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        TotalPlanChangeVO progressVo = (TotalPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), TotalPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<TotalPlanDetailChangeVO> progressDetailVoList = new ArrayList<TotalPlanDetailChangeVO>();
            for (TotalPlanDetailChangeEntity progressDetailEntity : progressDetailList) {
                TotalPlanDetailChangeVO changeVO = TotalPlanDetailChangeEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public TotalPlanChangeVO queryDetailChange(Long id) {
        TotalPlanEntity progressEntity = (TotalPlanEntity)((Object)this.totalPlanService.selectById(id));
        TotalPlanChangeVO vo = (TotalPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), TotalPlanChangeVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.totalPlanDetailService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<TotalPlanDetailChangeVO> progressDetailVoList = new ArrayList<TotalPlanDetailChangeVO>();
            for (TotalPlanDetailEntity progressDetailEntity : progressDetailList) {
                TotalPlanDetailChangeEntity changeDetailEntity = (TotalPlanDetailChangeEntity)((Object)BeanMapper.map((Object)((Object)progressDetailEntity), TotalPlanDetailChangeEntity.class));
                changeDetailEntity.setTotalId(changeDetailEntity.getProgressId());
                changeDetailEntity.setTotalBid(changeDetailEntity.getId());
                changeDetailEntity.setProgressId(null);
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                TotalPlanDetailChangeVO changeVO = TotalPlanDetailChangeEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setTotalId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() + 1));
        return vo;
    }

    @Override
    public void deleteTotalPlan(List<TotalPlanChangeVO> vos) {
        for (TotalPlanChangeVO vo : vos) {
            TotalPlanChangeEntity changeEntity = (TotalPlanChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(TotalPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(TotalPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getTotalId());
            this.totalPlanService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
            this.detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<TotalPlanChangeVO> queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = ((TotalPlanChangeMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"total_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, TotalPlanChangeVO.class);
            for (TotalPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(Long projectId, List<Long> ids) {
        LambdaQueryWrapper ylambd = new LambdaQueryWrapper();
        ylambd.in(BaseEntity::getId, ids);
        List list = this.totalPlanDetailService.list((Wrapper)ylambd);
        return this.commonHelper.transferDelIds(list, projectId, PlanConstant.TOTAL_PLAN);
    }
}

