/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weekPlan")
public class WeekPlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private CommonHelper commonHelper;
    @Autowired
    private IWeekPlanService service;
    @Autowired
    private IWeekPlanDetailService detailService;
    @Autowired
    private IExecPlanService execPlanService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(WeekPlanEntity::getCommitTime, (Object)new Date());
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.service.update((Wrapper)lambd);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state) {
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(WeekPlanEntity::getCommitTime, (Object)new Date());
            lambd.eq(BaseEntity::getId, (Object)billId);
            this.service.update((Wrapper)lambd);
        }
        WeekPlanEntity weekPlanEntity = (WeekPlanEntity)((Object)this.service.selectById(billId));
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(WeekPlanEntity::getApprovedTime, (Object)new Date());
        if (weekPlanEntity.getStartDate() != null) {
            Integer subDay = DateUtil.getSubDay(new Date(), weekPlanEntity.getPlanBeginDate());
            lambd.set(WeekPlanEntity::getFinishFlag, (Object)subDay);
        }
        if (state == 1) {
            lambd.set(WeekPlanEntity::getCommitTime, (Object)new Date());
        }
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.service.update((Wrapper)lambd);
        this.execPlanService.pushExecPlan(billId, PlanConstant.WEEK_PLAN);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        WeekPlanEntity entity = (WeekPlanEntity)((Object)this.service.selectById(billId));
        this.execPlanService.validateProject(entity.getProjectId(), billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(WeekPlanEntity::getCommitTime, null);
        lambd.set(WeekPlanEntity::getApprovedTime, null);
        lambd.set(WeekPlanEntity::getFinishFlag, null);
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.service.update((Wrapper)lambd);
        this.execPlanService.pushExecPlanRollBack(billId, PlanConstant.WEEK_PLAN);
        return CommonResponse.success();
    }
}

