/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.progress.bean.DocEntity;
import com.ejianc.business.progress.service.IDocService;
import com.ejianc.business.progress.service.INodeArchivesService;
import com.ejianc.business.progress.utils.TreeNodeBUtil;
import com.ejianc.business.progress.vo.DocVO;
import com.ejianc.business.progress.vo.comparator.DocComparatorVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"doc"})
public class DocController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDocService service;
    @Autowired
    private INodeArchivesService archivesService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DocVO> saveOrUpdate(@RequestBody DocVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocVO> queryDetail(Long id) {
        DocEntity entity = (DocEntity)((Object)this.service.selectById(id));
        DocVO vo = (DocVO)BeanMapper.map((Object)((Object)entity), DocVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isEmpty(ids)) {
            return CommonResponse.success((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DocVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String nodeArchivesId = ((Parameter)param.getParams().get("nodeArchivesId")).getValue().toString();
        if (StringUtils.isBlank((CharSequence)nodeArchivesId)) {
            Page pageData = new Page(1L, 10L, 0L);
            pageData.setRecords(new ArrayList());
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        List<Long> ids = this.archivesService.getChildIds(Long.parseLong(nodeArchivesId));
        param.getParams().put("nodeArchivesId", new Parameter("in", ids));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List docVOList = BeanMapper.mapList((Iterable)page.getRecords(), DocVO.class);
        Collections.sort(docVOList, new DocComparatorVo());
        pageData.setRecords(TreeNodeBUtil.buildTree((List)docVOList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelCategory(HttpServletRequest request, @RequestBody List<DocVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String nodeArchivesId = request.getParameter("nodeArchivesId");
        ArrayList<DocEntity> list = new ArrayList<DocEntity>();
        importVOS.forEach(importVO -> {
            importVO.setNodeArchivesId(Long.valueOf(nodeArchivesId));
            String tPid = importVO.getTpid();
            if (StringUtils.isNotBlank((CharSequence)tPid)) {
                importVO.setParentId(Long.valueOf(tPid));
            }
            list.add((DocEntity)((Object)BeanMapper.map((Object)importVO, DocEntity.class)));
        });
        this.service.insertBatch(list);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"node-doc-import.xlsx", (String)"\u8282\u70b9\u6863\u6848\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.service.excelExport(param, response);
    }
}

