/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.progress.bean.DocEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.mapper.DocMapper;
import com.ejianc.business.progress.service.IDocService;
import com.ejianc.business.progress.utils.DetailIndexExcelReader;
import com.ejianc.business.progress.utils.ExcelImportUtil;
import com.ejianc.business.progress.utils.InnerCodeTool;
import com.ejianc.business.progress.utils.TreeUtil;
import com.ejianc.business.progress.vo.DocVO;
import com.ejianc.business.progress.vo.comparator.DocComparatorVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="docService")
public class DocServiceImpl
extends BaseServiceImpl<DocMapper, DocEntity>
implements IDocService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<DocVO> saveOrUpdate(DocVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (saveorUpdateVO.getNodeArchivesId() == null || saveorUpdateVO.getNodeArchivesId() <= 0L) {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u5206\u7c7b!");
        }
        DocEntity entity = (DocEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, DocEntity.class));
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity.setTenantId(tenantId);
            entity.setCode(entity.getName());
            super.saveOrUpdate((Object)entity, false);
            DocVO vo = (DocVO)BeanMapper.map((Object)((Object)entity), DocVO.class);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
        }
        String code = entity.getCode();
        String name = entity.getName();
        if (StringUtils.isBlank((CharSequence)code)) {
            code = name;
        } else {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(DocEntity::getName, (Object)entity.getName());
            lambda.eq(BaseEntity::getDr, (Object)0);
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u8282\u70b9\u540d\u79f0\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        Long oldId = entity.getId();
        String structCode = entity.getStructCode();
        String innerCode = entity.getInnerCode();
        long id = IdWorker.getId();
        entity.setId(id);
        entity.setCode(name);
        if (StringUtils.isBlank((CharSequence)structCode)) {
            entity.setNodeLevel(LevelEnum.\u4e00\u7ea7.getCode());
            entity.setLeafFlag(false);
            entity.setInnerCode(String.valueOf(id));
            entity.setStructCode(code);
        } else {
            long parentId = Math.abs(oldId);
            Integer nodeLevel = entity.getNodeLevel();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
            wrapper.eq(DocEntity::getParentId, (Object)parentId);
            wrapper.eq(BaseEntity::getDr, (Object)0);
            List entityList = super.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)entityList)) {
                entity.setLeafFlag(true);
                DocEntity byId = (DocEntity)((Object)this.getById(Long.valueOf(parentId)));
                byId.setLeafFlag(false);
                super.saveOrUpdate((Object)byId);
            } else {
                entity.setLeafFlag(((DocEntity)((Object)entityList.get(0))).getLeafFlag());
            }
            entity.setStructCode(structCode + "&&" + code);
            entity.setParentId(parentId);
            entity.setInnerCode(innerCode + "&&" + id);
            entity.setNodeLevel(entity.getNodeLevel() + 1);
        }
        super.saveOrUpdate((Object)entity, false);
        DocVO vo = (DocVO)BeanMapper.map((Object)((Object)entity), DocVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, DocVO> codeMap = new HashMap<String, DocVO>();
            ArrayList<DocVO> errorList = new ArrayList<DocVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DocVO vo = new DocVO();
                vo.setExcelIndex(Integer.valueOf(i + 2));
                String warnType = "";
                boolean flag = false;
                String detailIndex = (String)datas.get(0);
                String name = (String)datas.get(1);
                String nodeTypeName = (String)datas.get(2);
                String unit = (String)datas.get(3);
                Long pk = IdWorker.getId();
                String id = pk.toString();
                vo.setId(pk);
                if (StringUtils.isEmpty((CharSequence)detailIndex)) {
                    vo.setDetailIndex(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                    if (split.length > 4) {
                        warnType = warnType + "[\u5bfc\u5165\u53ea\u652f\u63014\u7ea7]";
                        flag = true;
                    }
                    vo.setDetailIndex(detailIndex);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "[\u8282\u70b9\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else if (name.contains("&&")) {
                    vo.setCode(null);
                    warnType = warnType + "[\u8282\u70b9\u7f16\u7801\u542b\u7279\u6b8a\u5b57\u7b26\u201c&&\u201d]";
                } else {
                    vo.setName(name);
                    vo.setCode(name);
                }
                if (StringUtils.isEmpty((CharSequence)nodeTypeName)) {
                    vo.setNodeType(null);
                    warnType = warnType + "[\u8282\u70b9\u6807\u8bc6\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    if ("\u975e\u5173\u952e\u8282\u70b9".equals(nodeTypeName)) {
                        vo.setNodeType(Integer.valueOf(0));
                    } else if ("\u5173\u952e\u8282\u70b9".equals(nodeTypeName)) {
                        vo.setNodeType(Integer.valueOf(1));
                    } else {
                        warnType = warnType + "[\u8282\u70b9\u6807\u8bc6\u4e0d\u5b58\u5728]";
                    }
                    vo.setNodeTypeName(nodeTypeName);
                }
                vo.setUnit(unit);
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setRowState("add");
                if (flag) {
                    vo.setWarnType(warnType);
                    errorList.add(vo);
                    continue;
                }
                codeMap.put(name, vo);
            }
            ArrayList successList = new ArrayList(codeMap.values());
            for (DocVO vo : successList) {
                vo.setTpid((String)tidMap.get(vo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(successList, Map.class));
            List<Map<String, Object>> ListCodeDate = this.creatCode(deailTreeData, null, null);
            List<Map<String, Object>> listDate = TreeUtil.treeToList(ListCodeDate);
            resp.put("successList", listDate);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)listDate.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public void insertBatch(List<DocEntity> list) {
        if (ListUtil.isNotEmpty(list)) {
            super.saveBatch(list);
        }
    }

    @Override
    public List<DocEntity> queryListByArchivesId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("nodeArchivesId", new Parameter("like", (Object)id));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        return super.queryList(param);
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), DocVO.class);
            list.forEach(vo -> {
                if (vo.getNodeType() == 0) {
                    vo.setWarnType("\u975e\u5173\u952e\u8282\u70b9");
                } else {
                    vo.setWarnType("\u5173\u952e\u8282\u70b9");
                }
            });
            Collections.sort(list, new DocComparatorVo());
            beans.put("records", list);
            ExcelExport.getInstance().export("node-doc-export.xlsx", beans, response);
        }
    }

    private String creatCode2(DocEntity entity, Long tenantid) {
        int nodeLevel;
        String structCode = entity.getStructCode();
        if (StringUtils.isNotBlank((CharSequence)structCode)) {
            String[] split = structCode.split("&&");
            structCode = split[split.length - 1];
        }
        int n = nodeLevel = entity.getNodeLevel() == null ? 1 : entity.getNodeLevel();
        if (nodeLevel != LevelEnum.\u4e00\u7ea7.getCode()) {
            ++nodeLevel;
        }
        Long oldId = entity.getId() == null ? null : Long.valueOf(Math.abs(entity.getId()));
        String getMaxCode = ((DocMapper)this.baseMapper).getMaxCode(oldId, nodeLevel, tenantid, 3);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, 3);
        if (nodeLevel != LevelEnum.\u4e00\u7ea7.getCode() && nextValue.length() <= 3) {
            return structCode + nextValue;
        }
        return nextValue;
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String structCode, String innerCode) {
        for (Map<String, Object> ypd : list) {
            if (StringUtils.isNotEmpty((CharSequence)structCode)) {
                ypd.put("structCode", structCode + "&&" + ypd.get("code"));
            } else {
                ypd.put("structCode", ypd.get("code"));
            }
            int length = ypd.get("structCode").toString().split("&&").length;
            ypd.put("nodeLevel", length);
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), ypd.get("structCode").toString(), ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }
}

