/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.progress.bean.RiskCorrectionDetailEntity;
import com.ejianc.business.progress.bean.RiskCorrectionDrawHistoryEntity;
import com.ejianc.business.progress.bean.RiskCorrectionEntity;
import com.ejianc.business.progress.bean.RiskCorrectionHistoryEntity;
import com.ejianc.business.progress.enums.HandleStatusEnum;
import com.ejianc.business.progress.enums.RiskStateEnum;
import com.ejianc.business.progress.mapper.RiskCorrectionMapper;
import com.ejianc.business.progress.service.IRiskCorrectionDetailService;
import com.ejianc.business.progress.service.IRiskCorrectionDrawHistoryService;
import com.ejianc.business.progress.service.IRiskCorrectionHistoryService;
import com.ejianc.business.progress.service.IRiskCorrectionService;
import com.ejianc.business.progress.service.IRiskMessageService;
import com.ejianc.business.progress.service.impl.RiskCorrectionBpmServiceImpl;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.business.progress.vo.RiskCorrectionDetailVO;
import com.ejianc.business.progress.vo.RiskCorrectionDrawHistoryVO;
import com.ejianc.business.progress.vo.RiskCorrectionHistoryVO;
import com.ejianc.business.progress.vo.RiskCorrectionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="riskCorrectionService")
public class RiskCorrectionServiceImpl
extends BaseServiceImpl<RiskCorrectionMapper, RiskCorrectionEntity>
implements IRiskCorrectionService {
    private static final String RISK_CODE = "RISK_ZJKJ_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRiskCorrectionHistoryService historyService;
    @Autowired
    private RiskCorrectionBpmServiceImpl bpmService;
    @Autowired
    private IRiskCorrectionDrawHistoryService drawHistoryService;
    @Autowired
    private IRiskMessageService messageService;
    @Autowired
    private IRiskCorrectionDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OrgUtil orgUtil;

    @Override
    public CommonResponse<RiskCorrectionVO> saveOrUpdate(RiskCorrectionVO saveorUpdateVO) {
        List list2;
        LambdaQueryWrapper lambda;
        String operateType = null;
        RiskCorrectionEntity entity = new RiskCorrectionEntity();
        if (saveorUpdateVO.getId() == null || saveorUpdateVO.getId() <= 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RiskCorrectionEntity::getYearBid, (Object)saveorUpdateVO.getYearBid());
            lambda.eq(BaseEntity::getDr, (Object)0);
            lambda.notIn(RiskCorrectionEntity::getBillState, new Object[]{1, 3});
            list2 = super.list((Wrapper)lambda);
            if (list2.size() > 0) {
                throw new BusinessException("\u8be5\u8282\u70b9\u5b58\u5728\u5176\u4ed6\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RISK_CODE, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            OrgVO orgVO = this.orgUtil.findById(saveorUpdateVO.getOrgId());
            saveorUpdateVO.setCorpId(orgVO.getId());
            saveorUpdateVO.setCorpCode(orgVO.getCode());
            saveorUpdateVO.setCorpName(orgVO.getName());
            saveorUpdateVO.setTopOrgId(orgVO.getId());
            saveorUpdateVO.setTopOrgName(orgVO.getName());
            entity = (RiskCorrectionEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RiskCorrectionEntity.class));
            operateType = "add";
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RiskCorrectionEntity::getYearBid, (Object)saveorUpdateVO.getYearBid());
            lambda.eq(BaseEntity::getDr, (Object)0);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            lambda.notIn(RiskCorrectionEntity::getBillState, new Object[]{1, 3});
            list2 = super.list((Wrapper)lambda);
            if (list2.size() > 0) {
                throw new BusinessException("\u8be5\u8282\u70b9\u5b58\u5728\u5176\u4ed6\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            RiskCorrectionEntity oldEntity = (RiskCorrectionEntity)((Object)this.selectById(saveorUpdateVO.getId()));
            String handleStatus = oldEntity.getHandleStatus();
            if (Objects.equals(HandleStatusEnum.\u5df2\u5b8c\u6210.getCode(), handleStatus)) {
                if (oldEntity.getFinishTime() == null) {
                    oldEntity.setFinishTime(new Date());
                }
            } else if (!Objects.equals(HandleStatusEnum.\u7ea0\u504f\u4e2d.getCode(), handleStatus)) {
                List<RiskCorrectionDetailEntity> oldDetailList = oldEntity.getDetailList();
                List detailList = saveorUpdateVO.getDetailList();
                if (CollectionUtil.isEmpty(oldDetailList) && CollectionUtil.isNotEmpty((Collection)detailList)) {
                    oldEntity.setHandleStatus(HandleStatusEnum.\u7ea0\u504f\u4e2d.getCode());
                }
            }
            oldEntity.setCorrectionType(saveorUpdateVO.getCorrectionType());
            oldEntity.setCorrectionDate(saveorUpdateVO.getCorrectionDate());
            oldEntity.setYearBid(saveorUpdateVO.getYearBid());
            oldEntity.setYearBname(saveorUpdateVO.getYearBname());
            oldEntity.setNodeLevel(saveorUpdateVO.getNodeLevel());
            oldEntity.setEmployeeId(saveorUpdateVO.getEmployeeId());
            oldEntity.setEmployeeName(saveorUpdateVO.getEmployeeName());
            oldEntity.setDiffValue(saveorUpdateVO.getDiffValue());
            oldEntity.setLagReasons(saveorUpdateVO.getLagReasons());
            oldEntity.setSupplement(saveorUpdateVO.getSupplement());
            oldEntity.setLagReasonId(saveorUpdateVO.getLagReasonId());
            if (Objects.equals(HandleStatusEnum.\u5df2\u5b8c\u6210.getCode(), saveorUpdateVO.getHandleStatus())) {
                oldEntity.setHandleStatus(HandleStatusEnum.\u5df2\u5b8c\u6210.getCode());
                oldEntity.setFinishUserId(saveorUpdateVO.getFinishUserId());
                oldEntity.setFinishUserName(saveorUpdateVO.getFinishUserName());
                oldEntity.setFinishTime(saveorUpdateVO.getFinishTime());
            }
            entity = (RiskCorrectionEntity)((Object)BeanMapper.map((Object)((Object)oldEntity), RiskCorrectionEntity.class));
            operateType = "edit";
        }
        super.saveOrUpdate((Object)entity);
        List detailList = saveorUpdateVO.getDetailList();
        ArrayList<RiskCorrectionDetailVO> newDetailList = new ArrayList<RiskCorrectionDetailVO>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (RiskCorrectionDetailVO vo : detailList) {
            if (Objects.equals("del", vo.getRowState())) {
                deleteIds.add(vo.getId());
            }
            if (Objects.equals("add", vo.getRowState())) {
                vo.setId(null);
                vo.setRiskId(entity.getId());
                vo.setCreateUserId(InvocationInfoProxy.getUserid());
                newDetailList.add(vo);
            }
            if (!Objects.equals("edit", vo.getRowState())) continue;
            newDetailList.add(vo);
        }
        List minList = newDetailList.stream().filter(list -> !list.getHandleStatus().equals("2")).sorted(Comparator.comparing(RiskCorrectionDetailVO::getFinishTime)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(minList)) {
            RiskCorrectionDetailVO detailVO = (RiskCorrectionDetailVO)minList.get(0);
            entity.setMinTime(detailVO.getFinishTime());
        }
        if (CollectionUtil.isNotEmpty(newDetailList)) {
            this.detailService.saveOrUpdateBatch(BeanMapper.mapList(newDetailList, RiskCorrectionDetailEntity.class), newDetailList.size(), false);
        }
        if (CollectionUtil.isNotEmpty(deleteIds)) {
            this.detailService.removeByIds(deleteIds, false);
        }
        RiskCorrectionHistoryEntity historyEntity = new RiskCorrectionHistoryEntity();
        historyEntity.setRiskId(entity.getId());
        historyEntity.setUserId(InvocationInfoProxy.getUserid());
        historyEntity.setUserName(this.sessionManager.getUserContext().getUserName());
        if (operateType.equals("add")) {
            historyEntity.setRiskState(RiskStateEnum.CREATE.getCode());
        }
        if (operateType.equals("edit") && (CollectionUtil.isNotEmpty(newDetailList) || CollectionUtil.isNotEmpty(deleteIds))) {
            historyEntity.setRiskState(RiskStateEnum.SAVE.getCode());
        }
        if (!Objects.equals(null, historyEntity.getRiskState())) {
            this.historyService.saveOrUpdate((Object)historyEntity);
        }
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        this.saveOrUpdate((Object)entity);
        RiskCorrectionVO vo = (RiskCorrectionVO)BeanMapper.map((Object)((Object)entity), RiskCorrectionVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public RiskCorrectionVO queryDetail(Long id) {
        RiskCorrectionVO vo;
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.selectById(id));
        List<RiskCorrectionDetailEntity> detailList = entity.getDetailList();
        if (ListUtil.isNotEmpty(detailList)) {
            int size = detailList.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                RiskCorrectionDetailEntity detailEntity = detailList.get(i);
                detailEntity.setRowState("edit");
                stringBuffer.append(i + 1).append("\u3001").append(detailEntity.getRiskSetp()).append("\uff1b");
            }
            entity.setCorrectionMeasures(stringBuffer.toString());
        }
        if (!Objects.equals((vo = (RiskCorrectionVO)BeanMapper.map((Object)((Object)entity), RiskCorrectionVO.class)).getStartTime(), null)) {
            if (vo.getHandleStatus().equals(HandleStatusEnum.\u5df2\u5b8c\u6210.getCode())) {
                vo.setTake(Integer.valueOf(DateUtil.daysBetween((Date)vo.getStartTime(), (Date)vo.getFinishTime())));
            } else {
                vo.setTake(Integer.valueOf(DateUtil.daysBetween((Date)vo.getStartTime(), (Date)new Date())));
            }
        }
        List<RiskCorrectionHistoryVO> historyList = this.historyService.queryList(id);
        vo.setHistoryList(historyList);
        return vo;
    }

    @Override
    public Map<Long, RiskCorrectionVO> getRisk(Long yearId) {
        List<RiskCorrectionVO> list = ((RiskCorrectionMapper)this.baseMapper).getRisk(yearId);
        HashMap<Long, RiskCorrectionVO> map = new HashMap<Long, RiskCorrectionVO>();
        for (RiskCorrectionVO vo : list) {
            if (map.containsKey(vo.getYearBid())) {
                RiskCorrectionVO oldvo = (RiskCorrectionVO)map.get(vo.getYearBid());
                if (vo.getCorrectionDate().getTime() <= oldvo.getCorrectionDate().getTime()) continue;
                map.put(vo.getYearBid(), vo);
                continue;
            }
            map.put(vo.getYearBid(), vo);
        }
        return map;
    }

    @Override
    public Map<Long, RiskCorrectionVO> getRiskByYearBid(List<Long> yearBidList) {
        HashMap<Long, RiskCorrectionVO> map = new HashMap<Long, RiskCorrectionVO>();
        if (yearBidList.size() > 0) {
            List<RiskCorrectionVO> list = ((RiskCorrectionMapper)this.baseMapper).getRiskByYearBid(yearBidList);
            for (RiskCorrectionVO vo : list) {
                if (map.containsKey(vo.getYearBid())) {
                    RiskCorrectionVO oldvo = (RiskCorrectionVO)map.get(vo.getYearBid());
                    if (vo.getCorrectionDate().getTime() <= oldvo.getCorrectionDate().getTime()) continue;
                    map.put(vo.getYearBid(), vo);
                    continue;
                }
                map.put(vo.getYearBid(), vo);
            }
        }
        return map;
    }

    @Override
    public CommonResponse<JSONObject> queryRiskList(QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planYear");
        fuzzyFields.add("yearBname");
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse response = this.orgApi.getOneById(orgId);
        OrgVO orgVO = (OrgVO)response.getData();
        Integer orgType = orgVO.getOrgType();
        if (orgType.equals(1)) {
            param.getParams().put("correctionType", new Parameter("eq", (Object)"2"));
        } else if (orgType.equals(2)) {
            param.getParams().put("topOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            param.getParams().put("correctionType", new Parameter("eq", (Object)"1"));
        } else if (orgType.equals(3) || orgType.equals(5)) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            param.getParams().put("correctionType", new Parameter("eq", (Object)"0"));
        }
        IPage page = this.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RiskCorrectionVO.class));
        List records = pageData.getRecords();
        for (RiskCorrectionVO vo : records) {
            if (vo.getMinTime() == null) continue;
            vo.setSurplusDay(DateUtil2.getSubDay2(new Date(), vo.getMinTime()));
        }
        resp.put("pages", (Object)pageData.getPages());
        resp.put("size", (Object)pageData.getSize());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("records", (Object)records);
        return CommonResponse.success((Object)resp);
    }

    @Override
    public CommonResponse<String> drawTask(RiskCorrectionHistoryVO historyVO) {
        historyVO.setRiskState(RiskStateEnum.DRAW.getCode());
        RiskCorrectionHistoryEntity historyEntity = (RiskCorrectionHistoryEntity)((Object)BeanMapper.map((Object)historyVO, RiskCorrectionHistoryEntity.class));
        this.historyService.saveOrUpdate((Object)historyEntity, false);
        CommonResponse response = this.orgApi.getOneById(InvocationInfoProxy.getOrgId());
        OrgVO orgVO = (OrgVO)response.getData();
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.getById(historyVO.getRiskId()));
        entity.setCorrectionType(historyVO.getCorrectionType());
        entity.setLagReasons(historyVO.getLagReasons());
        entity.setDrawExplain(historyVO.getOperateDescribe());
        entity.setDrawUserId(historyVO.getUserId());
        entity.setDrawUserName(historyVO.getUserName());
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        entity.setDrawOrgId(orgVO.getId());
        entity.setDrawOrgName(orgVO.getName());
        this.saveOrUpdate((Object)entity, false);
        RiskCorrectionDrawHistoryEntity drawHistoryEntity = (RiskCorrectionDrawHistoryEntity)((Object)BeanMapper.map((Object)((Object)entity), RiskCorrectionDrawHistoryEntity.class));
        drawHistoryEntity.setId(null);
        drawHistoryEntity.setRiskId(entity.getId());
        this.drawHistoryService.saveOrUpdate((Object)drawHistoryEntity);
        OrgVO orgVO1 = null;
        orgVO1 = this.orgUtil.findById(entity.getDrawOrgId());
        if (Objects.equals(orgVO1.getId(), null)) {
            this.messageService.riskByPushSet(entity, InvocationInfoProxy.getOrgId());
        } else {
            this.messageService.riskByPushSet(entity, orgVO1.getId());
        }
        return CommonResponse.success((String)"\u63d0\u8bf7\u6210\u529f");
    }

    @Override
    public CommonResponse<String> returnTask(RiskCorrectionHistoryVO historyVO) {
        historyVO.setRiskState(RiskStateEnum.RETURN.getCode());
        RiskCorrectionHistoryEntity historyEntity = (RiskCorrectionHistoryEntity)((Object)BeanMapper.map((Object)historyVO, RiskCorrectionHistoryEntity.class));
        this.historyService.saveOrUpdate((Object)historyEntity, false);
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.getById(historyVO.getRiskId()));
        entity.setCorrectionType(historyVO.getCorrectionType());
        entity.setLagReasons(historyVO.getLagReasons());
        entity.setReturnExplain(historyVO.getOperateDescribe());
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u9000\u56de\u6210\u529f");
    }

    @Override
    public CommonResponse<String> acceptTask(List<RiskCorrectionHistoryVO> historyVOs) {
        RiskCorrectionHistoryVO historyVO = historyVOs.get(0);
        historyVO.setRiskState(RiskStateEnum.ACCEPT.getCode());
        RiskCorrectionHistoryEntity historyEntity = (RiskCorrectionHistoryEntity)((Object)BeanMapper.map((Object)historyVO, RiskCorrectionHistoryEntity.class));
        this.historyService.saveOrUpdate((Object)historyEntity, false);
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.getById(historyVO.getRiskId()));
        entity.setAcceptUserId(historyVO.getUserId());
        entity.setAcceptUserName(historyVO.getUserName());
        entity.setMemo(historyVO.getOperateDescribe());
        entity.setHandleStatus(HandleStatusEnum.\u5f85\u7ea0\u504f.getCode());
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        entity.setAcceptTime(historyEntity.getCreateTime());
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u53d7\u7406\u6210\u529f");
    }

    @Override
    public CommonResponse<String> progressTask(RiskCorrectionVO vo) {
        RiskCorrectionHistoryEntity historyEntity = new RiskCorrectionHistoryEntity();
        historyEntity.setRiskId(vo.getId());
        historyEntity.setUserId(vo.getFinishUserId());
        historyEntity.setUserName(vo.getFinishUserName());
        if (Objects.equals(HandleStatusEnum.\u5df2\u5b8c\u6210.getCode(), vo.getHandleStatus())) {
            List detailList = vo.getDetailList();
            for (RiskCorrectionDetailVO detailVO : detailList) {
                detailVO.setHandleStatus("2");
            }
            historyEntity.setRiskState(RiskStateEnum.FINISH.getCode());
            vo.setFinishTime(new Date());
            this.messageService.riskFinish(vo.getId());
        } else {
            historyEntity.setRiskState(RiskStateEnum.RUNNING.getCode());
        }
        this.saveOrUpdate(vo);
        this.historyService.saveOrUpdate((Object)historyEntity, false);
        return CommonResponse.success((String)"\u4fee\u6539\u7ea0\u504f\u8fdb\u5ea6\u6210\u529f");
    }

    @Override
    public CommonResponse<JSONObject> queryDrawRisk(QueryParam param) {
        JSONObject resp = new JSONObject();
        long pageIndex = param.getPageIndex();
        long pageSize = param.getPageSize();
        param.setPageSize(-1);
        param.getParams().put("drawOrgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        param.getParams().remove("handleStatus");
        List list = this.drawHistoryService.queryList(param);
        Map<Long, List<RiskCorrectionDrawHistoryEntity>> map = list.stream().collect(Collectors.groupingBy(RiskCorrectionDrawHistoryEntity::getRiskId));
        ArrayList resultList = new ArrayList();
        for (Map.Entry<Long, List<RiskCorrectionDrawHistoryEntity>> entry : map.entrySet()) {
            List<RiskCorrectionDrawHistoryEntity> entityList = entry.getValue();
            List maxList = entityList.stream().sorted(Comparator.comparing(BaseEntity::getCreateTime)).collect(Collectors.toList());
            resultList.add(maxList.get(0));
        }
        List records = resultList.stream().skip((pageIndex - 1L) * pageSize).limit(pageSize).collect(Collectors.toList());
        long total = resultList.size();
        long pages = total / pageSize;
        if (total % pageSize != 0L) {
            ++pages;
        }
        resp.put("pages", (Object)pages);
        resp.put("size", (Object)pageSize);
        resp.put("current", (Object)pageIndex);
        resp.put("total", (Object)total);
        resp.put("records", (Object)BeanMapper.mapList(records, RiskCorrectionDrawHistoryVO.class));
        return CommonResponse.success((Object)resp);
    }

    @Override
    public CommonResponse<JSONObject> dataCount(Boolean dataCountFlag) {
        JSONObject resp = new JSONObject();
        JSONObject dataCount = new JSONObject();
        if (dataCountFlag.booleanValue()) {
            QueryParam param = new QueryParam();
            param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse response = this.orgApi.getOneById(orgId);
            OrgVO orgVO = (OrgVO)response.getData();
            Integer orgType = orgVO.getOrgType();
            if (orgType.equals(1)) {
                param.getParams().put("correctionType", new Parameter("eq", (Object)"2"));
            } else if (orgType.equals(2)) {
                param.getParams().put("topOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                param.getParams().put("correctionType", new Parameter("eq", (Object)"1"));
            } else if (orgType.equals(3) || orgType.equals(5)) {
                param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                param.getParams().put("correctionType", new Parameter("eq", (Object)"0"));
            }
            QueryWrapper taskCountQuery = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            taskCountQuery.select(new String[]{"sum(if(handle_status = '" + HandleStatusEnum.\u5f85\u53d7\u7406.getCode() + "', 1, 0)) as pendAcceptNumber, sum(if(handle_status = '" + HandleStatusEnum.\u5f85\u7ea0\u504f.getCode() + "'|| handle_status ='" + HandleStatusEnum.\u7ea0\u504f\u4e2d.getCode() + "', 1, 0)) as acceptNumber,sum(if(handle_status = '" + HandleStatusEnum.\u5df2\u5b8c\u6210.getCode() + "', 1, 0)) as finishNum"});
            List countResult = this.listMaps((Wrapper)taskCountQuery);
            if (CollectionUtils.isEmpty((Collection)countResult) || null == countResult.get(0)) {
                dataCount.put("pendAcceptNumber", (Object)0);
                dataCount.put("acceptNumber", (Object)0);
                dataCount.put("finishNum", (Object)0);
            } else {
                dataCount.put("pendAcceptNumber", ((Map)countResult.get(0)).get("pendAcceptNumber"));
                dataCount.put("acceptNumber", ((Map)countResult.get(0)).get("acceptNumber"));
                dataCount.put("finishNum", ((Map)countResult.get(0)).get("finishNum"));
            }
            CommonResponse<JSONObject> drawResponse = this.queryDrawRisk(new QueryParam());
            JSONObject data = (JSONObject)drawResponse.getData();
            long drawNumber = Long.parseLong(data.get((Object)"total").toString());
            dataCount.put("drawNumber", (Object)drawNumber);
            resp.put("dataCount", (Object)dataCount);
        } else {
            resp.put("dataCount", (Object)0);
        }
        return CommonResponse.success((Object)resp);
    }

    @Override
    public CommonResponse<JSONObject> queryRiskReport(QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planYear");
        fuzzyFields.add("yearBname");
        if (param.getParams().containsKey("handleStatus") && StringUtils.isEmpty((CharSequence)String.valueOf(((Parameter)param.getParams().get("handleStatus")).getValue()))) {
            param.getParams().remove("handleStatus");
        }
        if (param.getParams().containsKey("correctionType") && StringUtils.isEmpty((CharSequence)String.valueOf(((Parameter)param.getParams().get("correctionType")).getValue()))) {
            param.getParams().remove("correctionType");
        }
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RiskCorrectionVO.class));
        List records = pageData.getRecords();
        for (RiskCorrectionVO vo : records) {
            if (vo.getMinTime() != null) {
                vo.setSurplusDay(Integer.valueOf(DateUtil.daysBetween((Date)vo.getMinTime(), (Date)new Date())));
            }
            if (Objects.equals(vo.getStartTime(), null)) continue;
            if (vo.getHandleStatus().equals(HandleStatusEnum.\u5df2\u5b8c\u6210.getCode())) {
                vo.setTake(Integer.valueOf(DateUtil.daysBetween((Date)vo.getStartTime(), (Date)vo.getFinishTime())));
                continue;
            }
            vo.setTake(Integer.valueOf(DateUtil.daysBetween((Date)vo.getStartTime(), (Date)new Date())));
        }
        resp.put("pages", (Object)pageData.getPages());
        resp.put("size", (Object)pageData.getSize());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("records", (Object)records);
        return CommonResponse.success((Object)resp);
    }

    @Override
    public Map<Long, RiskCorrectionEntity> queryRiskByYearId(Long yearId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(RiskCorrectionEntity::getYearId, (Object)yearId)).eq(BaseEntity::getDr, (Object)0)).orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        Map<Long, RiskCorrectionEntity> map = list.stream().collect(Collectors.toMap(RiskCorrectionEntity::getYearBid, Function.identity(), (x1, x2) -> x1));
        return map;
    }

    @Override
    public void handleTopData() {
        List list = this.list();
        if (ListUtil.isNotEmpty((List)list)) {
            CommonResponse response = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
            if (!response.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u79df\u6237\u9876\u7ea7\u7ec4\u7ec7\u5931\u8d25\uff01");
            }
            ArrayList data = new ArrayList();
            for (OrgVO vo : (List)response.getData()) {
                CommonResponse parentsByOrgId = this.orgApi.findChildrenByParentId(vo.getId());
                if (!parentsByOrgId.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u67e5\u8be2\u975e\u9879\u76ee\u90e8\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                data.addAll((Collection)parentsByOrgId.getData());
            }
            Map<Long, OrgVO> map = data.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            for (RiskCorrectionEntity entity : list) {
                OrgVO orgVO;
                if (Objects.equals(null, entity.getOrgId()) || Objects.equals(null, orgVO = (OrgVO)map.get(entity.getOrgId()))) continue;
                OrgVO parentOrgVo = this.getCorp(map, orgVO.getParentId());
                entity.setTopOrgId(parentOrgVo.getId());
                entity.setTopOrgName(parentOrgVo.getName());
            }
            this.saveOrUpdateBatch(list);
        }
    }

    private OrgVO getCorp(Map<Long, OrgVO> orgMap, Long parentId) {
        OrgVO vo = new OrgVO();
        if (parentId == null) {
            return vo;
        }
        vo = orgMap.get(parentId);
        if (vo.getOrgType() == 2) {
            return vo;
        }
        return this.getCorp(orgMap, vo.getParentId());
    }
}

