package com.ejianc.business.fill.controller;

import com.ejianc.business.fill.service.IContractLightService;
import com.ejianc.business.fill.vo.ContractLightVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 合同节点亮灯关联实体
 *
 * @author generator
 */
@Controller
@RequestMapping("contractLight")
public class ContractLightController implements Serializable {

    @Autowired
    private IContractLightService service;

    @RequestMapping(value = "getContractLevelInfo",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractLightVO> getContractLevelInfo(@RequestParam("bid") Long bid){
        ContractLightVO contractLevelInfo = service.getContractLevelInfo(bid);
        return CommonResponse.success("查询成功",contractLevelInfo);
    }

}
