package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.TotalPlanDetailMapper;
import com.ejianc.business.plan.bean.TotalPlanDetailEntity;
import com.ejianc.business.plan.service.ITotalPlanDetailService;

import java.util.List;

/**
 * 总计划详情
 * 
 * @author generator
 * 
 */
@Service("totalPlanDetailService")
public class TotalPlanDetailServiceImpl extends BaseServiceImpl<TotalPlanDetailMapper, TotalPlanDetailEntity> implements ITotalPlanDetailService{

    @Override
    public void deleteDetailByProgressIds(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<TotalPlanDetailEntity>().in("progress_id", ids));
    }

    @Override
    public void deleteDetailByIds(List<Long> ids) {
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public void deleteByProgressId(Long id) {
        baseMapper.delete(new QueryWrapper<TotalPlanDetailEntity>().eq("progress_id", id));
    }
}
