package com.ejianc.business.progress.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.bean.RiskCorrectionEntity;
import com.ejianc.business.progress.enums.HandleStatusEnum;
import com.ejianc.business.progress.service.IRiskCorrectionService;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.business.progress.vo.RiskCorrectionHistoryVO;
import com.ejianc.business.progress.vo.RiskCorrectionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 风险纠偏
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("riskCorrection")
public class RiskCorrectionController implements Serializable {
	private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi orgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IRiskCorrectionService service;

    @Autowired
    private IExecPlanService eservice;

    @Autowired
    private IExecPlanDetailService detailService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RiskCorrectionVO> saveOrUpdate(@RequestBody RiskCorrectionVO saveorUpdateVO) {
        CommonResponse<RiskCorrectionVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RiskCorrectionVO> queryDetail(Long id) {
        return  CommonResponse.success("查询详情成功", service.queryDetail(id));
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RiskCorrectionVO> vos) {
        service.removeByIds(vos.stream().map(RiskCorrectionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RiskCorrectionVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectControlLevel");
        fuzzyFields.add("yearBname");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<RiskCorrectionEntity> page = service.queryPage(param,false);
        IPage<RiskCorrectionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<RiskCorrectionVO> riskCorrectionVOS = BeanMapper.mapList(page.getRecords(), RiskCorrectionVO.class);
        riskCorrectionVOS.forEach(vo->{
            if (!Objects.equals(vo.getStartTime(), null)) {
                if (vo.getHandleStatus().equals(HandleStatusEnum.已完成.getCode())) {
                    vo.setTake(DateUtil.daysBetween(vo.getStartTime(),vo.getFinishTime()));
                }else {
                    vo.setTake(DateUtil.daysBetween(vo.getStartTime(),new Date()));
                }
            }
        });
        pageData.setRecords(riskCorrectionVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);

    }
    @RequestMapping(value = "/queryListRisk", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RiskCorrectionVO>> queryListRisk(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planYear");
        fuzzyFields.add("yearBname");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<Integer> billState = new ArrayList<>();
        billState.add(1);
        billState.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billState));
        param.getParams().put("handleStatus", new Parameter(QueryParam.NE, "3"));
        param.getOrderMap().put("correctionDate", "desc");
        IPage<RiskCorrectionEntity> page = service.queryPage(param,false);
        IPage<RiskCorrectionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<RiskCorrectionVO> riskCorrectionVOS = BeanMapper.mapList(page.getRecords(), RiskCorrectionVO.class);
        List<RiskCorrectionVO> records = new ArrayList<>();
        List<Long> bidList = new ArrayList<>();
        for (RiskCorrectionVO vo : riskCorrectionVOS) {
            if(!bidList.contains(vo.getYearBid())){
                bidList.add(vo.getYearBid());
                if (vo.getMinTime() != null) {
                    // 纠偏剩余时间/天
//                    vo.setSurplusDay(DateUtil2.getSubDay2(new Date(), vo.getMinTime()));
                    vo.setSurplusDay(DateUtil.daysBetween(vo.getMinTime(), new Date()));
                }
                records.add(vo);
            }
        }
        pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 纠偏待办列表查询
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryRiskList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryRiskList(@RequestBody QueryParam param) {
        return service.queryRiskList(param);
    }

    /**
     * 提请操作
     * @param historyVO
     * @return
     */
    @RequestMapping(value = "/drawTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> drawTask(@RequestBody RiskCorrectionHistoryVO historyVO) {
        return service.drawTask(historyVO);
    }

    /**
     * 退回操作
     * @param historyVO
     * @return
     */
    @RequestMapping(value = "/returnTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> returnTask(@RequestBody RiskCorrectionHistoryVO historyVO) {
        return service.returnTask(historyVO);
    }


    /**
     * 受理操作
     * @param historyVOs
     * @return
     */
    @RequestMapping(value = "/acceptTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> acceptTask(@RequestBody List<RiskCorrectionHistoryVO> historyVOs) {
        return service.acceptTask(historyVOs);
    }

    /**
     * 纠偏进度操作
     * @param vo
     * @return
     */
    @RequestMapping(value = "/progressTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> progressTask(@RequestBody RiskCorrectionVO vo) {
        return service.progressTask(vo);
    }

    /**
     * 纠偏进度操作
     * @param  param
     * @return
     */
    @RequestMapping(value = "/queryDrawRisk", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryDrawRisk(@RequestBody QueryParam param) {
        return service.queryDrawRisk(param);
    }

    /**
     * 查询数量
     * @param  dataCountFlag
     * @return
     */
    @RequestMapping(value = "/dataCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> dataCount(Boolean dataCountFlag) {
        return service.dataCount(dataCountFlag);
    }

    /**
     * 纠偏待办列表查询
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryRiskReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryRiskReport(@RequestBody QueryParam param) {
        return service.queryRiskReport(param);
    }

    /**
     * 修改风险纠偏二级单位相关字段数据(修复bug用，可删除)
     * @return
     */
    @GetMapping(value = "/handleTopData")
    @ResponseBody
    public CommonResponse<Boolean> handleTopData() {
        service.handleTopData();
        return CommonResponse.success("处理成功！");
    }

    /**
     * @选择执行计划节点参照
     * @param id 执行计划主键
     * @param finishState 只查看未完成节点
     * @param lightType 查看是否亮灯
     * @return ExecPlanVO
     */
    @RequestMapping(value = "/referExecPlanDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecPlanDetail(@RequestParam(value = "id") Long id
            , @RequestParam(value = "finishState", required = false) Integer finishState
            , @RequestParam(value = "lightType", required = false) String lightType) {
        ExecPlanEntity entity = eservice.selectById(id);
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", id);
        ew.orderByAsc("tid");
        if (finishState!=null){
            ew.in("finish_state", 0, 2);
            ew.isNotNull("node_level");
        }
        if(StringUtils.isNotEmpty(lightType)){
            ew.in("light_type", Arrays.asList(lightType.split(",")));
        }
        List<ExecPlanDetailEntity> detailList = detailService.list(ew);
        ExecPlanVO vo = BeanMapper.map(entity, ExecPlanVO.class);
        if(CollectionUtils.isNotEmpty(detailList)) {
            List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
            for(ExecPlanDetailEntity detail : detailList) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }
}
