/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bim.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.mapper.BimMapper;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bimService")
public class BimServiceImpl
extends BaseServiceImpl<BimMapper, BimEntity>
implements IBimService {
    private static final String BILL_CODE = "ZJKJ_BIM_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IBimDetailService detailService;
    @Autowired
    private IExecPlanService execService;
    @Autowired
    private IExecPlanDetailService execDetailService;

    @Override
    public BimVO saveOrUpdate(BimVO saveOrUpdateVO) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(BaseEntity::getDr, (Object)0);
        ew.eq(BimEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        ew.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        List list = super.list((Wrapper)ew);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728BIM\u6a21\u578b");
        }
        BimEntity entity = (BimEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BimEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String date = sdf.format(new Date());
            entity.setBillCode("MX" + date);
        } else {
            List detailIds = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && x.getId() != null).map(BaseEntity::getId).collect(Collectors.toList());
            BimEntity data = (BimEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
            List delPaths = data.getDetailList().stream().filter(x -> !detailIds.contains(x.getId())).map(BimDetailEntity::getPath).collect(Collectors.toList());
            for (String path : delPaths) {
                TokenHelper.delFile(path);
            }
        }
        OrgVO orgVO = this.orgUtil.findById(entity.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
        if (entity.getState() == null) {
            entity.setState(0);
        }
        super.saveOrUpdate((Object)entity, false);
        return (BimVO)BeanMapper.map((Object)((Object)entity), BimVO.class);
    }

    @Override
    public BimVO syncDetail(Long id) {
        BimEntity entity = (BimEntity)((Object)super.selectById((Serializable)id));
        List<BimDetailEntity> detailList = entity.getDetailList();
        ArrayList<BimDetailEntity> saveList = new ArrayList<BimDetailEntity>();
        for (BimDetailEntity detail : detailList) {
            JSONObject fileStatus;
            if (detail.getStatus() == 1 || (fileStatus = TokenHelper.getFileStatus(detail.getPath())) == null || !"Ready".equals(fileStatus.getString("status"))) continue;
            detail.setStatus(1);
            saveList.add(detail);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.detailService.updateBatchById(saveList);
        }
        BimVO vo = (BimVO)BeanMapper.map((Object)((Object)entity), BimVO.class);
        return vo;
    }

    @Override
    public Boolean syncState(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        BimEntity bim = super.queryList(queryParam).stream().findAny().orElse(null);
        ExecPlanEntity exec = this.execService.queryList(queryParam).stream().findAny().orElse(null);
        if (bim == null || exec == null) {
            return true;
        }
        Boolean oldFlag = new Integer(1).equals(bim.getState());
        List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"bim_id", (Object)bim.getId()));
        List execDetailList = this.execDetailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)exec.getId()));
        List bimDetailIds = execDetailList.stream().map(x -> x.getBimDetailIds()).filter(x -> StringUtils.isNotEmpty((CharSequence)x)).flatMap(x -> Stream.of(x.split(","))).collect(Collectors.toList());
        ArrayList<BimDetailEntity> saveList = new ArrayList<BimDetailEntity>();
        boolean flag = false;
        for (BimDetailEntity detail : detailList) {
            if (bimDetailIds.contains(String.valueOf(detail.getId()))) {
                if (!new Integer(1).equals(detail.getState())) {
                    detail.setState(1);
                    saveList.add(detail);
                }
            } else if (new Integer(1).equals(detail.getState())) {
                detail.setState(0);
                saveList.add(detail);
            }
            if (!new Integer(1).equals(detail.getState())) continue;
            flag = true;
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.detailService.updateBatchById(saveList);
        }
        if (oldFlag != flag) {
            bim.setState(flag ? 1 : 0);
            super.saveOrUpdate((Object)bim);
        }
        return true;
    }
}

