/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.bean.ContractLightEntity;
import com.ejianc.business.fill.bean.MonthLightEntity;
import com.ejianc.business.fill.bean.ProjectLightEntity;
import com.ejianc.business.fill.cons.FillConstant;
import com.ejianc.business.fill.consumer.TransferVO;
import com.ejianc.business.fill.emum.LightRuleLevelEnum;
import com.ejianc.business.fill.service.IContractLightService;
import com.ejianc.business.fill.service.IDelnyTrendService;
import com.ejianc.business.fill.service.IMonthLightService;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.fill.service.IProjectTrendService;
import com.ejianc.business.fill.service.IWarnService;
import com.ejianc.business.fill.util.PageUtil;
import com.ejianc.business.fill.util.WarnFeignUtil;
import com.ejianc.business.fill.vo.LevelReceiveVO;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.business.market.api.IZjkjProjectApi;
import com.ejianc.business.market.vo.ProjectVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.mapper.ExecPlanMapper;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.utils.SeparatorUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.bean.PushSetEntity;
import com.ejianc.business.progress.bean.PushSetReceiveEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.service.ILightRuleService;
import com.ejianc.business.progress.service.IPushSetReceiveService;
import com.ejianc.business.progress.service.IPushSetService;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.DetailListUtil;
import com.ejianc.business.progress.utils.WarnDateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="warnService")
public class WarnServiceImpl
extends BaseServiceImpl<ExecPlanMapper, ExecPlanEntity>
implements IWarnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IExecPlanDetailService detailService;
    @Autowired
    private IMonthPlanDetailService monthPlanDeteilService;
    @Autowired
    private IDelnyTrendService delnyTrendService;
    @Autowired
    private IProjectTrendService projectTrendService;
    @Autowired
    private IProjectLightService projectLightService;
    @Autowired
    private IMonthLightService monthLightService;
    @Autowired
    private IContractLightService contractLightService;
    @Autowired
    private IPushSetService pushSetService;
    @Autowired
    private IPushSetReceiveService receiveService;
    @Autowired
    private ILightRuleService lightRuleService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private WarnFeignUtil feignUtil;
    @Autowired
    private DetailListUtil detailListUtil;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IZjkjProjectApi projectApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public CommonResponse light(HttpServletRequest request) {
        List<ExecPlanEntity> execList = this.getExecPlanList();
        List<MonthPlanEntity> monthList = this.getMonthPlanList();
        if (CollectionUtils.isEmpty(execList) && CollectionUtils.isEmpty(monthList)) {
            this.logger.info("\u6ca1\u6709\u8ba1\u5212\u53ef\u6267\u884c\uff01");
            return CommonResponse.success((String)"\u6ca1\u6709\u8ba1\u5212\u53ef\u6267\u884c\uff01");
        }
        List<Long> projectIds = execList.stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toList());
        TransferVO transferVO = this.feignUtil.getTransferVO(projectIds);
        transferVO.setExecList(execList);
        transferVO.setMonthList(monthList);
        this.process(transferVO);
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    private List<ExecPlanEntity> getExecPlanList() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        List list = this.execPlanService.queryList(queryParam);
        for (ExecPlanEntity entity : list) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"progress_id", (Object)entity.getId());
            ew.orderByAsc((Object)"tid");
            List detailList = this.detailService.list((Wrapper)ew);
            entity.setAllList(detailList);
        }
        return list;
    }

    private List<MonthPlanEntity> getMonthPlanList() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        List list = this.monthPlanService.queryList(queryParam);
        for (MonthPlanEntity entity : list) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"progress_id", (Object)entity.getId());
            ew.orderByAsc((Object)"tid");
            List detailList = this.monthPlanDeteilService.list((Wrapper)ew);
            entity.setAllList(detailList);
        }
        return list;
    }

    @Override
    public CommonResponse process(TransferVO transferVO) {
        List<ExecPlanEntity> execList = transferVO.getExecList();
        List<MonthPlanEntity> monthList = transferVO.getMonthList();
        this.logger.info("--> \u540c\u6b65\u5e74\u8ba1\u5212\u4eae\u706f\u72b6\u6001\u5f00\u59cb");
        Map<Long, LightRuleEntity> projectLightRuleMap = this.getProjectLightRuleMap(transferVO.getProjectMap(), transferVO.getOrgMap());
        this.updateExecPlanDiffValue(execList, projectLightRuleMap);
        Map<Long, Integer> projectWarnMap = this.recordContractLight(execList, projectLightRuleMap);
        this.recordProjectLight(execList, projectLightRuleMap, projectWarnMap, transferVO.getProjectMap());
        if (CollectionUtils.isNotEmpty(monthList)) {
            this.recordMonthLight(execList, monthList, projectLightRuleMap);
        }
        this.delnyTrendService.execPlanDetailTrend(execList, projectLightRuleMap);
        this.projectTrendService.projectTrendTrend(execList, projectLightRuleMap);
        this.logger.info("--> \u540c\u6b65\u5e74\u8ba1\u5212\u4eae\u706f\u72b6\u6001\u7ed3\u675f");
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    public void updateExecPlanDiffValue(List<ExecPlanEntity> execPlanList, Map<Long, LightRuleEntity> projectLightRuleMap) {
        ArrayList<ExecPlanDetailEntity> updateData = new ArrayList<ExecPlanDetailEntity>();
        for (ExecPlanEntity execPlan : execPlanList) {
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, execPlan.getProjectId(), LightRuleLevelEnum.\u5408\u540c\u8282\u70b9\u9884\u8b66.getCode());
            List<ExecPlanDetailEntity> execPlanDetailList = execPlan.getAllList();
            for (ExecPlanDetailEntity execPlanDetail : execPlanDetailList) {
                Date predictFinish = execPlanDetail.getPredictFinish();
                predictFinish = !new Integer(1).equals(execPlanDetail.getFinishState()) ? (DateUtil.compareDay(new Date(), execPlanDetail.getPredictFinish()) > 0 ? new Date() : execPlanDetail.getPredictFinish()) : execPlanDetail.getActualFinish();
                Integer diffValueInt = DateUtil.getBetweenDays(predictFinish, execPlanDetail.getPlanFinish());
                BigDecimal diffValue = new BigDecimal(diffValueInt);
                execPlanDetail.setDiffValue(diffValue);
                execPlanDetail.setLightType(null);
                if (PlanConstant.LEVEL_CONTRACT == execPlanDetail.getNodeLevel()) {
                    Integer status = null;
                    if (null == execPlanDetail.getActualStart() && null == execPlanDetail.getActualFinish()) {
                        status = FillConstant.NOT_STAR;
                    }
                    if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getPredictFinish() && null == execPlanDetail.getActualFinish()) {
                        status = FillConstant.UNDERWAY;
                    }
                    if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getActualFinish()) {
                        status = FillConstant.FINISHED;
                    }
                    if (null != lightRuleLevel) {
                        Integer residueValue = DateUtil.getBetweenDays(execPlanDetail.getPredictFinish(), new Date());
                        BigDecimal finalValue = ComputeUtil.safeDiv(diffValue, new BigDecimal(residueValue));
                        Integer lightType = this.getLightType(lightRuleLevel, diffValue, finalValue, true, status);
                        execPlanDetail.setLightType(lightType);
                    }
                }
                updateData.add(execPlanDetail);
            }
        }
        if (updateData.size() > 0) {
            this.execPlanDetailService.saveOrUpdateBatch(updateData, updateData.size(), false);
        }
    }

    @Override
    public Integer getLightType(LightRuleLevelEntity lightRuleLevelEntity, BigDecimal diffValue, BigDecimal finalValue, Boolean isContractLevel, Integer state) {
        if (finalValue.toString().equals("0E-8")) {
            finalValue = BigDecimal.ZERO;
        }
        finalValue = ComputeUtil.safeMultiply(finalValue, new BigDecimal(100));
        Integer lightType = LightTypeEnum.\u7eff\u706f.getCode();
        if (null != lightRuleLevelEntity) {
            if (lightRuleLevelEntity.getBlueDiffSelect() == PlanConstant.INTEGER_YES && finalValue.compareTo(new BigDecimal(lightRuleLevelEntity.getBlueDiffMin())) > 0) {
                lightType = LightTypeEnum.\u84dd\u706f.getCode();
            }
            if (lightRuleLevelEntity.getBlueLightSelect() == PlanConstant.INTEGER_YES && new BigDecimal(lightRuleLevelEntity.getBlueSumMin()).compareTo(diffValue) <= 0 && diffValue.compareTo(new BigDecimal(lightRuleLevelEntity.getBlueLightMin())) < 0) {
                lightType = LightTypeEnum.\u84dd\u706f.getCode();
            }
            if (lightRuleLevelEntity.getYellowDiffSelect() == PlanConstant.INTEGER_YES && finalValue.compareTo(new BigDecimal(lightRuleLevelEntity.getYellowDiffMin())) > 0) {
                lightType = LightTypeEnum.\u9ec4\u706f.getCode();
            }
            if (lightRuleLevelEntity.getYellowLightSelect() == PlanConstant.INTEGER_YES && new BigDecimal(lightRuleLevelEntity.getYellowSumMin()).compareTo(diffValue) <= 0 && diffValue.compareTo(new BigDecimal(lightRuleLevelEntity.getYellowLightMin())) < 0) {
                lightType = LightTypeEnum.\u9ec4\u706f.getCode();
            }
            if (lightRuleLevelEntity.getRedDiffSelect() == PlanConstant.INTEGER_YES && finalValue.compareTo(new BigDecimal(lightRuleLevelEntity.getRedDiffMin())) > 0) {
                lightType = LightTypeEnum.\u7ea2\u706f.getCode();
            }
            if (lightRuleLevelEntity.getRedLightSelect() == PlanConstant.INTEGER_YES && new BigDecimal(lightRuleLevelEntity.getRedLightMin()).compareTo(diffValue) <= 0) {
                lightType = LightTypeEnum.\u7ea2\u706f.getCode();
            }
            if (isContractLevel.booleanValue() && FillConstant.FINISHED == state && lightRuleLevelEntity.getVioletDiffSelect() == PlanConstant.INTEGER_YES && diffValue.compareTo(new BigDecimal(lightRuleLevelEntity.getVioletDiffMin())) > 0) {
                lightType = LightTypeEnum.\u7d2b\u706f.getCode();
            }
        }
        return lightType;
    }

    @Override
    public LightRuleLevelEntity getLightRuleLevel(Map<Long, LightRuleEntity> projectLightRuleMap, Long projectId, Integer level) {
        LightRuleLevelEntity lightRuleLevel = null;
        if (!projectLightRuleMap.containsKey(projectId)) {
            return lightRuleLevel;
        }
        LightRuleEntity lightRuleEntity = projectLightRuleMap.get(projectId);
        if (null != lightRuleEntity) {
            List<LightRuleLevelEntity> detailList = lightRuleEntity.getDetailList();
            Map LevelMap = detailList.stream().collect(Collectors.toMap(LightRuleLevelEntity::getLevel, Function.identity()));
            lightRuleLevel = (LightRuleLevelEntity)((Object)LevelMap.get(level));
            if (LightRuleLevelEnum.\u5408\u540c\u8282\u70b9\u9884\u8b66.getCode() == level) {
                LightRuleLevelEntity violetRuleLevel = (LightRuleLevelEntity)((Object)LevelMap.get(LightRuleLevelEnum.\u5408\u540c\u8282\u70b9\u62a5\u8b66.getCode()));
                lightRuleLevel.setVioletDiffSelect(violetRuleLevel.getVioletDiffSelect());
                lightRuleLevel.setVioletDiffMin(violetRuleLevel.getVioletDiffMin());
            }
        }
        return lightRuleLevel;
    }

    public Map<Long, Integer> recordContractLight(List<ExecPlanEntity> execPlanList, Map<Long, LightRuleEntity> projectLightRuleMap) {
        HashMap<Long, Integer> projectWarnMap = new HashMap<Long, Integer>();
        ArrayList<ExecPlanDetailEntity> execPlanAllDetailList = new ArrayList<ExecPlanDetailEntity>();
        for (ExecPlanEntity execPlan : execPlanList) {
            execPlanAllDetailList.addAll(execPlan.getAllList());
        }
        List levelContractList = execPlanAllDetailList.stream().filter(e -> PlanConstant.LEVEL_CONTRACT == e.getNodeLevel()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(levelContractList)) {
            return projectWarnMap;
        }
        List levelContractIds = levelContractList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("execPlanBid", new Parameter("in", levelContractIds));
        List list = this.contractLightService.queryList(queryParam);
        Map map = list.stream().collect(Collectors.toMap(ContractLightEntity::getExecPlanBid, Function.identity()));
        ArrayList<ContractLightEntity> saveList = new ArrayList<ContractLightEntity>();
        for (ExecPlanEntity execPlan : execPlanList) {
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, execPlan.getProjectId(), LightRuleLevelEnum.\u5408\u540c\u8282\u70b9\u9884\u8b66.getCode());
            Integer sumWarn = 0;
            List execPlanDetailList = execPlan.getAllList().stream().filter(e -> PlanConstant.LEVEL_CONTRACT == e.getNodeLevel()).collect(Collectors.toList());
            for (ExecPlanDetailEntity execPlanDetail : execPlanDetailList) {
                if (PlanConstant.LEVEL_CONTRACT != execPlanDetail.getNodeLevel()) continue;
                ContractLightEntity lightEntity = new ContractLightEntity();
                if (map.containsKey(execPlanDetail.getId())) {
                    lightEntity = (ContractLightEntity)((Object)map.get(execPlanDetail.getId()));
                }
                lightEntity.setProjectId(execPlan.getProjectId());
                lightEntity.setProjectName(execPlan.getProjectName());
                lightEntity.setOrgId(execPlan.getOrgId());
                lightEntity.setOrgName(execPlan.getOrgName());
                lightEntity.setCorpId(execPlan.getCorpId());
                lightEntity.setCorpName(execPlan.getCorpName());
                lightEntity.setExecPlanId(execPlan.getId());
                lightEntity.setExecPlanCode(execPlan.getBillCode());
                lightEntity.setExecPlanBid(execPlanDetail.getId());
                lightEntity.setPlanName(execPlanDetail.getName());
                Integer status = null;
                if (null == execPlanDetail.getActualStart() && null == execPlanDetail.getActualFinish()) {
                    status = FillConstant.NOT_STAR;
                }
                if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getPredictFinish() && null == execPlanDetail.getActualFinish()) {
                    status = FillConstant.UNDERWAY;
                }
                if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getActualFinish()) {
                    status = FillConstant.FINISHED;
                }
                lightEntity.setStatus(status);
                Integer diffValueInt = DateUtil.getBetweenDays(execPlanDetail.getPredictFinish(), execPlanDetail.getPlanFinish());
                BigDecimal diffValue = new BigDecimal(diffValueInt);
                if (null != lightRuleLevel) {
                    Integer residueValue = DateUtil.getBetweenDays(execPlanDetail.getPredictFinish(), new Date());
                    BigDecimal finalValue = ComputeUtil.safeDiv(diffValue, new BigDecimal(residueValue));
                    Integer lightType = this.getLightType(lightRuleLevel, diffValue, finalValue, true, status);
                    if (LightTypeEnum.\u7d2b\u706f.getCode() == lightType) {
                        lightEntity.setWarnState(PlanConstant.INTEGER_YES);
                        Integer n = sumWarn;
                        Integer n2 = sumWarn = Integer.valueOf(sumWarn + 1);
                    }
                    lightEntity.setLightType(lightType);
                }
                lightEntity.setDiffValue(diffValue);
                lightEntity.setUpdateTime(lightEntity.getUpdateTime() != null ? lightEntity.getUpdateTime() : new Date());
                lightEntity.setTenantId(lightEntity.getTenantId() != null ? lightEntity.getTenantId() : execPlan.getTenantId());
                saveList.add(lightEntity);
            }
            projectWarnMap.put(execPlan.getProjectId(), sumWarn);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.contractLightService.saveOrUpdateBatch(saveList);
        }
        return projectWarnMap;
    }

    private void recordProjectLight(List<ExecPlanEntity> execList, Map<Long, LightRuleEntity> projectLightRuleMap, Map<Long, Integer> projectWarnMap, Map<Long, ProjectVO> projectMap) {
        List execIds = execList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("execPlanId", new Parameter("in", execIds));
        List list = this.projectLightService.queryList(queryParam);
        Map map = list.stream().collect(Collectors.toMap(ProjectLightEntity::getExecPlanId, Function.identity()));
        ArrayList<ProjectLightEntity> saveList = new ArrayList<ProjectLightEntity>();
        for (ExecPlanEntity execPlan : execList) {
            ProjectVO projectVO = projectMap.get(execPlan.getProjectId());
            if (projectVO == null) continue;
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, execPlan.getProjectId(), LightRuleLevelEnum.\u9879\u76ee\u5b8c\u6210\u65f6\u95f4.getCode());
            ProjectLightEntity lightEntity = new ProjectLightEntity();
            if (map.containsKey(execPlan.getId())) {
                lightEntity = (ProjectLightEntity)((Object)map.get(execPlan.getId()));
            }
            lightEntity.setProjectId(execPlan.getProjectId());
            lightEntity.setProjectName(execPlan.getProjectName());
            lightEntity.setOrgId(execPlan.getOrgId());
            lightEntity.setOrgName(execPlan.getOrgName());
            lightEntity.setCorpId(execPlan.getCorpId());
            lightEntity.setCorpName(execPlan.getCorpName());
            lightEntity.setExecPlanId(execPlan.getId());
            lightEntity.setExecPlanCode(execPlan.getBillCode());
            lightEntity.setProjectManager(projectVO.getLeader());
            lightEntity.setProjectType(projectVO.getProjectControlLevel());
            lightEntity.setStartDate(projectVO.getStartDate());
            Integer sumWarn = projectWarnMap.get(execPlan.getProjectId());
            lightEntity.setSumWarn(null != sumWarn ? new BigDecimal(sumWarn) : BigDecimal.ZERO);
            List detailList = execPlan.getAllList().stream().filter(e -> PlanConstant.TOTAL_PLAN == e.getPlanState()).collect(Collectors.toList());
            this.logger.info("\u6267\u884c\u8ba1\u5212\u9879\u76eeid-{},\u5b57\u8868\u6570\u91cf-{},\u8fc7\u6ee4\u540e\u5b57\u8868\u6570\u91cf-{}", new Object[]{execPlan.getProjectId(), execPlan.getAllList().size(), detailList.size()});
            if (CollectionUtils.isEmpty(detailList)) continue;
            Date maxPredictFinish = detailList.stream().map(ExecPlanDetailEntity::getPredictFinish).max(Comparator.comparing(e -> e)).get();
            Date maxPlanFinish = detailList.stream().map(ExecPlanDetailEntity::getPlanFinish).max(Comparator.comparing(e -> e)).get();
            BigDecimal maxDiffValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, maxPlanFinish));
            Integer lightType = LightTypeEnum.\u7eff\u706f.getCode();
            if (null != lightRuleLevel) {
                BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, new Date()));
                BigDecimal finalValue = ComputeUtil.safeDiv(maxDiffValue, residueValue);
                lightType = this.getLightType(lightRuleLevel, maxDiffValue, finalValue, false, null);
                lightEntity.setLightType(lightType);
            }
            if (null != lightType && lightType >= LightTypeEnum.\u84dd\u706f.getCode()) {
                lightEntity.setCriticalPath(PlanConstant.INTEGER_YES);
            } else {
                lightEntity.setCriticalPath(PlanConstant.INTEGER_NO);
            }
            lightEntity.setDiffValue(maxDiffValue);
            lightEntity.setUpdateTime(lightEntity.getUpdateTime() != null ? lightEntity.getUpdateTime() : new Date());
            lightEntity.setTenantId(lightEntity.getTenantId() != null ? lightEntity.getTenantId() : execPlan.getTenantId());
            saveList.add(lightEntity);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.projectLightService.saveOrUpdateBatch(saveList);
        }
    }

    private void recordMonthLight(List<ExecPlanEntity> execList, List<MonthPlanEntity> monthList, Map<Long, LightRuleEntity> projectLightRuleMap) {
        Map execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, Function.identity()));
        List monthIds = monthList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("monthPlanId", new Parameter("in", monthIds));
        List list = this.monthLightService.queryList(queryParam);
        Map map = list.stream().collect(Collectors.toMap(MonthLightEntity::getMonthPlanId, Function.identity()));
        ArrayList<MonthLightEntity> saveList = new ArrayList<MonthLightEntity>();
        for (MonthPlanEntity month : monthList) {
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, month.getProjectId(), LightRuleLevelEnum.\u6708\u8ba1\u5212\u5b8c\u6210.getCode());
            MonthLightEntity lightEntity = new MonthLightEntity();
            if (map.containsKey(month.getId())) {
                lightEntity = (MonthLightEntity)((Object)map.get(month.getId()));
            }
            lightEntity.setProjectId(month.getProjectId());
            lightEntity.setProjectName(month.getProjectName());
            lightEntity.setOrgId(month.getOrgId());
            lightEntity.setOrgName(month.getOrgName());
            lightEntity.setCorpId(month.getCorpId());
            lightEntity.setCorpName(month.getCorpName());
            lightEntity.setMonthPlanId(month.getId());
            lightEntity.setMonthPlanCode(month.getBillCode());
            lightEntity.setPlanMonth(month.getPlanMonth());
            List<MonthPlanDetailEntity> monthDetailList = month.getAllList();
            ExecPlanEntity execPlanEntity = (ExecPlanEntity)((Object)execMap.get(month.getProjectId()));
            List<ExecPlanDetailEntity> execDetailList = execPlanEntity.getAllList();
            Map structCodeMap = monthDetailList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, Function.identity()));
            List detailList = execDetailList.stream().filter(e -> null != structCodeMap.get(e.getStructCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(detailList)) continue;
            ArrayList<Date> leftDateList = new ArrayList<Date>();
            ArrayList<Date> rightDateList = new ArrayList<Date>();
            Map execPlanDetailMap = detailList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, Function.identity()));
            for (MonthPlanDetailEntity monthDetail : monthDetailList) {
                ExecPlanDetailEntity execDetail = (ExecPlanDetailEntity)((Object)execPlanDetailMap.get(monthDetail.getStructCode()));
                if (null == execDetail || !StringUtils.isNotEmpty((CharSequence)monthDetail.getName()) || !StringUtils.isNotEmpty((CharSequence)execDetail.getName())) continue;
                String percentTask = monthDetail.getName().substring(execDetail.getName().length());
                if (StringUtils.isEmpty((CharSequence)percentTask)) {
                    Integer y = 100;
                    Integer value = DateUtil.getBetweenDays(execDetail.getPredictFinish(), execDetail.getPredictStart());
                    Date leftDate = DateUtil.addDays(execDetail.getPredictStart(), y / 100 * (value + 1) - 1);
                    leftDateList.add(leftDate);
                    rightDateList.add(monthDetail.getFinish());
                    continue;
                }
                String split1 = percentTask.split("-")[1];
                String str = split1.substring(0, split1.length() - 2);
                if (StringUtils.isEmpty((CharSequence)str)) continue;
                Float y = new Float(str);
                Integer value = DateUtil.getBetweenDays(execDetail.getPredictFinish(), execDetail.getPredictStart());
                int round = Math.round(y.floatValue() / 100.0f * (float)(value + 1));
                Date leftDate = DateUtil.addDays(execDetail.getPredictStart(), round);
                leftDateList.add(leftDate);
                rightDateList.add(monthDetail.getFinish());
            }
            Date rightDate = null;
            Date date = rightDateList.stream().max(Comparator.comparing(e -> e)).get();
            Date monthLastDate = DateUtil.getMonthLastDate(new Date());
            rightDate = date.getTime() <= monthLastDate.getTime() ? date : monthLastDate;
            Date leftDate = leftDateList.stream().max(Comparator.comparing(e -> e)).get();
            BigDecimal maxDiffValue = new BigDecimal(DateUtil.getBetweenDays(leftDate, rightDate));
            if (null != lightRuleLevel) {
                Date maxPredictFinish = detailList.stream().max(Comparator.comparing(ExecPlanDetailEntity::getPredictFinish)).get().getPredictFinish();
                BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, new Date()));
                BigDecimal finalValue = ComputeUtil.safeDiv(maxDiffValue, residueValue);
                Integer lightType = this.getLightType(lightRuleLevel, maxDiffValue, finalValue, false, null);
                lightEntity.setLightType(lightType);
            }
            lightEntity.setDiffValue(maxDiffValue);
            lightEntity.setUpdateTime(lightEntity.getUpdateTime() != null ? lightEntity.getUpdateTime() : new Date());
            lightEntity.setTenantId(lightEntity.getTenantId() != null ? lightEntity.getTenantId() : month.getTenantId());
            saveList.add(lightEntity);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.monthLightService.saveOrUpdateBatch(saveList);
        }
    }

    private Map<Long, LightRuleEntity> getProjectLightRuleMap(Map<Long, ProjectVO> projectMap, Map<Long, OrgVO> orgMap) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("create_time", "asc");
        List lightRuleList = this.lightRuleService.queryList(queryParam);
        this.detailListUtil.setDetailList(lightRuleList);
        HashMap<Long, LightRuleEntity> orgRuleMap = new HashMap<Long, LightRuleEntity>();
        for (Object entity : lightRuleList) {
            orgRuleMap.put(((LightRuleEntity)((Object)entity)).getOrgId(), (LightRuleEntity)((Object)entity));
        }
        HashMap<Long, LightRuleEntity> deptOrgIdRuleMap = new HashMap<Long, LightRuleEntity>();
        if (CollectionUtils.isNotEmpty(orgRuleMap.keySet())) {
            for (Long orgRuleId : orgRuleMap.keySet()) {
                LightRuleEntity lightRuleEntity = (LightRuleEntity)((Object)orgRuleMap.get(orgRuleId));
                for (OrgVO orgVO : orgMap.values()) {
                    String orgId;
                    String innerCode = orgVO.getInnerCode();
                    if (!innerCode.contains(orgId = orgRuleId.toString()) || orgMap.containsKey(orgId) && orgMap.get(orgId).getInnerCode().length() > innerCode.length()) continue;
                    deptOrgIdRuleMap.put(orgVO.getId(), lightRuleEntity);
                }
            }
        }
        HashMap<Long, LightRuleEntity> projectLightRuleMap = new HashMap<Long, LightRuleEntity>();
        for (ProjectVO project : projectMap.values()) {
            if (!deptOrgIdRuleMap.containsKey(project.getProjectDepartmentId())) continue;
            projectLightRuleMap.put(project.getId(), (LightRuleEntity)((Object)deptOrgIdRuleMap.get(project.getProjectDepartmentId())));
        }
        return projectLightRuleMap;
    }

    @Override
    public CommonResponse pushNotice(HttpServletRequest request) {
        List<ContractLightEntity> contractLightList;
        this.logger.info("--> \u6d88\u606f\u63a8\u9001\u5f00\u59cb");
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        List setList = this.pushSetService.queryList(queryParam2);
        if (CollectionUtils.isEmpty((Collection)setList)) {
            this.logger.info("\u672a\u67e5\u5230\u63a8\u9001\u8bbe\u7f6e\uff01");
            return CommonResponse.success((String)"\u672a\u67e5\u5230\u63a8\u9001\u8bbe\u7f6e\uff01");
        }
        Map setMap = setList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("setId", new Parameter("in", setList.stream().map(BaseEntity::getId).collect(Collectors.toList())));
        List receiveList = this.receiveService.queryList(queryParam3);
        List<Long> orgIds = setList.stream().map(PushSetEntity::getOrgId).collect(Collectors.toList());
        HashMap<Long, List<Long>> orgMap = new HashMap<Long, List<Long>>();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            orgIds.forEach(i -> {
                if (!orgMap.containsKey(i)) {
                    List childIds = ((List)this.orgApi.findChildrenByParentId(i).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                    orgMap.put((Long)i, childIds);
                }
            });
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(new Date()).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month2 = Integer.valueOf(split[1]);
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(1, year);
        c1.set(2, Month2 - 1);
        int firstDay = c1.getActualMinimum(5);
        c1.set(5, firstDay);
        Date monthFirstDate = c1.getTime();
        List projectLightList = this.projectLightService.list();
        List<Long> projectIds = projectLightList.stream().map(ProjectLightEntity::getProjectId).collect(Collectors.toList());
        Map<Long, ProjectVO> projectMap = this.feignUtil.getProjectMapByIds(projectIds);
        List monthLightList = this.monthLightService.list((Wrapper)new LambdaQueryWrapper().eq(MonthLightEntity::getPlanMonth, (Object)monthFirstDate));
        List<ContractLightEntity> oldContractLightList = contractLightList = this.contractLightService.list();
        ArrayList<ContractLightEntity> newContractLightList = new ArrayList<ContractLightEntity>();
        contractLightList = contractLightList.stream().filter(e -> !LightTypeEnum.\u7d2b\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
        contractLightList.stream().filter(x -> x.getLightType() != null).collect(Collectors.groupingBy(ContractLightEntity::getProjectId, Collectors.maxBy(Comparator.comparing(ContractLightEntity::getLightType)))).forEach((k, v) -> newContractLightList.add((ContractLightEntity)((Object)v.get())));
        HashMap<String, Map<Long, LevelReceiveVO>> levelMap = new HashMap<String, Map<Long, LevelReceiveVO>>();
        if (CollectionUtils.isNotEmpty((Collection)receiveList)) {
            for (PushSetReceiveEntity receive : receiveList) {
                LevelReceiveVO vo = this.getReceiveVO(levelMap, receive, (PushSetEntity)((Object)setMap.get(receive.getSetId())));
                if (LevelEnum.\u4e00\u7ea7.getCode().equals(receive.getLevel())) {
                    this.calculateProject(projectLightList, receive, vo, orgMap);
                }
                if (LevelEnum.\u4e8c\u7ea7.getCode().equals(receive.getLevel())) {
                    this.calculateContract(newContractLightList, receive, vo, orgMap);
                }
                if (LevelEnum.\u4e09\u7ea7.getCode().equals(receive.getLevel())) {
                    this.calculateMonth(monthLightList, receive, vo, orgMap);
                }
                if (!LevelEnum.\u56db\u7ea7.getCode().equals(receive.getLevel())) continue;
                this.calculateContractWarn(oldContractLightList, receive, vo, orgMap);
            }
        }
        if (MapUtils.isNotEmpty(levelMap)) {
            for (Map level : levelMap.values()) {
                if (!MapUtils.isNotEmpty((Map)level)) continue;
                for (LevelReceiveVO vo : level.values()) {
                    Boolean fillFlag = this.getFillFlag(vo.getFillType(), vo.getFillTime());
                    if (!fillFlag.booleanValue()) continue;
                    if (LevelEnum.\u4e00\u7ea7.getCode().equals(vo.getLevel())) {
                        this.analysisProject(vo, projectMap);
                    }
                    if (LevelEnum.\u4e8c\u7ea7.getCode().equals(vo.getLevel())) {
                        this.analysisContract(vo, projectMap);
                    }
                    if (LevelEnum.\u4e09\u7ea7.getCode().equals(vo.getLevel())) {
                        this.analysisMonth(vo, projectMap);
                    }
                    if (!LevelEnum.\u56db\u7ea7.getCode().equals(vo.getLevel())) continue;
                    this.analysisContractWarn(vo);
                }
            }
        }
        this.logger.info("\u6267\u884c\u6210\u529f\uff01");
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    private LevelReceiveVO getReceiveVO(Map<String, Map<Long, LevelReceiveVO>> levelMap, PushSetReceiveEntity receive, PushSetEntity set) {
        Map<Object, Object> map = new HashMap();
        String key = receive.getSetId() + "|" + receive.getLevel();
        if (!levelMap.containsKey(key)) {
            levelMap.put(key, map);
        }
        map = levelMap.get(key);
        LevelReceiveVO vo = new LevelReceiveVO();
        if (!map.containsKey(receive.getReceiveId())) {
            vo.setOrgId(set.getOrgId());
            vo.setOrgName(set.getOrgName());
            vo.setOrgType(receive.getOrgType());
            vo.setReceiveId(receive.getReceiveId());
            vo.setReceiveName(receive.getReceiveName());
            vo.setReceiveType(receive.getReceiveType());
            vo.setLevel(receive.getLevel());
            vo.setFillType(set.getFillType());
            vo.setFillTime(set.getFillTime());
            vo.setProjectBlueIds(new HashSet());
            vo.setProjectYellowIds(new HashSet());
            vo.setProjectRedIds(new HashSet());
            vo.setMonthBlueIds(new HashSet());
            vo.setMonthYellowIds(new HashSet());
            vo.setMonthRedIds(new HashSet());
            vo.setContractBlueIds(new HashSet());
            vo.setContractYellowIds(new HashSet());
            vo.setContractRedIds(new HashSet());
            vo.setContractVioletIds(new HashSet());
            map.put(receive.getReceiveId(), vo);
        }
        vo = (LevelReceiveVO)map.get(receive.getReceiveId());
        return vo;
    }

    private void calculateProject(List<ProjectLightEntity> projectLightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set blueIds = vo.getProjectBlueIds();
        Set yellowIds = vo.getProjectYellowIds();
        Set redIds = vo.getProjectRedIds();
        for (ProjectLightEntity data : projectLightList) {
            if (!orgMap.get(vo.getOrgId()).contains(data.getOrgId())) continue;
            if (LightTypeEnum.\u84dd\u706f.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.\u84dd\u706f.getCode().equals(data.getLightType())) {
                blueIds.add(data.getProjectId());
            }
            if (LightTypeEnum.\u9ec4\u706f.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.\u9ec4\u706f.getCode().equals(data.getLightType())) {
                yellowIds.add(data.getProjectId());
            }
            if (!LightTypeEnum.\u7ea2\u706f.getCode().equals(receive.getLightType() - 1) || !LightTypeEnum.\u7ea2\u706f.getCode().equals(data.getLightType())) continue;
            redIds.add(data.getProjectId());
        }
        vo.setProjectBlueIds(blueIds);
        vo.setProjectYellowIds(yellowIds);
        vo.setProjectRedIds(redIds);
    }

    private void calculateMonth(List<MonthLightEntity> lightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set blueIds = vo.getMonthBlueIds();
        Set yellowIds = vo.getMonthYellowIds();
        Set redIds = vo.getMonthRedIds();
        for (MonthLightEntity data : lightList) {
            if (!orgMap.get(vo.getOrgId()).contains(data.getOrgId())) continue;
            if (LightTypeEnum.\u84dd\u706f.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.\u84dd\u706f.getCode().equals(data.getLightType())) {
                blueIds.add(data.getProjectId());
            }
            if (LightTypeEnum.\u9ec4\u706f.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.\u9ec4\u706f.getCode().equals(data.getLightType())) {
                yellowIds.add(data.getProjectId());
            }
            if (!LightTypeEnum.\u7ea2\u706f.getCode().equals(receive.getLightType() - 1) || !LightTypeEnum.\u7ea2\u706f.getCode().equals(data.getLightType())) continue;
            redIds.add(data.getProjectId());
        }
        vo.setMonthBlueIds(blueIds);
        vo.setMonthYellowIds(yellowIds);
        vo.setMonthRedIds(redIds);
    }

    private void calculateContract(List<ContractLightEntity> lightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set blueIds = vo.getContractBlueIds();
        Set yellowIds = vo.getContractYellowIds();
        Set redIds = vo.getContractRedIds();
        for (ContractLightEntity data : lightList) {
            if (!orgMap.get(vo.getOrgId()).contains(data.getOrgId())) continue;
            if (LightTypeEnum.\u84dd\u706f.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.\u84dd\u706f.getCode().equals(data.getLightType())) {
                blueIds.add(data.getProjectId());
            }
            if (LightTypeEnum.\u9ec4\u706f.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.\u9ec4\u706f.getCode().equals(data.getLightType())) {
                yellowIds.add(data.getProjectId());
            }
            if (!LightTypeEnum.\u7ea2\u706f.getCode().equals(receive.getLightType() - 1) || !LightTypeEnum.\u7ea2\u706f.getCode().equals(data.getLightType())) continue;
            redIds.add(data.getProjectId());
        }
        vo.setContractBlueIds(blueIds);
        vo.setContractYellowIds(yellowIds);
        vo.setContractRedIds(redIds);
    }

    private void calculateContractWarn(List<ContractLightEntity> lightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set violetIds = vo.getContractVioletIds();
        for (ContractLightEntity data : lightList) {
            if (!orgMap.get(vo.getOrgId()).contains(data.getOrgId()) || !LightTypeEnum.\u7d2b\u706f.getCode().equals(receive.getLightType() - 1) || !LightTypeEnum.\u7d2b\u706f.getCode().equals(data.getLightType())) continue;
            violetIds.add(data.getProjectId());
        }
        vo.setContractVioletIds(violetIds);
    }

    private Boolean getFillFlag(String fillType, String fillTime) {
        Integer day;
        int DAY_OF_MONTH;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Boolean fillFlag = false;
        if ("1".equals(fillType)) {
            fillFlag = true;
        } else if ("2".equals(fillType)) {
            Integer day2;
            int DAY_OF_WEEK = cal.get(7);
            if (DAY_OF_WEEK == WarnDateUtil.turnZnDayOfWeek(day2 = Integer.valueOf(fillTime))) {
                fillFlag = true;
            }
        } else if ("3".equals(fillType) && (DAY_OF_MONTH = cal.get(5)) == WarnDateUtil.turnZnDayOfMonth(day = Integer.valueOf(fillTime))) {
            fillFlag = true;
        }
        return fillFlag;
    }

    private boolean analysisProject(LevelReceiveVO vo, Map<Long, ProjectVO> projectMap) {
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("dingding");
        int sum = vo.getProjectRedIds().size() + vo.getProjectYellowIds().size() + vo.getProjectBlueIds().size();
        if (sum < 1) {
            return true;
        }
        StringBuffer str = new StringBuffer();
        StringBuffer url = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        str.append("\u622a\u6b62\u81f3" + sdf.format(new Date()) + "\uff0c\u5171\u6709" + sum + "\u4e2a\u9879\u76ee\u72b6\u6001\u5f02\u5e38\uff1a");
        url.append("\u622a\u6b62\u81f3" + sdf.format(new Date()) + "\uff0c\u5171\u6709" + sum + "\u4e2a\u9879\u76ee\u72b6\u6001\u5f02\u5e38\uff1a");
        ArrayList<Integer> lightType = new ArrayList<Integer>();
        if (vo.getProjectRedIds().size() > 0) {
            str.append("\u9879\u76ee\u5b8c\u6210\u65f6\u95f4\u7ea2\u706f\u9879\u76ee\uff1a" + vo.getProjectRedIds().size() + "\u4e2a\uff1b");
            url.append("\u9879\u76ee\u5b8c\u6210\u65f6\u95f4\u7ea2\u706f\u9879\u76ee\uff1a" + vo.getProjectRedIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getProjectRedIds());
            lightType.add(LightTypeEnum.\u7ea2\u706f.getCode());
        }
        if (vo.getProjectYellowIds().size() > 0) {
            str.append("\u9879\u76ee\u5b8c\u6210\u65f6\u95f4\u9ec4\u706f\u9879\u76ee\uff1a" + vo.getProjectYellowIds().size() + "\u4e2a\uff1b");
            url.append("\u9879\u76ee\u5b8c\u6210\u65f6\u95f4\u9ec4\u706f\u9879\u76ee\uff1a" + vo.getProjectYellowIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getProjectYellowIds());
            lightType.add(LightTypeEnum.\u9ec4\u706f.getCode());
        }
        if (vo.getProjectBlueIds().size() > 0) {
            str.append("\u9879\u76ee\u5b8c\u6210\u65f6\u95f4\u84dd\u706f\u9879\u76ee\uff1a" + vo.getProjectBlueIds().size() + "\u4e2a\uff1b");
            url.append("\u9879\u76ee\u5b8c\u6210\u65f6\u95f4\u84dd\u706f\u9879\u76ee\uff1a" + vo.getProjectBlueIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getProjectBlueIds());
            lightType.add(LightTypeEnum.\u84dd\u706f.getCode());
        }
        ArrayList<String> sender = new ArrayList();
        if (vo.getReceiveType().equals("user")) {
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if (vo.getReceiveType().equals("role")) {
            CommonResponse response = this.roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()), Arrays.asList(vo.getOrgId()));
            if (!response.isSuccess()) {
                return false;
            }
            sender = ((List)response.getData()).stream().map(RoleUserRelationVO::getUserId).map(String::valueOf).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(sender)) {
            String formurl = this.baseHost + "ejc-zjkjprogress-frontend/#/projectLight";
            if (CollectionUtils.isNotEmpty(lightType)) {
                Collections.reverse(lightType);
                formurl = formurl + "?lightType=" + StringUtils.join(lightType, (String)",");
            }
            String mobileUrl = this.baseHost + "ejc-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = url.toString() + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, mobileUrl, formurl);
        }
        return true;
    }

    private void projectNameLink(StringBuffer str, StringBuffer url, Map<Long, ProjectVO> projectMap, Set<Long> projectIds) {
        String pcurl = this.baseHost + "ejc-zjkjprogress-frontend/#/queryProgress";
        for (Long projectId : projectIds) {
            ProjectVO project = projectMap.get(projectId);
            str.append("\u3010" + project.getProjectName() + "\u3011");
            url.append("\u3010<a href=\"" + pcurl + "?orgId=" + project.getProjectDepartmentId() + '\"' + ">");
            url.append(project.getProjectName());
            url.append("</a>\u3011");
        }
    }

    private boolean analysisContract(LevelReceiveVO vo, Map<Long, ProjectVO> projectMap) {
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("dingding");
        int sum = vo.getContractRedIds().size() + vo.getContractYellowIds().size() + vo.getContractBlueIds().size();
        if (sum < 1) {
            return true;
        }
        StringBuffer str = new StringBuffer();
        StringBuffer url = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        str.append("\u622a\u6b62\u81f3" + sdf.format(new Date()) + "\uff0c\u5171\u6709" + sum + "\u4e2a\u9879\u76ee\u72b6\u6001\u5f02\u5e38\uff1a");
        url.append("\u622a\u6b62\u81f3" + sdf.format(new Date()) + "\uff0c\u5171\u6709" + sum + "\u4e2a\u9879\u76ee\u72b6\u6001\u5f02\u5e38\uff1a");
        ArrayList<Integer> lightType = new ArrayList<Integer>();
        if (vo.getContractRedIds().size() > 0) {
            str.append("\u5408\u540c\u8282\u70b9\u7ea2\u706f\u9879\u76ee\uff1a" + vo.getContractRedIds().size() + "\u4e2a\uff1b");
            url.append("\u5408\u540c\u8282\u70b9\u7ea2\u706f\u9879\u76ee\uff1a" + vo.getContractRedIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getContractRedIds());
            lightType.add(LightTypeEnum.\u7ea2\u706f.getCode());
        }
        if (vo.getContractYellowIds().size() > 0) {
            str.append("\u5408\u540c\u8282\u70b9\u9ec4\u706f\u9879\u76ee\uff1a" + vo.getContractYellowIds().size() + "\u4e2a\uff1b");
            url.append("\u5408\u540c\u8282\u70b9\u9ec4\u706f\u9879\u76ee\uff1a" + vo.getContractYellowIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getContractYellowIds());
            lightType.add(LightTypeEnum.\u9ec4\u706f.getCode());
        }
        if (vo.getContractBlueIds().size() > 0) {
            str.append("\u5408\u540c\u8282\u70b9\u84dd\u706f\u9879\u76ee\uff1a" + vo.getContractBlueIds().size() + "\u4e2a\uff1b");
            url.append("\u5408\u540c\u8282\u70b9\u84dd\u706f\u9879\u76ee\uff1a" + vo.getContractBlueIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getContractBlueIds());
            lightType.add(LightTypeEnum.\u84dd\u706f.getCode());
        }
        ArrayList<String> sender = new ArrayList();
        if (vo.getReceiveType().equals("user")) {
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if (vo.getReceiveType().equals("role")) {
            CommonResponse response = this.roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()), Arrays.asList(vo.getOrgId()));
            if (!response.isSuccess()) {
                return false;
            }
            sender = ((List)response.getData()).stream().map(RoleUserRelationVO::getUserId).map(String::valueOf).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(sender)) {
            String formurl = this.baseHost + "ejc-zjkjprogress-frontend/#/projectLight";
            if (CollectionUtils.isNotEmpty(lightType)) {
                Collections.reverse(lightType);
                formurl = formurl + "?lightType=" + StringUtils.join(lightType, (String)",");
            }
            String mobileUrl = this.baseHost + "ejc-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = url.toString() + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, mobileUrl, formurl);
        }
        return true;
    }

    private boolean analysisMonth(LevelReceiveVO vo, Map<Long, ProjectVO> projectMap) {
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("dingding");
        int sum = vo.getMonthRedIds().size() + vo.getMonthYellowIds().size() + vo.getMonthBlueIds().size();
        if (sum < 1) {
            return true;
        }
        StringBuffer str = new StringBuffer();
        StringBuffer url = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        str.append("\u622a\u6b62\u81f3" + sdf.format(new Date()) + "\uff0c\u5171\u6709" + sum + "\u4e2a\u9879\u76ee\u72b6\u6001\u5f02\u5e38\uff1a");
        url.append("\u622a\u6b62\u81f3" + sdf.format(new Date()) + "\uff0c\u5171\u6709" + sum + "\u4e2a\u9879\u76ee\u72b6\u6001\u5f02\u5e38\uff1a");
        ArrayList<Integer> lightType = new ArrayList<Integer>();
        if (vo.getMonthRedIds().size() > 0) {
            str.append("\u5f53\u6708\u6708\u8ba1\u5212\u5b8c\u6210\u7ea2\u706f\u9879\u76ee\uff1a" + vo.getMonthRedIds().size() + "\u4e2a\uff1b");
            url.append("\u5f53\u6708\u6708\u8ba1\u5212\u5b8c\u6210\u7ea2\u706f\u9879\u76ee\uff1a" + vo.getMonthRedIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getMonthRedIds());
            lightType.add(LightTypeEnum.\u7ea2\u706f.getCode());
        }
        if (vo.getMonthYellowIds().size() > 0) {
            str.append("\u5f53\u6708\u6708\u8ba1\u5212\u5b8c\u6210\u9ec4\u706f\u9879\u76ee\uff1a" + vo.getMonthYellowIds().size() + "\u4e2a\uff1b");
            url.append("\u5f53\u6708\u6708\u8ba1\u5212\u5b8c\u6210\u9ec4\u706f\u9879\u76ee\uff1a" + vo.getMonthYellowIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getMonthYellowIds());
            lightType.add(LightTypeEnum.\u9ec4\u706f.getCode());
        }
        if (vo.getMonthBlueIds().size() > 0) {
            str.append("\u5f53\u6708\u6708\u8ba1\u5212\u5b8c\u6210\u84dd\u706f\u9879\u76ee\uff1a" + vo.getMonthBlueIds().size() + "\u4e2a\uff1b");
            url.append("\u5f53\u6708\u6708\u8ba1\u5212\u5b8c\u6210\u84dd\u706f\u9879\u76ee\uff1a" + vo.getMonthBlueIds().size() + "\u4e2a\uff1b");
            this.projectNameLink(str, url, projectMap, vo.getMonthBlueIds());
            lightType.add(LightTypeEnum.\u84dd\u706f.getCode());
        }
        ArrayList<String> sender = new ArrayList();
        if (vo.getReceiveType().equals("user")) {
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if (vo.getReceiveType().equals("role")) {
            CommonResponse response = this.roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()), Arrays.asList(vo.getOrgId()));
            if (!response.isSuccess()) {
                return false;
            }
            sender = ((List)response.getData()).stream().map(RoleUserRelationVO::getUserId).map(String::valueOf).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(sender)) {
            String formurl = this.baseHost + "sdbj-zjkjprogress-frontend/#/projectLight";
            if (CollectionUtils.isNotEmpty(lightType)) {
                Collections.reverse(lightType);
                formurl = formurl + "?lightType=" + StringUtils.join(lightType, (String)",");
            }
            String mobileUrl = this.baseHost + "sdbj-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = url.toString() + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, mobileUrl, formurl);
        }
        return true;
    }

    private boolean analysisContractWarn(LevelReceiveVO vo) {
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("dingding");
        int sum = vo.getContractVioletIds().size();
        if (sum < 1) {
            return true;
        }
        StringBuffer str = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        str.append("\u622a\u6b62\u81f3" + sdf.format(new Date()) + "\uff0c\u5171\u6709" + sum + "\u4e2a\u9879\u76ee\u5408\u540c\u8282\u70b9\u5b58\u5728\u62a5\u8b66\u72b6\u6001\uff1a");
        str.append("\u672c\u5468\u671f\u65b0\u589e\u5408\u540c\u8282\u70b9\u62a5\u8b66\u72b6\u6001\u7684\u9879\u76ee" + vo.getContractVioletIds().size() + "\u4e2a\uff1b");
        ArrayList<String> sender = new ArrayList();
        if (vo.getReceiveType().equals("user")) {
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if (vo.getReceiveType().equals("role")) {
            CommonResponse response = this.roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()), Arrays.asList(vo.getOrgId()));
            if (!response.isSuccess()) {
                return false;
            }
            sender = ((List)response.getData()).stream().map(RoleUserRelationVO::getUserId).map(String::valueOf).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(sender)) {
            String formurl = this.baseHost + "ejc-zjkjprogress-frontend/#/projectLight";
            String mobileUrl = this.baseHost + "ejc-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, sender, "notice", subject, null, mobileUrl, formurl);
        }
        return true;
    }

    @Override
    public CommonResponse<WarnProjectVO> queryProject(Long orgId) {
        WarnProjectVO warnVO = new WarnProjectVO();
        CommonResponse resp = this.projectApi.queryProjectByProjectDepartmentId(orgId);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        ProjectVO project = (ProjectVO)resp.getData();
        if (project == null) {
            return CommonResponse.success((String)"\u9879\u76ee\u4e3a\u7a7a\uff01", (Object)warnVO);
        }
        EmployeeVO employee = null;
        if (project != null && project.getLeader() != null) {
            Long userId = project.getLeader();
            CommonResponse userResp = this.employeeApi.queryEmployeByUserId(userId);
            if (!userResp.isSuccess()) {
                throw new BusinessException(userResp.getMsg());
            }
            if (userResp.getData() != null) {
                employee = (EmployeeVO)userResp.getData();
            }
        }
        warnVO.setProjectId(project.getId());
        warnVO.setProjectName(project.getProjectName());
        warnVO.setOrgId(project.getProjectDepartmentId());
        warnVO.setProjectStatus(project.getStatus());
        warnVO.setProjectName(project.getProjectName());
        if (null != employee) {
            warnVO.setProjectManagerName(employee.getUserName());
            warnVO.setMobilePhone(employee.getMobilePhone());
        }
        LambdaQueryWrapper projectQueryWrapper = new LambdaQueryWrapper();
        projectQueryWrapper.eq(ProjectLightEntity::getProjectId, (Object)project.getId());
        ProjectLightEntity projectLightEntity = (ProjectLightEntity)((Object)this.projectLightService.getOne((Wrapper)projectQueryWrapper));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(new Date()).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month2 = Integer.valueOf(split[1]);
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(1, year);
        c1.set(2, Month2 - 1);
        int firstDay = c1.getActualMinimum(5);
        c1.set(5, firstDay);
        Date monthFirstDate = c1.getTime();
        LambdaQueryWrapper monthQueryWrapper = new LambdaQueryWrapper();
        monthQueryWrapper.eq(MonthLightEntity::getProjectId, (Object)project.getId());
        monthQueryWrapper.eq(MonthLightEntity::getPlanMonth, (Object)monthFirstDate);
        MonthLightEntity monthLightEntity = (MonthLightEntity)((Object)this.monthLightService.getOne((Wrapper)monthQueryWrapper));
        ExecPlanVO execPlan = new ExecPlanVO();
        ArrayList<ExecPlanDetailVO> execPlanDetailList = new ArrayList<ExecPlanDetailVO>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"project_id", (Object)project.getId());
        ExecPlanEntity entity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)ew));
        if (null != entity) {
            QueryWrapper contractLight = new QueryWrapper();
            contractLight.eq((Object)"progress_id", (Object)entity.getId());
            contractLight.eq((Object)"node_level", (Object)PlanConstant.LEVEL_CONTRACT);
            contractLight.orderByAsc((Object)"tid");
            List detailList = this.execPlanDetailService.list((Wrapper)contractLight);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                for (ExecPlanDetailEntity detail : detailList) {
                    ExecPlanDetailVO execPlanDetailVO = ExecPlanDetailEntity.convertEntityToVo(detail);
                    Integer status = null;
                    if (null == execPlanDetailVO.getActualStart() && null == execPlanDetailVO.getActualFinish()) {
                        status = FillConstant.NOT_STAR;
                    }
                    if (null != execPlanDetailVO.getActualStart() && null != execPlanDetailVO.getPredictFinish() && null == execPlanDetailVO.getActualFinish()) {
                        status = FillConstant.UNDERWAY;
                    }
                    if (null != execPlanDetailVO.getActualStart() && null != execPlanDetailVO.getActualFinish()) {
                        status = FillConstant.FINISHED;
                    }
                    execPlanDetailVO.setFinishState(status);
                    execPlanDetailVO.setChildren(null);
                    execPlanDetailList.add(execPlanDetailVO);
                }
            }
        }
        if (null != entity) {
            execPlan = this.execPlanService.queryRefDetail(project.getId(), null, null, null);
        }
        if (null != projectLightEntity) {
            warnVO.setProjectDays(projectLightEntity.getDiffValue());
            warnVO.setProjectLight(projectLightEntity.getLightType() != null ? projectLightEntity.getLightType() : LightTypeEnum.\u7eff\u706f.getCode());
        }
        if (null != monthLightEntity) {
            warnVO.setMonthDays(monthLightEntity.getDiffValue());
            warnVO.setMonthLight(monthLightEntity.getLightType());
        }
        LambdaQueryWrapper monthPlanQueryWrapper = new LambdaQueryWrapper();
        monthPlanQueryWrapper.eq(MonthPlanEntity::getProjectId, (Object)project.getId());
        monthPlanQueryWrapper.eq(MonthPlanEntity::getPlanMonth, (Object)monthFirstDate);
        MonthPlanEntity one = (MonthPlanEntity)((Object)this.monthPlanService.getOne((Wrapper)monthPlanQueryWrapper));
        if (null != one) {
            warnVO.setIsMonthPlan(PlanConstant.INTEGER_YES);
        }
        warnVO.setPlanId(execPlan.getId());
        warnVO.setContractLightList(execPlanDetailList);
        warnVO.setExecPlan(execPlan);
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01", (Object)warnVO);
    }

    @Override
    public JSONObject projectFinishList(QueryParam param) {
        JSONObject page = new JSONObject();
        String text = param.getSearchText();
        int current = param.getPageIndex();
        int size = param.getPageSize();
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List execList = this.execPlanService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)execList)) {
            page.put("records", new ArrayList());
            page.put("total", (Object)0);
            page.put("pages", (Object)0);
            return page;
        }
        List execIds = execList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x -> x));
        if (CollectionUtils.isNotEmpty(execIds)) {
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter("in", execIds));
            List execDetailList = this.execPlanDetailService.queryList(detailParam);
            execDetailList.forEach(vo -> {
                if (execMap.containsKey(vo.getProjectId())) {
                    List<ExecPlanDetailEntity> detail = ((ExecPlanEntity)((Object)((Object)execMap.get(vo.getProjectId())))).getAllList();
                    detail.add((ExecPlanDetailEntity)((Object)vo));
                }
            });
        }
        List<Long> projectIds = execList.stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toList());
        Map<Long, ProjectVO> projectMap = this.feignUtil.getProjectMapByIds(projectIds);
        TransferVO transferVO = this.feignUtil.getTransferVO(projectIds);
        Map<Long, LightRuleEntity> lightRuleMap = this.getProjectLightRuleMap(transferVO.getProjectMap(), transferVO.getOrgMap());
        JSONArray array = new JSONArray();
        for (ExecPlanEntity entity : execMap.values()) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)entity.getId());
            obj.put("projectId", (Object)entity.getProjectId());
            obj.put("projectName", (Object)entity.getProjectName());
            obj.put("projectManagerName", (Object)entity.getProjectManagerName());
            if (projectMap.containsKey(entity.getProjectId())) {
                ProjectVO project = projectMap.get(entity.getProjectId());
                obj.put("projectName", (Object)project.getProjectName());
                obj.put("projectManagerName", (Object)this.orgUtil.getCreateUserName(project.getLeader()));
            }
            if (!(!StringUtils.isNotBlank((CharSequence)text) || !StringUtils.isEmpty((CharSequence)obj.getString("projectName")) && obj.getString("projectName").contains(text) || !StringUtils.isEmpty((CharSequence)obj.getString("projectManagerName")) && obj.getString("projectManagerName").contains(text))) continue;
            obj.put("finishDate", (Object)DateUtil.formatSeconds(new Date()));
            List<ExecPlanDetailEntity> detailList = entity.getAllList();
            List<Long> leafIds = WarnServiceImpl.getLeafIds(detailList);
            List<ExecPlanDetailEntity> leafList = detailList.stream().filter(x -> leafIds.contains(x.getId())).collect(Collectors.toList());
            Integer rootNum = (int)detailList.stream().filter(x -> x.getParentId().equals(-1L)).count();
            Integer shouldNum = (int)leafList.stream().filter(x -> WarnDateUtil.compareDate(x.getDelayFinish() != null ? x.getDelayFinish() : x.getPlanFinish(), new Date()) <= 0).count();
            Integer finishNum = (int)leafList.stream().filter(x -> x.getActualFinish() != null).count();
            Integer finishRate = ComputeUtil.bigDecimalPercent(finishNum, shouldNum, 0).intValue();
            obj.put("rootNum", (Object)rootNum);
            obj.put("shouldNum", (Object)shouldNum);
            obj.put("finishNum", (Object)finishNum);
            obj.put("finishRate", (Object)finishRate);
            this.calculateLightType(lightRuleMap, entity, leafList);
            Integer yellowNum = (int)leafList.stream().filter(x -> LightTypeEnum.\u9ec4\u706f.getCode().equals(x.getLightType())).count();
            Integer redNum = (int)leafList.stream().filter(x -> LightTypeEnum.\u7ea2\u706f.getCode().equals(x.getLightType())).count();
            Integer yellowFinishNum = (int)leafList.stream().filter(x -> LightTypeEnum.\u9ec4\u706f.getCode().equals(x.getLightType()) && x.getActualFinish() != null).count();
            Integer redFinishNum = (int)leafList.stream().filter(x -> LightTypeEnum.\u7ea2\u706f.getCode().equals(x.getLightType()) && x.getActualFinish() != null).count();
            obj.put("yellowNum", (Object)yellowNum);
            obj.put("redNum", (Object)redNum);
            obj.put("yellowFinishNum", (Object)yellowFinishNum);
            obj.put("redFinishNum", (Object)redFinishNum);
            array.add((Object)obj);
        }
        Integer redSum = array.stream().map(x -> ((JSONObject)x).getInteger("redNum")).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        Integer yellowSum = array.stream().map(x -> ((JSONObject)x).getInteger("yellowNum")).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        Integer redFinishSum = array.stream().map(x -> ((JSONObject)x).getInteger("redFinishNum")).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        Integer yellowFinishSum = array.stream().map(x -> ((JSONObject)x).getInteger("yellowFinishNum")).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        page.put("redSum", (Object)redSum);
        page.put("yellowSum", (Object)yellowSum);
        page.put("redFinishSum", (Object)redFinishSum);
        page.put("yellowFinishSum", (Object)yellowFinishSum);
        array = array.stream().sorted(Comparator.comparing(x -> ((JSONObject)x).getInteger("finishRate")).thenComparing(x -> ((JSONObject)x).getInteger("redNum"))).collect(Collectors.toCollection(JSONArray::new));
        int total = array.size();
        JSONArray records = PageUtil.listToPage(array, current, size);
        int pages = PageUtil.getPages(total, size);
        page.put("records", (Object)records);
        page.put("total", (Object)total);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public JSONObject taskFinishList(QueryParam param) {
        JSONObject page = new JSONObject();
        int current = param.getPageIndex();
        int size = param.getPageSize();
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        Long projectId = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("projectId")).getValue()));
            param.getParams().remove("projectId");
        }
        String projectName = null;
        if (param.getParams().containsKey("projectName")) {
            projectName = String.valueOf(((Parameter)param.getParams().get("projectName")).getValue());
            param.getParams().remove("projectName");
        }
        Boolean redFinish = false;
        if (param.getParams().containsKey("redFinish")) {
            redFinish = true;
            param.getParams().remove("redFinish");
        }
        if (!redFinish.booleanValue()) {
            Long parentId = -1L;
            if (param.getParams().containsKey("parentId")) {
                parentId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("parentId")).getValue()));
            }
            param.getParams().put("parentId", new Parameter("eq", (Object)parentId));
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.execPlanService.queryList(queryParam);
        ExecPlanEntity entity = (ExecPlanEntity)((Object)list.get(0));
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("employeeName");
        ArrayList<Integer> lightType = new ArrayList<Integer>();
        if (param.getParams().get("lightType") != null) {
            String[] split;
            for (String s : split = ((String)((Parameter)param.getParams().get("lightType")).getValue()).split(",")) {
                lightType.add(Integer.parseInt(s));
            }
            param.getParams().remove("lightType");
        }
        ArrayList<Object> finishStates = new ArrayList();
        if (param.getParams().get("finishState") != null) {
            String[] split = ((String)((Parameter)param.getParams().get("finishState")).getValue()).split(",");
            finishStates = new ArrayList<String>(Arrays.asList(split));
            param.getParams().remove("finishState");
        }
        param.getParams().put("progress_id", new Parameter("eq", (Object)entity.getId()));
        param.getOrderMap().put("tid", "asc");
        List nodeList = this.execPlanDetailService.queryList(param);
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("progress_id", new Parameter("eq", (Object)entity.getId()));
        detailParam.getOrderMap().put("tid", "asc");
        List detailList = this.execPlanDetailService.queryList(detailParam);
        List<Long> leafIds = WarnServiceImpl.getLeafIds(detailList);
        TransferVO transferVO = this.feignUtil.getTransferVO(new ArrayList<Long>(Arrays.asList(projectId)));
        Map<Long, LightRuleEntity> lightRuleMap = this.getProjectLightRuleMap(transferVO.getProjectMap(), transferVO.getOrgMap());
        this.calculateLightType(lightRuleMap, entity, nodeList);
        JSONArray array = new JSONArray();
        for (ExecPlanDetailEntity node : nodeList) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)node.getId());
            obj.put("projectId", (Object)projectId);
            obj.put("projectName", (Object)projectName);
            obj.put("taskLine", PlanConstant.TASK_LINE.get(node.getTaskLine()));
            obj.put("name", (Object)node.getName());
            Date planFinish = node.getDelayFinish() != null ? node.getDelayFinish() : node.getPlanFinish();
            obj.put("planFinish", (Object)DateUtil.formatDate(planFinish));
            obj.put("actualFinish", (Object)DateUtil.formatDate(node.getActualFinish()));
            obj.put("days", (Object)DateUtil.getBetweenDays(node.getActualFinish(), planFinish));
            obj.put("nodeLevel", PlanConstant.NODE_LEVEL.get(node.getNodeLevel()));
            obj.put("lightType", (Object)node.getLightType());
            obj.put("lightTypeName", PlanConstant.LIGHT_TYPE.get(node.getLightType()));
            obj.put("employeeName", (Object)node.getEmployeeName());
            if (lightType.size() > 0 && !lightType.contains(node.getLightType()) || !redFinish.booleanValue() && leafIds.contains(node.getId()) && (WarnDateUtil.compareDate(planFinish, new Date()) > 0 || node.getActualFinish() != null && WarnDateUtil.compareDate(node.getActualFinish(), new Date()) > 0) || redFinish.booleanValue() && (!leafIds.contains(node.getId()) || !LightTypeEnum.\u7ea2\u706f.getCode().equals(node.getLightType()) || node.getActualFinish() == null)) continue;
            List leafList = detailList.stream().filter(x -> leafIds.contains(x.getId()) && SeparatorUtil.isChild(x.getStructCode(), node.getStructCode())).collect(Collectors.toList());
            Integer shouldNum = (int)leafList.stream().filter(x -> WarnDateUtil.compareDate(x.getDelayFinish() != null ? x.getDelayFinish() : x.getPlanFinish(), new Date()) <= 0).count();
            Integer finishNum = (int)leafList.stream().filter(x -> x.getActualFinish() != null).count();
            Integer finishRate = ComputeUtil.bigDecimalPercent(finishNum, shouldNum, 0).intValue();
            obj.put("shouldNum", (Object)(shouldNum != 0 ? shouldNum : null));
            obj.put("finishNum", (Object)(shouldNum != 0 || finishNum != 0 ? finishNum : null));
            obj.put("finishRate", shouldNum != 0 || finishRate != 0 ? finishRate + "%" : null);
            String finishState = null;
            finishState = node.getActualStart() == null ? "\u672a\u5f00\u59cb" : (node.getActualFinish() == null ? (WarnDateUtil.compareDate(new Date(), planFinish) > 0 ? "\u5ef6\u671f" : "\u8fdb\u884c\u4e2d") : (WarnDateUtil.compareDate(node.getActualFinish(), planFinish) > 0 ? "\u5ef6\u671f\u5b8c\u6210" : "\u6309\u671f\u5b8c\u6210"));
            obj.put("finishState", (Object)finishState);
            array.add((Object)obj);
        }
        Integer unSum = (int)array.stream().map(x -> ((JSONObject)x).getString("finishState")).filter(Objects::nonNull).filter("\u672a\u5f00\u59cb"::equals).count();
        Integer yqSum = (int)array.stream().map(x -> ((JSONObject)x).getString("finishState")).filter(Objects::nonNull).filter("\u5ef6\u671f"::equals).count();
        Integer runSum = (int)array.stream().map(x -> ((JSONObject)x).getString("finishState")).filter(Objects::nonNull).filter("\u8fdb\u884c\u4e2d"::equals).count();
        Integer yqFinishSum = (int)array.stream().map(x -> ((JSONObject)x).getString("finishState")).filter(Objects::nonNull).filter("\u5ef6\u671f\u5b8c\u6210"::equals).count();
        Integer finishSum = (int)array.stream().map(x -> ((JSONObject)x).getString("finishState")).filter(Objects::nonNull).filter("\u6309\u671f\u5b8c\u6210"::equals).count();
        page.put("unSum", (Object)unSum);
        page.put("yqSum", (Object)yqSum);
        page.put("runSum", (Object)runSum);
        page.put("yqFinishSum", (Object)yqFinishSum);
        page.put("finishSum", (Object)finishSum);
        page.put("allSum", (Object)array.size());
        if (finishStates.size() > 0) {
            ArrayList<Object> finalFinishStates = finishStates;
            array = array.stream().map(x -> (JSONObject)x).filter(x -> finalFinishStates.contains(x.getString("finishState"))).collect(Collectors.toCollection(JSONArray::new));
        }
        int total = array.size();
        JSONArray records = PageUtil.listToPage(array, current, size);
        int pages = PageUtil.getPages(total, size);
        page.put("records", (Object)records);
        page.put("total", (Object)total);
        page.put("pages", (Object)pages);
        return page;
    }

    private void calculateLightType(Map<Long, LightRuleEntity> lightRuleMap, ExecPlanEntity entity, List<ExecPlanDetailEntity> detailList) {
        for (ExecPlanDetailEntity detail : detailList) {
            Date date = detail.getActualFinish() != null ? detail.getActualFinish() : new Date();
            Date planFinish = detail.getDelayFinish() != null ? detail.getDelayFinish() : detail.getPlanFinish();
            Integer days = DateUtil.getBetweenDays(date, planFinish);
            BigDecimal diffValue = new BigDecimal(days);
            LightRuleLevelEntity lightRule = null;
            if (PlanConstant.LEVEL_FIRST.equals(detail.getNodeLevel())) {
                lightRule = this.getLightRuleLevel(lightRuleMap, entity.getProjectId(), LightRuleLevelEnum.\u9879\u76ee\u5b8c\u6210\u65f6\u95f4.getCode());
            } else if (PlanConstant.LEVEL_SECOND.equals(detail.getNodeLevel()) || PlanConstant.LEVEL_THIRD.equals(detail.getNodeLevel())) {
                lightRule = this.getLightRuleLevel(lightRuleMap, entity.getProjectId(), LightRuleLevelEnum.\u6708\u8ba1\u5212\u5b8c\u6210.getCode());
            } else if (PlanConstant.LEVEL_CONTRACT.equals(detail.getNodeLevel())) {
                lightRule = this.getLightRuleLevel(lightRuleMap, entity.getProjectId(), LightRuleLevelEnum.\u5408\u540c\u8282\u70b9\u9884\u8b66.getCode());
            }
            if (null != lightRule) {
                Integer term = DateUtil.getBetweenDays(detail.getPredictFinish(), new Date());
                BigDecimal finalValue = ComputeUtil.safeDiv(diffValue, new BigDecimal(term));
                Integer lightType = this.getLightType(lightRule, diffValue, finalValue, false, 0);
                detail.setLightType(lightType);
            }
            detail.setDiffValue(diffValue);
        }
    }

    private static List<Long> getLeafIds(List<ExecPlanDetailEntity> detailList) {
        List ids = detailList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List parentIds = detailList.stream().map(ProgressDetailEntity::getParentId).distinct().collect(Collectors.toList());
        List leafIds = (List)CollectionUtils.subtract(ids, parentIds);
        return leafIds;
    }
}

