/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.service.IDayFillDetailService;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.service.IYearPlanDetailService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonHelper {
    @Autowired
    private IExecPlanService execService;
    @Autowired
    private IExecPlanDetailService execDetailService;
    @Autowired
    private IYearPlanService yearService;
    @Autowired
    private IYearPlanDetailService yearDetailService;
    @Autowired
    private IMonthPlanService monthService;
    @Autowired
    private IMonthPlanDetailService monthDetailService;
    @Autowired
    private IWeekPlanService weekService;
    @Autowired
    private IWeekPlanDetailService weekDetailService;
    @Autowired
    private IDayFillService fillService;
    @Autowired
    private IDayFillDetailService fillDetailService;

    public static <T extends ProgressDetailEntity> Map<Long, Long> getIdMap(List<T> sourceList, List<ExecPlanDetailEntity> detailList) {
        Map<Long, String> sourceMap = sourceList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getStructCode()));
        Map<String, Long> execMap = detailList.stream().collect(Collectors.toMap(x -> x.getStructCode(), x -> x.getId()));
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        String task = null;
        for (Long id : sourceMap.keySet()) {
            task = sourceMap.get(id);
            if (execMap.containsKey(task)) {
                idMap.put(id, execMap.get(task));
                continue;
            }
            idMap.put(id, id);
        }
        idMap.put(-1L, -1L);
        return idMap;
    }

    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList, Long projectId, Integer planState) {
        return this.transferDelIds(sourceList, detailList, projectId, planState, false);
    }

    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList, Long projectId, Integer planState, Boolean isDel) {
        Long sourceId;
        ArrayList<Long> delIds = new ArrayList<Long>();
        Map<String, ProgressDetailEntity> sourceMap = sourceList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, x -> x));
        Long l = sourceId = CollectionUtils.isNotEmpty(sourceList) ? ((ProgressDetailEntity)((Object)sourceList.get(0))).getProgressId() : null;
        if (CollectionUtils.isNotEmpty(detailList)) {
            ArrayList<String> delTasks = new ArrayList<String>();
            List<Object> execList = new ArrayList();
            if (isDel == null || !isDel.booleanValue()) {
                execList = detailList.stream().filter(x -> sourceId == null || x.getSourceId().equals(sourceId)).collect(Collectors.toList());
                execList.forEach(item -> {
                    if (isDel == null ? sourceMap.containsKey(item.getStructCode()) : !sourceMap.containsKey(item.getStructCode())) {
                        delIds.add(item.getId());
                        delTasks.add(item.getStructCode());
                    }
                });
                List parentIds = detailList.stream().filter(x -> x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId()) && !delIds.contains(x.getId())).map(x -> x.getParentId()).collect(Collectors.toList());
                List parentTasks = detailList.stream().filter(x -> parentIds.contains(x.getId()) && delTasks.contains(x.getStructCode())).map(x -> x.getOutlineNumber()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(parentTasks)) {
                    throw new BusinessException("\u3010" + StringUtils.join(parentTasks, (String)"\uff0c") + "\u3011\u8ba1\u5212\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff01");
                }
            } else {
                execList = detailList.stream().collect(Collectors.toList());
                execList.forEach(item -> {
                    if (sourceMap.containsKey(item.getStructCode())) {
                        delIds.add(item.getId());
                        delTasks.add(item.getStructCode());
                    }
                });
                if (CollectionUtils.isNotEmpty(delTasks)) {
                    if (planState < PlanConstant.YEAR_PLAN) {
                        this.validateYearPlan(projectId, delTasks);
                    }
                    if (planState < PlanConstant.MONTH_PLAN) {
                        this.validateMonthPlan(projectId, delTasks);
                    }
                    if (planState < PlanConstant.WEEK_PLAN) {
                        this.validateWeekPlan(projectId, delTasks);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(delTasks)) {
                this.validateDayFill(projectId, delTasks);
            }
        }
        return delIds;
    }

    private void validateYearPlan(Long projectId, List<String> delTasks) {
        List list = this.yearService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper ew = new QueryWrapper();
            ew.in((Object)"progress_id", ids);
            ew.in((Object)"struct_code", delTasks);
            List detailList = this.yearDetailService.list((Wrapper)ew);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                List detailTasks = detailList.stream().map(ProgressDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("\u3010" + StringUtils.join(detailTasks, (String)"\uff0c") + "\u3011\u8ba1\u5212\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff01");
            }
        }
    }

    private void validateMonthPlan(Long projectId, List<String> delTasks) {
        List list = this.monthService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper ew = new QueryWrapper();
            ew.in((Object)"progress_id", ids);
            ew.in((Object)"struct_code", delTasks);
            List detailList = this.monthDetailService.list((Wrapper)ew);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                List detailTasks = detailList.stream().map(ProgressDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("\u3010" + StringUtils.join(detailTasks, (String)"\uff0c") + "\u3011\u8ba1\u5212\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff01");
            }
        }
    }

    private void validateWeekPlan(Long projectId, List<String> delTasks) {
        List list = this.weekService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper ew = new QueryWrapper();
            ew.in((Object)"progress_id", ids);
            ew.in((Object)"struct_code", delTasks);
            List detailList = this.weekDetailService.list((Wrapper)ew);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                List detailTasks = detailList.stream().map(ProgressDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("\u3010" + StringUtils.join(detailTasks, (String)"\uff0c") + "\u3011\u8ba1\u5212\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff01");
            }
        }
    }

    private void validateDayFill(Long projectId, List<String> delTasks) {
        List list = this.fillService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper ew = new QueryWrapper();
            ew.in((Object)"progress_id", ids);
            ew.in((Object)"struct_code", delTasks);
            ew.eq((Object)"show_state", (Object)1);
            ew.gt((Object)"percent_complete", (Object)0);
            List detailList = this.fillDetailService.list((Wrapper)ew);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                List detailTasks = detailList.stream().map(ProgressDetailEntity::getOutlineNumber).collect(Collectors.toList());
                throw new BusinessException("\u3010" + StringUtils.join(detailTasks, (String)"\uff0c") + "\u3011\u8ba1\u5212\u5df2\u88ab\u65e5\u8fdb\u5ea6\u53cd\u9988\u5f15\u7528\uff01");
            }
        }
    }

    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, Long projectId, Integer planState) {
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)));
        if (data == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u6267\u884c\u8ba1\u5212\uff01");
        }
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)data.getId())).orderByAsc((Object)"tid"));
        return this.transferDelIds(sourceList, detailList, projectId, planState, null);
    }

    public <T extends ProgressDetailEntity> List<String> transferUseIds(List<T> sourceList, Long projectId) {
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)));
        if (data == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u6267\u884c\u8ba1\u5212\uff01");
        }
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)data.getId())).orderByAsc((Object)"tid"));
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return new ArrayList<String>();
        }
        List list = this.fillService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>();
        }
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List sourceTasks = sourceList.stream().map(ProgressDetailEntity::getStructCode).collect(Collectors.toList());
        QueryWrapper ew = new QueryWrapper();
        ew.in((Object)"progress_id", ids);
        ew.in((Object)"struct_code", sourceTasks);
        ew.eq((Object)"show_state", (Object)1);
        ew.gt((Object)"percent_complete", (Object)0);
        List fillDetailList = this.fillDetailService.list((Wrapper)ew);
        List<String> delTasks = fillDetailList.stream().map(ProgressDetailEntity::getStructCode).collect(Collectors.toList());
        return delTasks;
    }

    public void getExecClandars(HashMap hashMap, Long projectId) {
        ExecPlanVO execPlan = this.execService.queryRefDetail(projectId, null, null, null);
        hashMap.put("Calendars", JSONObject.parseArray((String)execPlan.getCalendars(), Map.class));
        hashMap.put("CalendarUID", execPlan.getCalendarUid());
    }

    public static void main(String[] args) {
        Boolean flag = null;
        System.out.println(flag == false);
        ArrayList<ExecPlanDetailEntity> detailList = new ArrayList<ExecPlanDetailEntity>();
        ExecPlanDetailEntity vo1 = new ExecPlanDetailEntity();
        vo1.setId(1L);
        vo1.setParentId(-1L);
        vo1.setStructCode("1");
        vo1.setOutlineNumber("1");
        detailList.add(vo1);
        ExecPlanDetailEntity vo2 = new ExecPlanDetailEntity();
        vo2.setId(2L);
        vo2.setParentId(1L);
        vo2.setStructCode("1&&2");
        vo2.setOutlineNumber("1.1");
        detailList.add(vo2);
        ExecPlanDetailEntity vo3 = new ExecPlanDetailEntity();
        vo3.setId(3L);
        vo3.setParentId(2L);
        vo3.setStructCode("1&&2&&3");
        vo3.setOutlineNumber("1.1.1");
        detailList.add(vo3);
        ExecPlanDetailEntity vo4 = new ExecPlanDetailEntity();
        vo4.setId(4L);
        vo4.setParentId(3L);
        vo4.setStructCode("1&&2&&3&&4");
        vo4.setOutlineNumber("1.1.1.1");
        detailList.add(vo4);
        ArrayList<Long> delIds = new ArrayList<Long>();
        delIds.add(1L);
        ArrayList<String> delTasks = new ArrayList<String>();
        delTasks.add("1");
        List parentIds = detailList.stream().filter(x -> x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId()) && !delIds.contains(x.getId())).map(x -> x.getParentId()).collect(Collectors.toList());
        List parentTasks = detailList.stream().filter(x -> parentIds.contains(x.getId()) && delTasks.contains(x.getStructCode())).map(x -> x.getOutlineNumber()).collect(Collectors.toList());
        System.out.println("\u3010" + StringUtils.join(parentTasks, (String)"\uff0c") + "\u3011\u8ba1\u5212\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
    }

    public <T extends BaseDetailVO> void validateEmployee(List<T> planDetailList) {
        List parentIds = planDetailList.stream().filter(e -> null != e.getParentTaskUID()).map(BaseDetailVO::getParentTaskUID).distinct().collect(Collectors.toList());
        List validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getUid())).collect(Collectors.toList());
        for (BaseDetailVO t : validatePlanDetailList) {
            Class<?> aClass = t.getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId", new Class[0]);
                invoke = getEmployeeId.invoke((Object)t, new Object[0]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (null != invoke) continue;
            throw new BusinessException("\u60a8\u7684\u8ba1\u5212\u4e2d\u5b58\u5728\u672b\u7ea7\u4efb\u52a1\u672a\u5173\u8054\u8d23\u4efb\u4eba");
        }
    }

    public <T extends ProgressDetailEntity> void validateEmployeeEntity(List<T> planDetailList) {
        List parentIds = planDetailList.stream().filter(e -> null != e.getParentId()).map(ProgressDetailEntity::getParentId).distinct().collect(Collectors.toList());
        List validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getId())).collect(Collectors.toList());
        for (ProgressDetailEntity t : validatePlanDetailList) {
            Class<?> aClass = ((Object)((Object)t)).getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId", new Class[0]);
                invoke = getEmployeeId.invoke((Object)t, new Object[0]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (null != invoke) continue;
            throw new BusinessException("\u60a8\u7684\u8ba1\u5212\u4e2d\u5b58\u5728\u672b\u7ea7\u4efb\u52a1\u672a\u5173\u8054\u8d23\u4efb\u4eba");
        }
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }
}

