/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.ledger.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerTemplateEntity;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerDetailMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerEquipmentMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerExamineMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerInformationMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerMaterialMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerOtherMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerQualityMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerSafetyMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerScheduleMapper;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerTypeMapper;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerTemplateService;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerEquipmentVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerExamineVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerInformationVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerMaterialVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerOtherVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerQualityVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerSafetyVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerScheduleVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerTypeVO;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerVO;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogDetailEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEquipmentEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogExamineEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogInformationEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogMaterialEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogOtherEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogQualityEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogSafetyEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogScheduleEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogTypeEntity;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogDetailMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogEquipmentMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogExamineMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogInformationMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogMaterialMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogOtherMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogQualityMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogSafetyMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogScheduleMapper;
import com.ejianc.business.probuilddiary.project.dtomapper.ProjectLogTypeMapper;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="ledgerService")
public class LedgerServiceImpl
extends BaseServiceImpl<LedgerMapper, LedgerEntity>
implements ILedgerService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SCHEDULE_WORK_TYPE = "schedule_work_type";
    private static final String TYPE_WORK_TYPE = "type_work_type";
    private static final String QUALITY_WORK_TYPE = "quality_work_type";
    private static final String SAFETY_WORK_TYPE = "safety_work_type";
    private static final String MATERIAL_WORK_TYPE = "material_work_type";
    private static final String EQUIPMENT_WORK_TYPE = "equipment_work_type";
    private static final String EXAMINE_WORK_TYPE = "examine_work_type";
    private static final String INFORMATION_WORK_TYPE = "information_work_type";
    private static final String OTHER_WORK_TYPE = "other_work_type";
    private static final String QUALITY_TITLE = "\u9700\u8981\u76f8\u5173\u65b9\uff08\u4e1a\u4e3b\u3001\u4f01\u4e1a\u3001\u9879\u76ee\u90e8\u7b49\uff09\u89e3\u51b3\u7684\u95ee\u9898";
    private static final String SAFETY_TITLE = "\u73af\u5883\uff0c\u9632\u75ab\u5de5\u4f5c\u60c5\u51b5";
    private static final String INFORMATION_TITLE = "\u672c\u65e5\u91cd\u5927\u4e8b\u9879\uff08\u5173\u952e\u8282\u70b9\u3001\u91cd\u8981\u9a8c\u6536\u3001\u91cd\u5927\u4e8b\u4ef6\u3001\u4e1a\u4e3b\u76d1\u7406\u73b0\u573a\u8981\u6c42\u7b49\uff09";
    private static final String OTHER_TITLE = "\u5de5\u4f5c\u5c0f\u7ed3\uff08\u65bd\u5de5\u8d28\u91cf\u3001\u5b89\u5168\u60c5\u51b5\uff09";
    private static final String RULE_CODE = "ZJKJ-BUILD-DIARY-LEDGER";
    private static final String PROJECT_LOG_BILL_TYPE = "EJCBT202211000002";
    private static final String LEDGER_BILL_TYPE = "EJCBT202211000003";
    private static final String EJC_BILL_ATTACHES = "ejc-bill-attaches";
    private final IBillCodeApi billCodeApi;
    private final IAttachmentApi attachmentApi;
    private final ILedgerTemplateService templateService;
    private final LedgerMapper ledgerMapper;
    private final LedgerDetailMapper ledgerDetailMapper;
    private final LedgerScheduleMapper ledgerScheduleMapper;
    private final LedgerTypeMapper ledgerTypeMapper;
    private final LedgerQualityMapper ledgerQualityMapper;
    private final LedgerSafetyMapper ledgerSafetyMapper;
    private final LedgerMaterialMapper ledgerMaterialMapper;
    private final LedgerEquipmentMapper ledgerEquipmentMapper;
    private final LedgerExamineMapper ledgerExamineMapper;
    private final LedgerInformationMapper ledgerInformationMapper;
    private final LedgerOtherMapper ledgerOtherMapper;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    public LedgerServiceImpl(IBillCodeApi billCodeApi, IAttachmentApi attachmentApi, ILedgerTemplateService templateService, LedgerMapper ledgerMapper, LedgerDetailMapper ledgerDetailMapper, LedgerScheduleMapper ledgerScheduleMapper, LedgerTypeMapper ledgerTypeMapper, LedgerQualityMapper ledgerQualityMapper, LedgerSafetyMapper ledgerSafetyMapper, LedgerMaterialMapper ledgerMaterialMapper, LedgerEquipmentMapper ledgerEquipmentMapper, LedgerExamineMapper ledgerExamineMapper, LedgerInformationMapper ledgerInformationMapper, LedgerOtherMapper ledgerOtherMapper) {
        this.billCodeApi = billCodeApi;
        this.attachmentApi = attachmentApi;
        this.templateService = templateService;
        this.ledgerMapper = ledgerMapper;
        this.ledgerDetailMapper = ledgerDetailMapper;
        this.ledgerScheduleMapper = ledgerScheduleMapper;
        this.ledgerTypeMapper = ledgerTypeMapper;
        this.ledgerQualityMapper = ledgerQualityMapper;
        this.ledgerSafetyMapper = ledgerSafetyMapper;
        this.ledgerMaterialMapper = ledgerMaterialMapper;
        this.ledgerEquipmentMapper = ledgerEquipmentMapper;
        this.ledgerExamineMapper = ledgerExamineMapper;
        this.ledgerInformationMapper = ledgerInformationMapper;
        this.ledgerOtherMapper = ledgerOtherMapper;
    }

    @Override
    public List<JSONObject> fetchOtherSubDetail(Long id) {
        LedgerTemplateEntity collect;
        LedgerTemplateEntity collect2;
        LedgerTemplateEntity collect3;
        LedgerTemplateEntity collect4;
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        LedgerEntity entity = (LedgerEntity)((Object)super.selectById((Serializable)id));
        LedgerVO ledgerVO = (LedgerVO)BeanMapper.map((Object)((Object)entity), LedgerVO.class);
        List ledgerQualityList = ledgerVO.getLedgerQualityList();
        List ledgerSafetyList = ledgerVO.getLedgerSafetyList();
        List ledgerInformationList = ledgerVO.getLedgerInformationList();
        List ledgerOtherList = ledgerVO.getLedgerOtherList();
        List ledgerTemplates = this.templateService.list();
        if (CollectionUtils.isNotEmpty((Collection)ledgerQualityList) && null != (collect4 = LedgerServiceImpl.getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE))) {
            for (Object vo : ledgerQualityList) {
                vo.setTemplateContent(collect4.getTemplateContent());
            }
        }
        JSONObject jsonObject3 = new JSONObject();
        jsonObject3.put("title", (Object)QUALITY_TITLE);
        jsonObject3.put("describe", (Object)ledgerQualityList);
        jsonObjects.add(jsonObject3);
        if (CollectionUtils.isNotEmpty((Collection)ledgerInformationList) && null != (collect3 = LedgerServiceImpl.getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE))) {
            for (Object vo : ledgerInformationList) {
                vo.setTemplateContent(collect3.getTemplateContent());
            }
        }
        JSONObject jsonObject8 = new JSONObject();
        jsonObject8.put("title", (Object)INFORMATION_TITLE);
        jsonObject8.put("describe", (Object)ledgerInformationList);
        jsonObjects.add(jsonObject8);
        if (CollectionUtils.isNotEmpty((Collection)ledgerSafetyList) && null != (collect2 = LedgerServiceImpl.getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE))) {
            for (LedgerSafetyVO vo : ledgerSafetyList) {
                vo.setTemplateContent(collect2.getTemplateContent());
            }
        }
        JSONObject jsonObject4 = new JSONObject();
        jsonObject4.put("title", (Object)SAFETY_TITLE);
        jsonObject4.put("describe", (Object)ledgerSafetyList);
        jsonObjects.add(jsonObject4);
        if (CollectionUtils.isNotEmpty((Collection)ledgerOtherList) && null != (collect = LedgerServiceImpl.getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE))) {
            for (LedgerOtherVO vo : ledgerOtherList) {
                vo.setTemplateContent(collect.getTemplateContent());
            }
        }
        JSONObject jsonObject9 = new JSONObject();
        jsonObject9.put("title", (Object)OTHER_TITLE);
        jsonObject9.put("describe", (Object)ledgerOtherList);
        jsonObjects.add(jsonObject9);
        return jsonObjects;
    }

    private static LedgerTemplateEntity getTemplateContent(List<LedgerTemplateEntity> ledgerTemplates, String type) {
        for (LedgerTemplateEntity entity : ledgerTemplates) {
            if (!type.equals(entity.getTemplateType())) continue;
            return entity;
        }
        return null;
    }

    @Override
    public LedgerEntity projectLogConvertToLedger(ProjectLogEntity entity) {
        List<BaseEntity> entityList;
        this.logger.info("\u9879\u76ee\u65e5\u5fd7\u5b9e\u4f53\u8f6c\u6362\u65e5\u5fd7\u53f0\u8d26\uff1a{}", (Object)JSON.toJSONString((Object)((Object)entity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", request.getHeader("authority"));
        headers.put("ejc-token", request.getHeader("ejc-token"));
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        LedgerEntity ledgerEntity = ProjectLogMapper.INSTANCE.transToLedgerEntity(entity);
        long targetBillId = IdWorker.getId();
        ledgerEntity.setId(targetBillId);
        ledgerEntity.setBillCode(this.generateBillCode());
        this.transportCommonAttachment(entity, headers, executorService, targetBillId);
        List<ProjectLogDetailEntity> projectLogDetailList = entity.getProjectLogDetailList();
        List<ProjectLogScheduleEntity> projectLogScheduleList = entity.getProjectLogScheduleList();
        List<ProjectLogTypeEntity> projectLogTypeList = entity.getProjectLogTypeList();
        List<ProjectLogQualityEntity> projectLogQualityList = entity.getProjectLogQualityList();
        List<ProjectLogSafetyEntity> projectLogSafetyList = entity.getProjectLogSafetyList();
        List<ProjectLogMaterialEntity> projectLogMaterialList = entity.getProjectLogMaterialList();
        List<ProjectLogEquipmentEntity> projectLogEquipmentList = entity.getProjectLogEquipmentList();
        List<ProjectLogExamineEntity> projectLogExamineList = entity.getProjectLogExamineList();
        List<ProjectLogInformationEntity> projectLogInformationList = entity.getProjectLogInformationList();
        List<ProjectLogOtherEntity> projectLogOtherList = entity.getProjectLogOtherList();
        if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
            projectLogDetailList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
                entityList = ProjectLogDetailMapper.INSTANCE.transToLedgerDetailEntity(projectLogDetailList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerDetailList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
            projectLogScheduleList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
                entityList = ProjectLogScheduleMapper.INSTANCE.transToLedgerScheduleEntity(projectLogScheduleList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerScheduleList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
            projectLogTypeList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
                entityList = ProjectLogTypeMapper.INSTANCE.transToLedgerTypeEntity(projectLogTypeList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerTypeList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
            projectLogQualityList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
                entityList = ProjectLogQualityMapper.INSTANCE.transToLedgerQualityEntity(projectLogQualityList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerQualityList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
            projectLogSafetyList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
                entityList = ProjectLogSafetyMapper.INSTANCE.transToLedgerSafetyEntity(projectLogSafetyList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerSafetyList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
            projectLogMaterialList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
                entityList = ProjectLogMaterialMapper.INSTANCE.transToLedgerMaterialEntity(projectLogMaterialList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerMaterialList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
            projectLogEquipmentList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
                entityList = ProjectLogEquipmentMapper.INSTANCE.transToLedgerEquipmentEntity(projectLogEquipmentList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerEquipmentList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
            projectLogExamineList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
                entityList = ProjectLogExamineMapper.INSTANCE.transToLedgerExamineEntity(projectLogExamineList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerExamineList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
            projectLogInformationList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
                entityList = ProjectLogInformationMapper.INSTANCE.transToLedgerInformationEntity(projectLogInformationList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerInformationList(entityList);
            }
        }
        if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
            projectLogOtherList.removeIf(e -> e.getUpdateFlag() == false);
            if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
                entityList = ProjectLogOtherMapper.INSTANCE.transToLedgerOtherEntity(projectLogOtherList);
                for (BaseEntity e2 : entityList) {
                    e2.setLedgerId(targetBillId);
                    this.transportToLedgerSub(StringUtils.isNotBlank((CharSequence)e2.getFileType()), entity.getId(), targetBillId, e2.getFileType(), headers, executorService);
                }
                ledgerEntity.setLedgerOtherList(entityList);
            }
        }
        return ledgerEntity;
    }

    private void transportAttachment(Long sourceBillId, Long targetBillId, String sourceType, HashMap<String, String> headers, ExecutorService executorService) {
        this.logger.info("\u9879\u76ee\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u65e5\u5fd7\u53f0\u8d26--start\uff0c\u5165\u53c2\uff1asourceBillId--{}\uff0ctargetBillId--{}\uff0csourceType--{}\uff0cheaders--{}", new Object[]{sourceBillId, targetBillId, sourceType, JSON.toJSONString(headers)});
        CompletableFuture.runAsync(() -> {
            this.logger.info("\u9879\u76ee\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u65e5\u5fd7\u53f0\u8d26--start");
            HashMap<String, Object> paramMaps = new HashMap<String, Object>();
            paramMaps.put("sourceBillId", sourceBillId);
            paramMaps.put("sourceBillType", PROJECT_LOG_BILL_TYPE);
            paramMaps.put("sourceBillSourceType", sourceType);
            paramMaps.put("targetBillId", targetBillId);
            paramMaps.put("targetBillType", LEDGER_BILL_TYPE);
            paramMaps.put("targetBillSourceType", sourceType);
            String responseBody = ((HttpRequest)HttpUtil.createGet((String)(this.BaseHost + "ejc-file-web/api/attachref/copyFilesFromSourceBillToTargetBill")).addHeaders((Map)headers)).form(paramMaps).execute().body();
            CommonResponse res = (CommonResponse)JSON.parseObject((String)responseBody, CommonResponse.class);
            if (!res.isSuccess()) {
                this.logger.info("\u9879\u76ee\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u65e5\u5fd7\u53f0\u8d26\u5931\u8d25\uff0csourceBillId--{}\uff0csourceBillSourceType--{}\uff0ctargetBillId--{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{sourceBillId, sourceType, targetBillId, res.getMsg()});
            }
            this.logger.info("\u9879\u76ee\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u65e5\u5fd7\u53f0\u8d26--end");
        }, executorService);
    }

    private void transportCommonAttachment(ProjectLogEntity projectLogEntity, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        CommonResponse commonResponse = this.attachmentApi.queryListBySourceId(projectLogEntity.getId(), PROJECT_LOG_BILL_TYPE, EJC_BILL_ATTACHES, null);
        this.transportToLedgerSub(commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData())), projectLogEntity.getId(), targetBillId, EJC_BILL_ATTACHES, headers, executorService);
    }

    private void transportToLedgerSub(boolean e, Long projectLogId, Long targetBillId, String sourceType, HashMap<String, String> headers, ExecutorService executorService) {
        if (e) {
            this.transportAttachment(projectLogId, targetBillId, sourceType, headers, executorService);
        }
    }

    private String generateBillCode() {
        BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)new ProjectLogVO());
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return (String)billCode.getData();
    }

    @Override
    public void handleOtherSubDetail(JSONObject detailJson) {
        JSONObject ledger = detailJson.getJSONObject("Ledger");
        this.handleLedgerSubDetail(ledger, new String[]{"LedgerSchedule", "LedgerType", "LedgerQuality", "LedgerSafety", "LedgerMaterial", "LedgerEquipment", "LedgerExamine", "LedgerInformation", "LedgerOther"});
        detailJson.put("Ledger", (Object)ledger);
        this.logger.info("\u6253\u5370\u6570\u636e\u5904\u7406\u6210\u529f\uff0cLedger--{}", (Object)JSON.toJSONString((Object)ledger, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
    }

    @Override
    public void handleLedgerSubDetail(JSONObject ledger, String[] keys) {
        List ledgerTemplates = this.templateService.list();
        block31: for (String key : keys) {
            JSONArray subData = ledger.getJSONArray(key);
            if (!CollectionUtils.isNotEmpty((Collection)subData)) continue;
            switch (key) {
                case "LedgerSchedule": 
                case "ledgerScheduleList": {
                    this.handleLedgerSchedule(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerScheduleVO.class), ledger);
                    continue block31;
                }
                case "LedgerType": 
                case "ledgerTypeList": {
                    this.handLedgerType(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerTypeVO.class), ledger);
                    continue block31;
                }
                case "LedgerQuality": 
                case "ledgerQualityList": {
                    this.handleLedgerQuality(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerQualityVO.class), ledger);
                    continue block31;
                }
                case "LedgerSafety": 
                case "ledgerSafetyList": {
                    this.handLedgerSafety(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerSafetyVO.class), ledger);
                    continue block31;
                }
                case "LedgerMaterial": 
                case "ledgerMaterialList": {
                    this.handleLedgerMaterial(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerMaterialVO.class), ledger);
                    continue block31;
                }
                case "LedgerEquipment": 
                case "ledgerEquipmentList": {
                    this.handleLedgerEquipment(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerEquipmentVO.class), ledger);
                    continue block31;
                }
                case "LedgerExamine": 
                case "ledgerExamineList": {
                    this.handleLedgerExamine(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerExamineVO.class), ledger);
                    continue block31;
                }
                case "LedgerInformation": 
                case "ledgerInformationList": {
                    this.handleLedgerInformation(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerInformationVO.class), ledger);
                    continue block31;
                }
                case "LedgerOther": 
                case "ledgerOtherList": {
                    this.handleLedgerOther(ledgerTemplates, JSONObject.parseArray((String)JSONObject.toJSONString((Object)subData), LedgerOtherVO.class), ledger);
                    continue block31;
                }
            }
        }
    }

    private void handleLedgerOther(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerOtherVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerOtherVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerOtherDescription", (Object)sb.toString());
        }
    }

    private void handleLedgerInformation(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerInformationVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerInformationVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerInformationDescription", (Object)sb.toString());
        }
    }

    private void handleLedgerExamine(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerExamineVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, EXAMINE_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerExamineVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerExamineDescription", (Object)sb.toString());
        }
    }

    private void handleLedgerEquipment(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerEquipmentVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, EQUIPMENT_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerEquipmentVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerEquipmentDescription", (Object)sb.toString());
        }
    }

    private void handleLedgerMaterial(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerMaterialVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, MATERIAL_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerMaterialVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerMaterialDescription", (Object)sb.toString());
        }
    }

    private void handLedgerSafety(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerSafetyVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerSafetyVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerSafetyDescription", (Object)sb.toString());
        }
    }

    private void handleLedgerQuality(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerQualityVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerQualityVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerQualityDescription", (Object)sb.toString());
        }
    }

    private void handLedgerType(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerTypeVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, TYPE_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerTypeVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerTypeDescription", (Object)sb.toString());
        }
    }

    private void handleLedgerSchedule(List<LedgerTemplateEntity> ledgerTemplates, List<LedgerScheduleVO> vos, JSONObject ledger) {
        String printTemplateContent;
        LedgerTemplateEntity l = LedgerServiceImpl.getTemplateContent(ledgerTemplates, SCHEDULE_WORK_TYPE);
        if (null != l && StringUtils.isNotBlank((CharSequence)(printTemplateContent = l.getPrintTemplateContent()))) {
            String[] strs = printTemplateContent.split("#");
            String last = strs[strs.length - 1];
            StringBuffer sb = new StringBuffer();
            for (LedgerScheduleVO vo : vos) {
                JSONObject js = (JSONObject)JSON.toJSON((Object)vo);
                for (String str : strs) {
                    if (js.get((Object)str) instanceof Date) {
                        Date date = (Date)js.get((Object)str);
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        if (last.equals(str)) {
                            sb.append(localDateTime.format(formatter)).append(l.getNewline());
                            continue;
                        }
                        sb.append(localDateTime.format(formatter));
                        continue;
                    }
                    if (last.equals(str)) {
                        sb.append(js.get((Object)str)).append(l.getNewline());
                        continue;
                    }
                    sb.append(js.get((Object)str));
                }
            }
            ledger.put("ledgerScheduleDescription", (Object)sb.toString());
        }
    }

    @Override
    public void deleteAllDataByProjectLogId(Long id) {
        this.ledgerMapper.deleteByProjectLogId(id);
        this.ledgerDetailMapper.deleteByProjectLogId(id);
        this.ledgerScheduleMapper.deleteByProjectLogId(id);
        this.ledgerTypeMapper.deleteByProjectLogId(id);
        this.ledgerQualityMapper.deleteByProjectLogId(id);
        this.ledgerSafetyMapper.deleteByProjectLogId(id);
        this.ledgerMaterialMapper.deleteByProjectLogId(id);
        this.ledgerEquipmentMapper.deleteByProjectLogId(id);
        this.ledgerExamineMapper.deleteByProjectLogId(id);
        this.ledgerInformationMapper.deleteByProjectLogId(id);
        this.ledgerOtherMapper.deleteByProjectLogId(id);
    }
}

