package com.ejianc.busness.zjkjscene.vo;

import java.util.Date;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工期履约填报
 * 
 * @author generator
 * 
 */
public class ScheduleReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String workArchive; // 施工阶段
    private String workArchiveName; // 施工阶段名称
    private Long performanceStateId; // 履约状态
    private String performanceStateName; // 履约状态名称
    private Boolean performanceStateNormal; // 履约状态是否正常
    private String specificReasons; // 具体原因

    private String affectTotal; // 是否影响总工期：正常：normal，是：Y，否：N
    private Long reportorId; // 填报人id
    private String reportorName; // 填报人名称
    private Long projectId; // 填报项目名称id
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reportDate; // 填报日期
    private Boolean restockReport; // 是否补充填报
    private String code; // 单据编码
    private Integer billState; // 单据状态
    

    public String getWorkArchive() {
        return workArchive;
    }

    public void setWorkArchive(String workArchive) {
        this.workArchive = workArchive;
    }

    public String getWorkArchiveName() {
        return workArchiveName;
    }

    public void setWorkArchiveName(String workArchiveName) {
        this.workArchiveName = workArchiveName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPerformanceStateId() {
        return performanceStateId;
    }
    @ReferDeserialTransfer
    public void setPerformanceStateId(Long performanceStateId) {
        this.performanceStateId = performanceStateId;
    }
    public String getPerformanceStateName() {
        return performanceStateName;
    }

    public void setPerformanceStateName(String performanceStateName) {
        this.performanceStateName = performanceStateName;
    }
    public Boolean getPerformanceStateNormal() {
        return performanceStateNormal;
    }

    public void setPerformanceStateNormal(Boolean performanceStateNormal) {
        this.performanceStateNormal = performanceStateNormal;
    }
    public String getSpecificReasons() {
        return specificReasons;
    }

    public void setSpecificReasons(String specificReasons) {
        this.specificReasons = specificReasons;
    }
    public String getAffectTotal() {
        return affectTotal;
    }

    public void setAffectTotal(String affectTotal) {
        this.affectTotal = affectTotal;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getReportorId() {
        return reportorId;
    }
    @ReferDeserialTransfer
    public void setReportorId(Long reportorId) {
        this.reportorId = reportorId;
    }
    public String getReportorName() {
        return reportorName;
    }

    public void setReportorName(String reportorName) {
        this.reportorName = reportorName;
    }
    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public Boolean getRestockReport() {
        return restockReport;
    }

    public void setRestockReport(Boolean restockReport) {
        this.restockReport = restockReport;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
