package com.ejianc.busness.zjkjscene.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.busness.zjkjscene.bean.ScheduleReportEntity;
import com.ejianc.busness.zjkjscene.service.IScheduleReportService;
import com.ejianc.busness.zjkjscene.vo.ScheduleReportVO;

/**
 * 工期履约填报
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scheduleReport")
public class ScheduleReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IScheduleReportService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScheduleReportVO> saveOrUpdate(@RequestBody ScheduleReportVO saveOrUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m-%d') = '"+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate()) +"' "));
        List<ScheduleReportEntity> list = service.queryList(param,false);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("项目【"+saveOrUpdateVO.getProjectName()+"】在【"+DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate())+"】已存在数据，请勿重复填报。");
        }
    	ScheduleReportEntity entity = BeanMapper.map(saveOrUpdateVO, ScheduleReportEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 是否补充填报：0：当天填报，1：申请补报，2：三天内补报
        if(Objects.equals(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate()),
                DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,new Date()))){
            entity.setRestockReport(0);//0：当天填报
        }else {
            entity.setRestockReport(2);//2：三天内补报
        }
        entity.setBillState(1);
    	service.saveOrUpdate(entity, false);
    	ScheduleReportVO vo = BeanMapper.map(entity, ScheduleReportVO.class);
    	return CommonResponse.success("填报成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScheduleReportVO> queryDetail(Long id) {
    	ScheduleReportEntity entity = service.selectById(id);
    	ScheduleReportVO vo = BeanMapper.map(entity, ScheduleReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScheduleReportVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ScheduleReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ScheduleReportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScheduleReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ScheduleReportEntity> page = service.queryPage(param,false);
        IPage<ScheduleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScheduleReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询报表列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryForReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryForReport(@RequestBody QueryParam param) {
        String startDay = null;
        String endDay = null;
        if(param.getParams().get("reportDate")!=null){
            startDay = param.getParams().get("reportDate").getValue().toString().split(",")[0];
            endDay = param.getParams().get("reportDate").getValue().toString().split(",")[1];
        }
        IPage<JSONObject> pageData = service.queryForReport(param.getSearchText(),startDay,endDay,param.getPageIndex(),param.getPageSize());
        if(ListUtil.isNotEmpty(pageData.getRecords())){
            processList(pageData.getRecords(),param);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/exportReport", method = RequestMethod.POST)
    @ResponseBody
    public void exportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        String startDay = null;
        String endDay = null;
        if(param.getParams().get("reportDate")!=null){
            startDay = param.getParams().get("reportDate").getValue().toString().split(",")[0];
            endDay = param.getParams().get("reportDate").getValue().toString().split(",")[1];
        }
        List<JSONObject> list = service.queryForReportAll(param.getSearchText(),startDay,endDay);
        if(ListUtil.isNotEmpty(list)){
            processList(list,param);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        if(param.getParams().get("reportDate")!=null){
            beans.put("reportDate", param.getParams().get("reportDate").getValue().toString());
        }
        ExcelExport.getInstance().export("report-export.xlsx", beans, response);
    }

    private void processList(List<JSONObject> recordList,QueryParam param){
        List<String> ids = new ArrayList<>();
        Map<Long,JSONObject> idmap = new HashMap<>();
        for (JSONObject record : recordList) {
            ids.add(record.getString("projectId"));
            idmap.put(record.getLong("projectId"),record);
        }
        param.getParams().put("projectId",new Parameter(QueryParam.IN,ids));
        List<ScheduleReportEntity> entities = service.queryList(param,false);
        for (ScheduleReportEntity entity : entities) {
            JSONObject record = idmap.get(entity.getProjectId());
            JSONObject otherReason = record.getJSONObject("otherReason");
            if(otherReason == null){
                otherReason = new JSONObject();
                record.put("otherReason",otherReason);
            }
            if(!entity.getPerformanceStateNormal()){
                if(otherReason.getInteger(entity.getPerformanceStateName()+"影响天数") == null){
                    otherReason.put(entity.getPerformanceStateName()+"影响天数",1);
                }else {
                    otherReason.put(entity.getPerformanceStateName()+"影响天数",otherReason.getInteger(entity.getPerformanceStateName()+"影响天数")+1);
                }
            }
        }
        for (JSONObject record : recordList) {
            JSONObject otherReason = record.getJSONObject("otherReason");
            if(otherReason != null){
                StringBuffer otherReasonStr = new StringBuffer();
                for (String s : otherReason.keySet()) {
                    otherReasonStr.append(s).append(":").append(otherReason.getString(s)).append("\r\n");
                }
                record.put("otherReason",otherReasonStr);
            }
        }
    }
    /**
     * 根据项目和月份，查询该月的每天的具体数据
     * */
    @RequestMapping(value = "/queryListForMobile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ScheduleReportVO>> queryListForMobile(Long projectId,String reportMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m') = '"+reportMonth+"' "));
        List<ScheduleReportEntity> page = service.queryList(param,false);
        return CommonResponse.success("查询列表数据成功！",BeanMapper.mapList(page, ScheduleReportVO.class));
    }


    /**
     * 根据项目和月份，查询该月的统计数据
     * */
    @RequestMapping(value = "/queryTotalForMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalForMonth(Long projectId,String reportMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m') = '"+reportMonth+"' "));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<ScheduleReportEntity> list = service.queryList(param,false);
        JSONObject total = new JSONObject();
        if(ListUtil.isNotEmpty(list)){
            int  normal = 0;//正常履约天数
            int  abnormal = 0;//不正常履约天数
            int  affectTotal = 0;//影响总工期天数
            for (ScheduleReportEntity entity : list) {
                if(entity.getPerformanceStateNormal()!=null && entity.getPerformanceStateNormal()){
                    normal++;
                }else{
                    abnormal++;
                }
                if("Y".equals(entity.getAffectTotal())){
                    affectTotal++;
                }
                if(total.getInteger(entity.getPerformanceStateName()+"影响天数") == null){
                    total.put(entity.getPerformanceStateName()+"影响天数",1);
                }else {
                    total.put(entity.getPerformanceStateName()+"影响天数",total.getInteger(entity.getPerformanceStateName()+"影响天数")+1);
                }
            }
            total.put("正常履约天数",normal);
            total.put("影响总工期天数",affectTotal);
            total.put("不正常履约天数",abnormal);
        }else {
            total.put("正常履约天数",0);
            total.put("影响总工期天数",0);
            total.put("不正常履约天数",0);
        }
        return CommonResponse.success("查询列表数据成功！",total);
    }



    /**
     * 根据项目和年份，查询该年的统计数据
     * */
    @RequestMapping(value = "/queryTotalForYear", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalForYear(Long projectId,String reportYear) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y') = '"+reportYear+"' "));
        JSONObject total = new JSONObject();
        List<ScheduleReportEntity> list = service.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            int  affectTotal = 0;//影响总工期天数
            int  normal = 0;//正常履约天数
            int  abnormal = 0;//不正常履约天数
            for (ScheduleReportEntity entity : list) {
                if(entity.getPerformanceStateNormal()!=null && entity.getPerformanceStateNormal()){
                    normal++;
                }else{
                    abnormal++;
                }
                if("Y".equals(entity.getAffectTotal())){
                    affectTotal++;
                }
                if(total.getInteger(entity.getPerformanceStateName()+"影响天数") == null){
                    total.put(entity.getPerformanceStateName()+"影响天数",1);
                }else {
                    total.put(entity.getPerformanceStateName()+"影响天数",total.getInteger(entity.getPerformanceStateName()+"影响天数")+1);
                }
            }
            total.put("正常履约天数",normal);
            total.put("影响总工期天数",affectTotal);
            total.put("不正常履约天数",abnormal);
        }else {
            total.put("正常履约天数",0);
            total.put("影响总工期天数",0);
            total.put("不正常履约天数",0);
        }
        return CommonResponse.success("查询列表数据成功！",total);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ScheduleReportEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ScheduleReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refScheduleReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScheduleReportVO>> refScheduleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ScheduleReportEntity> page = service.queryPage(param,false);
        IPage<ScheduleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScheduleReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
