/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.busness.zjkjscene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.busness.zjkjscene.bean.RestockApplyEntity;
import com.ejianc.busness.zjkjscene.service.IRestockApplyService;
import com.ejianc.busness.zjkjscene.service.IScheduleReportService;
import com.ejianc.busness.zjkjscene.vo.RestockApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"restockApply"})
public class RestockApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRestockApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IScheduleReportService reportService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RestockApplyVO> saveOrUpdate(@RequestBody RestockApplyVO saveOrUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("reportMonth", new Parameter("sql", (Object)(" DATE_FORMAT(report_date, '%Y-%m-%d') = '" + DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)saveOrUpdateVO.getReportDate()) + "' ")));
        param.getParams().put("projectId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectId()));
        List list = this.reportService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u9879\u76ee\u3010" + saveOrUpdateVO.getProjectName() + "\u3011\u5728\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)saveOrUpdateVO.getReportDate()) + "\u3011\u5df2\u5b58\u5728\u586b\u62a5\u6570\u636e\uff0c\u65e0\u9700\u7533\u8bf7\u586b\u62a5\u3002");
        }
        param.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        List applyEntities = this.service.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)applyEntities)) {
            throw new BusinessException("\u9879\u76ee\u3010" + saveOrUpdateVO.getProjectName() + "\u3011\u5728\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)saveOrUpdateVO.getReportDate()) + "\u3011\u5df2\u5b58\u5728\u7533\u8bf7\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u6b21\u7533\u8bf7\u586b\u62a5\u3002");
        }
        RestockApplyEntity entity = (RestockApplyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), RestockApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        RestockApplyVO vo = (RestockApplyVO)((Object)BeanMapper.map((Object)((Object)entity), RestockApplyVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RestockApplyVO> queryDetail(Long id) {
        RestockApplyEntity entity = (RestockApplyEntity)((Object)this.service.selectById(id));
        RestockApplyVO vo = (RestockApplyVO)((Object)BeanMapper.map((Object)((Object)entity), RestockApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetailForDay"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RestockApplyVO> queryDetailForDay(Long projectId, String applyDay) {
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getParams().put("reportMonth", new Parameter("sql", (Object)(" DATE_FORMAT(report_date, '%Y-%m-%d') = '" + applyDay + "' ")));
        List entities = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)entities)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map(entities.get(0), RestockApplyVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RestockApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RestockApplyVO restockApplyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RestockApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RestockApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            for (RestockApplyEntity entity : list) {
                if (Objects.equals(entity.getAffectTotal(), "N")) {
                    entity.setAffectTotal("\u5426");
                }
                if (Objects.equals(entity.getAffectTotal(), "Y")) {
                    entity.setAffectTotal("\u662f");
                }
                if (!Objects.equals(entity.getAffectTotal(), "normal")) continue;
                entity.setAffectTotal("\u6b63\u5e38");
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RestockApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRestockApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RestockApplyVO>> refRestockApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RestockApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

