package com.ejianc.busness.zjkjscene.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.busness.zjkjscene.bean.ScheduleReportEntity;
import com.ejianc.busness.zjkjscene.service.IScheduleReportService;
import com.ejianc.busness.zjkjscene.vo.ScheduleReportVO;

/**
 * 工期履约填报
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scheduleReport")
public class ScheduleReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IScheduleReportService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IZjkjProjectApi iZjkjProjectApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScheduleReportVO> saveOrUpdate(@RequestBody ScheduleReportVO saveOrUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m-%d') = '"+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate()) +"' "));
        List<ScheduleReportEntity> list = service.queryList(param,false);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("项目【"+saveOrUpdateVO.getProjectName()+"】在【"+DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate())+"】已存在数据，请勿重复填报。");
        }
    	ScheduleReportEntity entity = BeanMapper.map(saveOrUpdateVO, ScheduleReportEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setBillState(1);
    	service.saveOrUpdate(entity, false);
    	ScheduleReportVO vo = BeanMapper.map(entity, ScheduleReportVO.class);
    	return CommonResponse.success("填报成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScheduleReportVO> queryDetail(Long id) {
    	ScheduleReportEntity entity = service.selectById(id);
    	ScheduleReportVO vo = BeanMapper.map(entity, ScheduleReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScheduleReportVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ScheduleReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ScheduleReportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScheduleReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("workArchiveName");
        fuzzyFields.add("performanceStateName");
        fuzzyFields.add("specificReasons");
        fuzzyFields.add("reportorName");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<ScheduleReportEntity> page = service.queryPage(param,false);
        IPage<ScheduleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScheduleReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询报表列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryForReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryForReport(@RequestBody QueryParam param) {
        String startDay = null;
        String endDay = null;
        if(param.getParams().get("reportDate")!=null){
            startDay = param.getParams().get("reportDate").getValue().toString().split(",")[0];
            endDay = param.getParams().get("reportDate").getValue().toString().split(",")[1];
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        String orgIds = Strings.join(Arrays.stream(commonOrgIds.toArray()).map(String::valueOf).toArray(String[]::new), ",");
        IPage<JSONObject> pageData = service.queryForReport(param.getSearchText(), orgIds, startDay,endDay,param.getPageIndex(),param.getPageSize());
        if(ListUtil.isNotEmpty(pageData.getRecords())){
            processList(pageData.getRecords(),param);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/exportReport", method = RequestMethod.POST)
    @ResponseBody
    public void exportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        String startDay = null;
        String endDay = null;
        if(param.getParams().get("reportDate")!=null){
            startDay = param.getParams().get("reportDate").getValue().toString().split(",")[0];
            endDay = param.getParams().get("reportDate").getValue().toString().split(",")[1];
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        List<JSONObject> list = service.queryForReportAll(param.getSearchText(),Strings.join(Arrays.stream(commonOrgIds.toArray()).map(String::valueOf).toArray(String[]::new), ","),startDay,endDay);
        if(ListUtil.isNotEmpty(list)){
            processList(list,param);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        if(param.getParams().get("reportDate")!=null){
            beans.put("reportDate", param.getParams().get("reportDate").getValue().toString());
        }
        ExcelExport.getInstance().export("report-export.xlsx", beans, response);
    }

    private void processList(List<JSONObject> recordList,QueryParam param){

        CommonResponse<List<DefdocDetailVO>> response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("zjkj-lvyuezhuangtai",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (DefdocDetailVO defdocDetailVO : response.getData()) {
                for (JSONObject record : recordList) {
                    record.put(defdocDetailVO.getCode(),defdocDetailVO.getId());
                }
            }
        }

        List<String> ids = new ArrayList<>();
        Map<Long,JSONObject> idmap = new HashMap<>();
        for (JSONObject record : recordList) {
            ids.add(record.getString("projectId"));
            idmap.put(record.getLong("projectId"),record);
        }
        param.getParams().put("projectId",new Parameter(QueryParam.IN,ids));
        List<ScheduleReportEntity> entities = service.queryList(param,false);
        for (ScheduleReportEntity entity : entities) {
            JSONObject record = idmap.get(entity.getProjectId());
            JSONObject otherReason = record.getJSONObject("otherReason");
            if(otherReason == null){
                otherReason = new JSONObject();
                record.put("otherReason",otherReason);
            }
            if(!entity.getPerformanceStateNormal()){
                if(otherReason.getInteger(entity.getPerformanceStateName()+"影响天数") == null){
                    otherReason.put(entity.getPerformanceStateName()+"影响天数",1);
                }else {
                    otherReason.put(entity.getPerformanceStateName()+"影响天数",otherReason.getInteger(entity.getPerformanceStateName()+"影响天数")+1);
                }
            }
        }
        for (JSONObject record : recordList) {
            JSONObject otherReason = record.getJSONObject("otherReason");
            if(otherReason != null){
                StringBuffer otherReasonStr = new StringBuffer();
                for (String s : otherReason.keySet()) {
                    otherReasonStr.append(s).append(":").append(otherReason.getString(s)).append("\r\n");
                }
                record.put("otherReason",otherReasonStr);
            }
        }
    }
    /**
     * 根据项目和月份，查询该月的每天的具体数据
     * */
    @RequestMapping(value = "/queryListForMobile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ScheduleReportVO>> queryListForMobile(Long projectId,String reportMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m') = '"+reportMonth+"' "));
        List<ScheduleReportEntity> page = service.queryList(param,false);
        return CommonResponse.success("查询列表数据成功！",BeanMapper.mapList(page, ScheduleReportVO.class));
    }


    /**
     * 根据项目和月份，查询该月的统计数据
     * */
    @RequestMapping(value = "/queryTotalForMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalForMonth(Long projectId,String reportMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m') = '"+reportMonth+"' "));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<ScheduleReportEntity> list = service.queryList(param,false);
        JSONObject total = new JSONObject();
        if(ListUtil.isNotEmpty(list)){
            int  normal = 0;//正常履约天数
            int  abnormal = 0;//不正常履约天数
            int  affectTotal = 0;//影响总工期天数
            for (ScheduleReportEntity entity : list) {
                if(entity.getPerformanceStateNormal()!=null && entity.getPerformanceStateNormal()){
                    normal++;
                }else{
                    abnormal++;
                }
                if("Y".equals(entity.getAffectTotal())){
                    affectTotal++;
                }
                if(total.getInteger(entity.getPerformanceStateName()+"影响天数") == null){
                    total.put(entity.getPerformanceStateName()+"影响天数",1);
                }else {
                    total.put(entity.getPerformanceStateName()+"影响天数",total.getInteger(entity.getPerformanceStateName()+"影响天数")+1);
                }
            }
            total.put("正常履约天数",normal);
            total.put("影响总工期天数",affectTotal);
            total.put("不正常履约天数",abnormal);
        }else {
            total.put("正常履约天数",0);
            total.put("影响总工期天数",0);
            total.put("不正常履约天数",0);
        }
        return CommonResponse.success("查询列表数据成功！",total);
    }



    /**
     * 根据项目和年份，查询该年的统计数据
     * */
    @RequestMapping(value = "/queryTotalForYear", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalForYear(Long projectId,String reportYear) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y') = '"+reportYear+"' "));
        JSONObject total = new JSONObject();
        List<ScheduleReportEntity> list = service.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            int  affectTotal = 0;//影响总工期天数
            int  normal = 0;//正常履约天数
            int  abnormal = 0;//不正常履约天数
            for (ScheduleReportEntity entity : list) {
                if(entity.getPerformanceStateNormal()!=null && entity.getPerformanceStateNormal()){
                    normal++;
                }else{
                    abnormal++;
                }
                if("Y".equals(entity.getAffectTotal())){
                    affectTotal++;
                }
                if(total.getInteger(entity.getPerformanceStateName()+"影响天数") == null){
                    total.put(entity.getPerformanceStateName()+"影响天数",1);
                }else {
                    total.put(entity.getPerformanceStateName()+"影响天数",total.getInteger(entity.getPerformanceStateName()+"影响天数")+1);
                }
            }
            total.put("正常履约天数",normal);
            total.put("影响总工期天数",affectTotal);
            total.put("不正常履约天数",abnormal);
        }else {
            total.put("正常履约天数",0);
            total.put("影响总工期天数",0);
            total.put("不正常履约天数",0);
        }
        return CommonResponse.success("查询列表数据成功！",total);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("projectName");
        fuzzyFields.add("workArchiveName");
        fuzzyFields.add("performanceStateName");
        fuzzyFields.add("specificReasons");
        fuzzyFields.add("reportorName");
        fuzzyFields.add("code");
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ScheduleReportEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        if(ListUtil.isNotEmpty(list)){
            for (ScheduleReportEntity entity : list) {
                if(Objects.equals(entity.getAffectTotal(), "Y")){
                    entity.setAffectTotal("是");
                }
                if(Objects.equals(entity.getAffectTotal(), "N")){
                    entity.setAffectTotal("否");
                }
                if(Objects.equals(entity.getAffectTotal(), "normal")){
                    entity.setAffectTotal("正常");
                }
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("ScheduleReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refScheduleReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScheduleReportVO>> refScheduleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ScheduleReportEntity> page = service.queryPage(param,false);
        IPage<ScheduleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScheduleReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @RequestMapping(value = "/queryDataForBigScreen", method = RequestMethod.GET)
     @ResponseBody
     public CommonResponse<JSONObject> queryDataForBigScreen(@RequestParam(required = false) String orgName){
        if(StringUtils.isEmpty(orgName)){
            orgName = "中建科技集团有限公司";
        }
        CommonResponse<OrgVO> response = iOrgApi.findByNameAndTenantId(orgName,InvocationInfoProxy.getTenantid());
        if(!response.isSuccess() || response.getData() == null){
            return CommonResponse.error("查询组织失败！");
        }
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(response.getData().getId()), true, "查询失败，获取当前本下组织信息失败。");
        QueryParam param = new QueryParam();
        /** 本下实施单位 */
        param.getParams().put("build", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 项目状态：在建*/
        param.getParams().put("status", new Parameter(QueryParam.EQ, "1"));
        /** 项目类型：施工类*/
        param.getParams().put("projectType", new Parameter(QueryParam.EQ, "施工类"));
        CommonResponse<List<ProjectVO>> commonResponse = iZjkjProjectApi.queryProjectsByParma(param);
        if(!commonResponse.isSuccess()){
            return CommonResponse.error("查询项目信息失败！");
        }
        JSONObject result = new JSONObject();
        result.put("buildingNum",commonResponse.getData().size());//在建项目数量
        QueryParam reportParam = new QueryParam();
        List<ScheduleReportEntity> reportEntities = new ArrayList<>();
        if(ListUtil.isNotEmpty(commonResponse.getData())){
            List<Long> projectIds = commonResponse.getData().stream().map(ProjectVO::getId).collect(Collectors.toList());
            reportParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
            reportEntities = service.queryList(reportParam,false);
            logger.info("查询组织-{}，reportEntities-{},projectIds-{}",orgName,JSONObject.toJSONString(reportEntities),JSONObject.toJSONString(projectIds));
        }else {
            logger.info("查询组织-{}，reportEntities-{}",orgName,JSONObject.toJSONString(reportEntities));
        }
        List<String> xData = new ArrayList<>();
        xData.add("正常");
        xData.add("业主原因");
        xData.add("我方原因");
        xData.add("政府管控");
        xData.add("不可抗力");
        List<JSONObject> pieData = new ArrayList<>();
        if(ListUtil.isEmpty(reportEntities)){
            result.put("nowNum",0);//当前数量
            List<Integer> yData = new ArrayList<>();
            yData.add(0);
            yData.add(0);
            yData.add(0);
            yData.add(0);
            yData.add(0);
            result.put("xData",xData);////柱状图x轴数据
            result.put("yData",yData);////柱状图y轴数据
            JSONObject pieNormal = new JSONObject();
            pieNormal.put("value",0);
            pieNormal.put("name","正常");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",0);
            pieNormal.put("name","业主原因");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",0);
            pieNormal.put("name","我方原因");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",0);
            pieNormal.put("name","政府管控");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",0);
            pieNormal.put("name","不可抗力");
            pieData.add(pieNormal);
            result.put("pieData",pieData);//饼图数据
            result.put("projectIds",new ArrayList<>());//项目id
        }else {
            List<Long> projectIds = new ArrayList<>();
            int normalNum = 0;
            int yzyyNum = 0;
            int wfyyNum = 0;
            int zfyyNum = 0;
            int bkklNum = 0;
            for (ScheduleReportEntity entity : reportEntities) {
                if(!projectIds.contains(entity.getProjectId())){
                    projectIds.add(entity.getProjectId());
                }
                if(("正常").equals(entity.getPerformanceStateName())){
                    normalNum++;
                }
                if(("业主原因").equals(entity.getPerformanceStateName())){
                    yzyyNum++;
                }
                if(("我方原因").equals(entity.getPerformanceStateName())){
                    wfyyNum++;
                }
                if(("政府管控").equals(entity.getPerformanceStateName())){
                    zfyyNum++;
                }
                if(("不可抗力").equals(entity.getPerformanceStateName())){
                    bkklNum++;
                }
            }
            result.put("nowNum",projectIds.size());//当前数量
            List<Integer> yData = new ArrayList<>();
            yData.add(normalNum);
            yData.add(yzyyNum);
            yData.add(wfyyNum);
            yData.add(zfyyNum);
            yData.add(bkklNum);
            result.put("xData",xData);//柱状图x轴数据
            result.put("yData",yData);//柱状图y轴数据
            JSONObject pieNormal = new JSONObject();
            pieNormal.put("value",normalNum);
            pieNormal.put("name","正常");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",yzyyNum);
            pieNormal.put("name","业主原因");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",wfyyNum);
            pieNormal.put("name","我方原因");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",zfyyNum);
            pieNormal.put("name","政府管控");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value",bkklNum);
            pieNormal.put("name","不可抗力");
            pieData.add(pieNormal);
            result.put("pieData",pieData);//饼图数据
            result.put("projectIds",projectIds);//项目id
        }
        return CommonResponse.success("查询数据成功！",result);
     }
}
