/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.busness.zjkjscene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.busness.zjkjscene.bean.ScheduleReportEntity;
import com.ejianc.busness.zjkjscene.service.IScheduleReportService;
import com.ejianc.busness.zjkjscene.vo.ScheduleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import joptsimple.internal.Strings;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheduleReport"})
public class ScheduleReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IScheduleReportService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IZjkjProjectApi iZjkjProjectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ScheduleReportVO> saveOrUpdate(@RequestBody ScheduleReportVO saveOrUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectId()));
        param.getParams().put("reportMonth", new Parameter("sql", (Object)(" DATE_FORMAT(report_date, '%Y-%m-%d') = '" + DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)saveOrUpdateVO.getReportDate()) + "' ")));
        List list = this.service.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u9879\u76ee\u3010" + saveOrUpdateVO.getProjectName() + "\u3011\u5728\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)saveOrUpdateVO.getReportDate()) + "\u3011\u5df2\u5b58\u5728\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u586b\u62a5\u3002");
        }
        ScheduleReportEntity entity = (ScheduleReportEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ScheduleReportEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillState(1);
        this.service.saveOrUpdate((Object)entity, false);
        ScheduleReportVO vo = (ScheduleReportVO)((Object)BeanMapper.map((Object)((Object)entity), ScheduleReportVO.class));
        return CommonResponse.success((String)"\u586b\u62a5\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ScheduleReportVO> queryDetail(Long id) {
        ScheduleReportEntity entity = (ScheduleReportEntity)((Object)this.service.selectById(id));
        ScheduleReportVO vo = (ScheduleReportVO)((Object)BeanMapper.map((Object)((Object)entity), ScheduleReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScheduleReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ScheduleReportVO scheduleReportVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ScheduleReportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("workArchiveName");
        fuzzyFields.add("performanceStateName");
        fuzzyFields.add("specificReasons");
        fuzzyFields.add("reportorName");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.forEach(org -> commonOrgIds.add(org.getId()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScheduleReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryForReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryForReport(@RequestBody QueryParam param) {
        String startDay = null;
        String endDay = null;
        if (param.getParams().get("reportDate") != null) {
            startDay = ((Parameter)param.getParams().get("reportDate")).getValue().toString().split(",")[0];
            endDay = ((Parameter)param.getParams().get("reportDate")).getValue().toString().split(",")[1];
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.forEach(org -> commonOrgIds.add(org.getId()));
        String orgIds = Strings.join((String[])((String[])Arrays.stream(commonOrgIds.toArray()).map(String::valueOf).toArray(String[]::new)), (String)",");
        IPage<JSONObject> pageData = this.service.queryForReport(param.getSearchText(), orgIds, startDay, endDay, param.getPageIndex(), param.getPageSize());
        if (ListUtil.isNotEmpty((List)pageData.getRecords())) {
            this.processList(pageData.getRecords(), param);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/exportReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        String startDay = null;
        String endDay = null;
        if (param.getParams().get("reportDate") != null) {
            startDay = ((Parameter)param.getParams().get("reportDate")).getValue().toString().split(",")[0];
            endDay = ((Parameter)param.getParams().get("reportDate")).getValue().toString().split(",")[1];
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.forEach(org -> commonOrgIds.add(org.getId()));
        List<JSONObject> list = this.service.queryForReportAll(param.getSearchText(), Strings.join((String[])((String[])Arrays.stream(commonOrgIds.toArray()).map(String::valueOf).toArray(String[]::new)), (String)","), startDay, endDay);
        if (ListUtil.isNotEmpty(list)) {
            this.processList(list, param);
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        if (param.getParams().get("reportDate") != null) {
            beans.put("reportDate", ((Parameter)param.getParams().get("reportDate")).getValue().toString());
        }
        ExcelExport.getInstance().export("report-export.xlsx", beans, response);
    }

    private void processList(List<JSONObject> recordList, QueryParam param) {
        CommonResponse response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("zjkj-lvyuezhuangtai", Long.valueOf(999999L));
        if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (DefdocDetailVO defdocDetailVO : (List)response.getData()) {
                for (JSONObject record : recordList) {
                    record.put(defdocDetailVO.getCode(), (Object)defdocDetailVO.getId());
                }
            }
        }
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<Long, JSONObject> idmap = new HashMap<Long, JSONObject>();
        for (JSONObject record : recordList) {
            ids.add(record.getString("projectId"));
            idmap.put(record.getLong("projectId"), record);
        }
        param.getParams().put("projectId", new Parameter("in", ids));
        List entities = this.service.queryList(param, false);
        for (ScheduleReportEntity entity : entities) {
            JSONObject record = (JSONObject)idmap.get(entity.getProjectId());
            JSONObject otherReason = record.getJSONObject("otherReason");
            if (otherReason == null) {
                otherReason = new JSONObject();
                record.put("otherReason", (Object)otherReason);
            }
            if (entity.getPerformanceStateNormal().booleanValue()) continue;
            if (otherReason.getInteger(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570") == null) {
                otherReason.put(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570", (Object)1);
                continue;
            }
            otherReason.put(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570", (Object)(otherReason.getInteger(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570") + 1));
        }
        for (JSONObject record : recordList) {
            JSONObject otherReason = record.getJSONObject("otherReason");
            if (otherReason == null) continue;
            StringBuffer otherReasonStr = new StringBuffer();
            for (String s : otherReason.keySet()) {
                otherReasonStr.append(s).append(":").append(otherReason.getString(s)).append("\r\n");
            }
            record.put("otherReason", (Object)otherReasonStr);
        }
    }

    @RequestMapping(value={"/queryListForMobile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ScheduleReportVO>> queryListForMobile(Long projectId, String reportMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getParams().put("reportMonth", new Parameter("sql", (Object)(" DATE_FORMAT(report_date, '%Y-%m') = '" + reportMonth + "' ")));
        List page = this.service.queryList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)page, ScheduleReportVO.class));
    }

    @RequestMapping(value={"/queryTotalForMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalForMonth(Long projectId, String reportMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("reportMonth", new Parameter("sql", (Object)(" DATE_FORMAT(report_date, '%Y-%m') = '" + reportMonth + "' ")));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.service.queryList(param, false);
        JSONObject total = new JSONObject();
        if (ListUtil.isNotEmpty((List)list)) {
            int normal = 0;
            int abnormal = 0;
            int affectTotal = 0;
            for (ScheduleReportEntity entity : list) {
                if (entity.getPerformanceStateNormal() != null && entity.getPerformanceStateNormal().booleanValue()) {
                    ++normal;
                } else {
                    ++abnormal;
                }
                if ("Y".equals(entity.getAffectTotal())) {
                    ++affectTotal;
                }
                if (total.getInteger(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570") == null) {
                    total.put(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570", (Object)1);
                    continue;
                }
                total.put(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570", (Object)(total.getInteger(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570") + 1));
            }
            total.put("\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)normal);
            total.put("\u5f71\u54cd\u603b\u5de5\u671f\u5929\u6570", (Object)affectTotal);
            total.put("\u4e0d\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)abnormal);
        } else {
            total.put("\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)0);
            total.put("\u5f71\u54cd\u603b\u5de5\u671f\u5929\u6570", (Object)0);
            total.put("\u4e0d\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)0);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"/queryTotalForYear"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalForYear(Long projectId, String reportYear) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getParams().put("reportMonth", new Parameter("sql", (Object)(" DATE_FORMAT(report_date, '%Y') = '" + reportYear + "' ")));
        JSONObject total = new JSONObject();
        List list = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            int affectTotal = 0;
            int normal = 0;
            int abnormal = 0;
            for (ScheduleReportEntity entity : list) {
                if (entity.getPerformanceStateNormal() != null && entity.getPerformanceStateNormal().booleanValue()) {
                    ++normal;
                } else {
                    ++abnormal;
                }
                if ("Y".equals(entity.getAffectTotal())) {
                    ++affectTotal;
                }
                if (total.getInteger(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570") == null) {
                    total.put(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570", (Object)1);
                    continue;
                }
                total.put(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570", (Object)(total.getInteger(entity.getPerformanceStateName() + "\u5f71\u54cd\u5929\u6570") + 1));
            }
            total.put("\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)normal);
            total.put("\u5f71\u54cd\u603b\u5de5\u671f\u5929\u6570", (Object)affectTotal);
            total.put("\u4e0d\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)abnormal);
        } else {
            total.put("\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)0);
            total.put("\u5f71\u54cd\u603b\u5de5\u671f\u5929\u6570", (Object)0);
            total.put("\u4e0d\u6b63\u5e38\u5c65\u7ea6\u5929\u6570", (Object)0);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("projectName");
        fuzzyFields.add("workArchiveName");
        fuzzyFields.add("performanceStateName");
        fuzzyFields.add("specificReasons");
        fuzzyFields.add("reportorName");
        fuzzyFields.add("code");
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (ListUtil.isNotEmpty((List)list)) {
            for (ScheduleReportEntity entity : list) {
                if (Objects.equals(entity.getAffectTotal(), "Y")) {
                    entity.setAffectTotal("\u662f");
                }
                if (Objects.equals(entity.getAffectTotal(), "N")) {
                    entity.setAffectTotal("\u5426");
                }
                if (!Objects.equals(entity.getAffectTotal(), "normal")) continue;
                entity.setAffectTotal("\u6b63\u5e38");
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("ScheduleReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refScheduleReportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ScheduleReportVO>> refScheduleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScheduleReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDataForBigScreen"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDataForBigScreen(@RequestParam(required=false) String orgName) {
        CommonResponse response;
        if (StringUtils.isEmpty((CharSequence)orgName)) {
            orgName = "\u4e2d\u5efa\u79d1\u6280\u96c6\u56e2\u6709\u9650\u516c\u53f8";
        }
        if (!(response = this.iOrgApi.findByNameAndTenantId(orgName, InvocationInfoProxy.getTenantid())).isSuccess() || response.getData() == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff01");
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(((OrgVO)response.getData()).getId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        QueryParam param = new QueryParam();
        param.getParams().put("build", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("status", new Parameter("eq", (Object)"1"));
        param.getParams().put("projectType", new Parameter("eq", (Object)"\u65bd\u5de5\u7c7b"));
        CommonResponse commonResponse = this.iZjkjProjectApi.queryProjectsByParma(param);
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        JSONObject result = new JSONObject();
        result.put("buildingNum", (Object)((List)commonResponse.getData()).size());
        QueryParam reportParam = new QueryParam();
        List reportEntities = new ArrayList();
        if (ListUtil.isNotEmpty((List)((List)commonResponse.getData()))) {
            List projectIds = ((List)commonResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            reportParam.getParams().put("projectId", new Parameter("in", projectIds));
            reportEntities = this.service.queryList(reportParam, false);
            this.logger.info("\u67e5\u8be2\u7ec4\u7ec7-{}\uff0creportEntities-{},projectIds-{}", new Object[]{orgName, JSONObject.toJSONString(reportEntities), JSONObject.toJSONString(projectIds)});
        } else {
            this.logger.info("\u67e5\u8be2\u7ec4\u7ec7-{}\uff0creportEntities-{}", (Object)orgName, (Object)JSONObject.toJSONString(reportEntities));
        }
        ArrayList<String> xData = new ArrayList<String>();
        xData.add("\u6b63\u5e38");
        xData.add("\u4e1a\u4e3b\u539f\u56e0");
        xData.add("\u6211\u65b9\u539f\u56e0");
        xData.add("\u653f\u5e9c\u7ba1\u63a7");
        xData.add("\u4e0d\u53ef\u6297\u529b");
        ArrayList<JSONObject> pieData = new ArrayList<JSONObject>();
        if (ListUtil.isEmpty(reportEntities)) {
            result.put("nowNum", (Object)0);
            ArrayList<Integer> yData = new ArrayList<Integer>();
            yData.add(0);
            yData.add(0);
            yData.add(0);
            yData.add(0);
            yData.add(0);
            result.put("xData", xData);
            result.put("yData", yData);
            JSONObject pieNormal = new JSONObject();
            pieNormal.put("value", (Object)0);
            pieNormal.put("name", (Object)"\u6b63\u5e38");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)0);
            pieNormal.put("name", (Object)"\u4e1a\u4e3b\u539f\u56e0");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)0);
            pieNormal.put("name", (Object)"\u6211\u65b9\u539f\u56e0");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)0);
            pieNormal.put("name", (Object)"\u653f\u5e9c\u7ba1\u63a7");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)0);
            pieNormal.put("name", (Object)"\u4e0d\u53ef\u6297\u529b");
            pieData.add(pieNormal);
            result.put("pieData", pieData);
            result.put("projectIds", new ArrayList());
        } else {
            ArrayList<Long> projectIds = new ArrayList<Long>();
            int normalNum = 0;
            int yzyyNum = 0;
            int wfyyNum = 0;
            int zfyyNum = 0;
            int bkklNum = 0;
            for (ScheduleReportEntity entity : reportEntities) {
                if (!projectIds.contains(entity.getProjectId())) {
                    projectIds.add(entity.getProjectId());
                }
                if ("\u6b63\u5e38".equals(entity.getPerformanceStateName())) {
                    ++normalNum;
                }
                if ("\u4e1a\u4e3b\u539f\u56e0".equals(entity.getPerformanceStateName())) {
                    ++yzyyNum;
                }
                if ("\u6211\u65b9\u539f\u56e0".equals(entity.getPerformanceStateName())) {
                    ++wfyyNum;
                }
                if ("\u653f\u5e9c\u7ba1\u63a7".equals(entity.getPerformanceStateName())) {
                    ++zfyyNum;
                }
                if (!"\u4e0d\u53ef\u6297\u529b".equals(entity.getPerformanceStateName())) continue;
                ++bkklNum;
            }
            result.put("nowNum", (Object)projectIds.size());
            ArrayList<Integer> yData = new ArrayList<Integer>();
            yData.add(normalNum);
            yData.add(yzyyNum);
            yData.add(wfyyNum);
            yData.add(zfyyNum);
            yData.add(bkklNum);
            result.put("xData", xData);
            result.put("yData", yData);
            JSONObject pieNormal = new JSONObject();
            pieNormal.put("value", (Object)normalNum);
            pieNormal.put("name", (Object)"\u6b63\u5e38");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)yzyyNum);
            pieNormal.put("name", (Object)"\u4e1a\u4e3b\u539f\u56e0");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)wfyyNum);
            pieNormal.put("name", (Object)"\u6211\u65b9\u539f\u56e0");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)zfyyNum);
            pieNormal.put("name", (Object)"\u653f\u5e9c\u7ba1\u63a7");
            pieData.add(pieNormal);
            pieNormal = new JSONObject();
            pieNormal.put("value", (Object)bkklNum);
            pieNormal.put("name", (Object)"\u4e0d\u53ef\u6297\u529b");
            pieData.add(pieNormal);
            result.put("pieData", pieData);
            result.put("projectIds", projectIds);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/queryModalDataForBigScreen"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ScheduleReportVO>> queryModalDataForBigScreen(@RequestBody JSONObject object) {
        QueryParam reportParam = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)object.getString("performanceStateName"))) {
            reportParam.getParams().put("performanceStateName", new Parameter("eq", (Object)object.getString("performanceStateName")));
        }
        if (object.getJSONArray("projectIds") != null && !object.getJSONArray("projectIds").isEmpty()) {
            List projectIds = object.getJSONArray("projectIds").stream().map(Object::toString).collect(Collectors.toList());
            reportParam.getParams().put("projectId", new Parameter("in", projectIds));
        }
        reportParam.getOrderMap().put("projectId", "desc");
        reportParam.getOrderMap().put("reportDate", "desc");
        List reportEntities = this.service.queryList(reportParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)reportEntities, ScheduleReportVO.class));
    }
}

