package com.ejianc.busness.zjkjscene.controller;

import java.io.Serializable;

import com.ejianc.busness.zjkjscene.bean.ScheduleReportEntity;
import com.ejianc.busness.zjkjscene.service.IScheduleReportService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.busness.zjkjscene.bean.RestockApplyEntity;
import com.ejianc.busness.zjkjscene.service.IRestockApplyService;
import com.ejianc.busness.zjkjscene.vo.RestockApplyVO;

/**
 * 工期履约补报申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("restockApply")
public class RestockApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRestockApplyService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IScheduleReportService reportService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RestockApplyVO> saveOrUpdate(@RequestBody RestockApplyVO saveOrUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m-%d') = '"+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate()) +"' "));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
        List<ScheduleReportEntity> list = reportService.queryList(param,false);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("项目【"+saveOrUpdateVO.getProjectName()+"】在【"+DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate())+"】已存在填报数据，无需申请填报。");
        }
        param.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        List<RestockApplyEntity> applyEntities = service.queryList(param,false);
        if(CollectionUtils.isNotEmpty(applyEntities)){
            throw new BusinessException("项目【"+saveOrUpdateVO.getProjectName()+"】在【"+DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,saveOrUpdateVO.getReportDate())+"】已存在申请数据，不能再次申请填报。");
        }
    	RestockApplyEntity entity = BeanMapper.map(saveOrUpdateVO, RestockApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RestockApplyVO vo = BeanMapper.map(entity, RestockApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RestockApplyVO> queryDetail(Long id) {
    	RestockApplyEntity entity = service.selectById(id);
    	RestockApplyVO vo = BeanMapper.map(entity, RestockApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description queryDetailForDay 根据项目id和日期，查询申请详情
     * @param projectId
     * @param applyDay
     */
    @RequestMapping(value = "/queryDetailForDay", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RestockApplyVO> queryDetailForDay(Long projectId,String applyDay) {
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("reportMonth", new Parameter(QueryParam.SQL, " DATE_FORMAT(report_date, '%Y-%m-%d') = '"+applyDay+"' "));
    	List<RestockApplyEntity> entities = service.queryList(param,false);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.success("查询详情数据成功！",BeanMapper.map(entities.get(0), RestockApplyVO.class));
        }
        return CommonResponse.success("查询详情数据成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RestockApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (RestockApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RestockApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RestockApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("workArchiveName");
        fuzzyFields.add("specificReasons");
        fuzzyFields.add("reportorName");
        fuzzyFields.add("performanceStateName");
        fuzzyFields.add("code");
        fuzzyFields.add("applyReason");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<RestockApplyEntity> page = service.queryPage(param,false);
        IPage<RestockApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RestockApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("projectName");
        fuzzyFields.add("workArchiveName");
        fuzzyFields.add("specificReasons");
        fuzzyFields.add("reportorName");
        fuzzyFields.add("performanceStateName");
        fuzzyFields.add("code");
        fuzzyFields.add("applyReason");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<RestockApplyEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list)){
            for (RestockApplyEntity entity : list) {
                if(Objects.equals(entity.getAffectTotal(), "N")){
                    entity.setAffectTotal("否");
                }
                if(Objects.equals(entity.getAffectTotal(), "Y")){
                    entity.setAffectTotal("是");
                }
                if(Objects.equals(entity.getAffectTotal(), "normal")){
                    entity.setAffectTotal("正常");
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RestockApply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRestockApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RestockApplyVO>> refRestockApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RestockApplyEntity> page = service.queryPage(param,false);
        IPage<RestockApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RestockApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
